/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.jetbrains.annotations.Nullable;

public class BlockStateUtils {
    private static final List<Block> blackListBlock = new ArrayList<Block>(){
        {
            this.add(Blocks.COCOA);
            this.add(Blocks.END_PORTAL_FRAME);
            this.add(Blocks.ATTACHED_MELON_STEM);
            this.add(Blocks.ATTACHED_PUMPKIN_STEM);
            this.add(Blocks.PISTON_HEAD);
            this.add(Blocks.MOVING_PISTON);
            this.add(Blocks.VINE);
            this.add(Blocks.BLUE_BED);
            this.add(Blocks.BLACK_BED);
            this.add(Blocks.CYAN_BED);
            this.add(Blocks.BROWN_BED);
            this.add(Blocks.GRAY_BED);
            this.add(Blocks.GREEN_BED);
            this.add(Blocks.LIGHT_BLUE_BED);
            this.add(Blocks.LIGHT_GRAY_BED);
            this.add(Blocks.LIME_BED);
            this.add(Blocks.MAGENTA_BED);
            this.add(Blocks.ORANGE_BED);
            this.add(Blocks.PINK_BED);
            this.add(Blocks.PURPLE_BED);
            this.add(Blocks.RED_BED);
            this.add(Blocks.WHITE_BED);
            this.add(Blocks.YELLOW_BED);
        }
    };

    @Nullable
    public static BlockState getNextState(BlockState state) {
        BlockState newState = null;
        if ((state.getBlock() == Blocks.CHEST || state.getBlock() == Blocks.TRAPPED_CHEST) && state.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
            return null;
        }
        if ((state.getBlock() == Blocks.PISTON || state.getBlock() == Blocks.STICKY_PISTON) && ((Boolean)state.getValue((Property)PistonBaseBlock.EXTENDED)).booleanValue()) {
            return null;
        }
        if (blackListBlock.contains(state.getBlock())) {
            return null;
        }
        if (state.hasProperty((Property)BlockStateProperties.SLAB_TYPE)) {
            SlabType slabType = switch ((SlabType)state.getValue((Property)BlockStateProperties.SLAB_TYPE)) {
                case SlabType.TOP -> SlabType.BOTTOM;
                case SlabType.BOTTOM -> SlabType.TOP;
                default -> (SlabType)state.getValue((Property)BlockStateProperties.SLAB_TYPE);
            };
            newState = (BlockState)state.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)slabType);
        } else if (state.hasProperty((Property)BlockStateProperties.ROTATION_16)) {
            int rot = (Integer)state.getValue((Property)BlockStateProperties.ROTATION_16) + 1;
            if (rot == 16) {
                rot = 0;
            }
            newState = (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rot));
        } else if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
            Direction.Axis axis = switch ((Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS)) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> Direction.Axis.Y;
                case Direction.Axis.Y -> Direction.Axis.Z;
                case Direction.Axis.Z -> Direction.Axis.X;
            };
            newState = (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)axis);
        } else if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            Direction direction = switch ((Direction)state.getValue((Property)BlockStateProperties.FACING)) {
                default -> throw new MatchException(null, null);
                case Direction.UP -> Direction.NORTH;
                case Direction.NORTH -> Direction.EAST;
                case Direction.EAST -> Direction.SOUTH;
                case Direction.SOUTH -> Direction.WEST;
                case Direction.WEST -> Direction.DOWN;
                case Direction.DOWN -> Direction.UP;
            };
            newState = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)direction);
        } else if (state.hasProperty((Property)BlockStateProperties.FACING_HOPPER)) {
            Direction direction = switch ((Direction)state.getValue((Property)BlockStateProperties.FACING_HOPPER)) {
                case Direction.DOWN -> Direction.NORTH;
                case Direction.NORTH -> Direction.EAST;
                case Direction.EAST -> Direction.SOUTH;
                case Direction.SOUTH -> Direction.WEST;
                case Direction.WEST -> Direction.DOWN;
                default -> (Direction)state.getValue((Property)BlockStateProperties.FACING_HOPPER);
            };
            newState = (BlockState)state.setValue((Property)BlockStateProperties.FACING_HOPPER, (Comparable)direction);
        } else if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            Direction direction = switch ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                case Direction.NORTH -> Direction.EAST;
                case Direction.EAST -> Direction.SOUTH;
                case Direction.SOUTH -> Direction.WEST;
                case Direction.WEST -> Direction.NORTH;
                default -> (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            };
            newState = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction);
            if (state.hasProperty((Property)BlockStateProperties.HALF) && state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == Direction.NORTH) {
                Half blockHalf = (Half)state.getValue((Property)BlockStateProperties.HALF);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HALF, (Comparable)(blockHalf == Half.TOP ? Half.BOTTOM : Half.TOP));
            }
        } else if (state.hasProperty((Property)BlockStateProperties.RAIL_SHAPE_STRAIGHT)) {
            RailShape railShape = switch ((RailShape)state.getValue((Property)BlockStateProperties.RAIL_SHAPE_STRAIGHT)) {
                case RailShape.NORTH_SOUTH -> RailShape.EAST_WEST;
                case RailShape.EAST_WEST -> RailShape.NORTH_SOUTH;
                default -> (RailShape)state.getValue((Property)BlockStateProperties.RAIL_SHAPE_STRAIGHT);
            };
            newState = (BlockState)state.setValue((Property)BlockStateProperties.RAIL_SHAPE_STRAIGHT, (Comparable)railShape);
        } else if (state.hasProperty((Property)BlockStateProperties.RAIL_SHAPE)) {
            RailShape railShape = switch ((RailShape)state.getValue((Property)BlockStateProperties.RAIL_SHAPE)) {
                case RailShape.NORTH_SOUTH -> RailShape.EAST_WEST;
                case RailShape.EAST_WEST -> RailShape.NORTH_EAST;
                case RailShape.NORTH_EAST -> RailShape.SOUTH_EAST;
                case RailShape.SOUTH_EAST -> RailShape.SOUTH_WEST;
                case RailShape.SOUTH_WEST -> RailShape.NORTH_WEST;
                case RailShape.NORTH_WEST -> RailShape.NORTH_SOUTH;
                default -> (RailShape)state.getValue((Property)BlockStateProperties.RAIL_SHAPE);
            };
            newState = (BlockState)state.setValue((Property)BlockStateProperties.RAIL_SHAPE, (Comparable)railShape);
        } else if (state.hasProperty((Property)BlockStateProperties.HANGING)) {
            newState = (BlockState)state.setValue((Property)BlockStateProperties.HANGING, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)BlockStateProperties.HANGING) == false));
        }
        return newState;
    }
}

