/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.tileentity;

import com.github.alexthe666.alexsmobs.block.BlockSculkBoomer;
import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.tileentity.AMTileEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TileEntitySculkBoomer
extends BlockEntity
implements GameEventListener {
    private final BlockPositionSource blockPosSource;
    private boolean prevOpen;
    private int screamTime;

    public TileEntitySculkBoomer(BlockPos pos, BlockState state) {
        super((BlockEntityType)AMTileEntityRegistry.SCULK_BOOMER.get(), pos, state);
        this.blockPosSource = new BlockPositionSource(this.worldPosition);
        this.prevOpen = false;
        this.screamTime = 0;
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, TileEntitySculkBoomer tileEntity) {
        boolean hasPower = false;
        if (state.getBlock() instanceof BlockSculkBoomer && !tileEntity.isRemoved()) {
            if (tileEntity.screamTime < 0 && !((Boolean)state.getValue((Property)BlockSculkBoomer.POWERED)).booleanValue()) {
                AABB screamBox = new AABB((double)(pos.getX() - 4), (double)((float)pos.getY() - 0.25f), (double)(pos.getZ() - 4), (double)(pos.getX() + 4), (double)((float)pos.getY() + 0.25f), (double)((float)pos.getZ() + 4.0f));
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockSculkBoomer.OPEN, (Comparable)Boolean.valueOf(true)));
                ++tileEntity.screamTime;
                if (tileEntity.screamTime >= 0) {
                    tileEntity.screamTime = 100;
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockSculkBoomer.OPEN, (Comparable)Boolean.valueOf(false)));
                }
                float screamProgress = 1.0f - (float)tileEntity.screamTime / -20.0f;
                Vec3 center = screamBox.getCenter();
                for (LivingEntity entity : level.getEntitiesOfClass(LivingEntity.class, screamBox)) {
                    double distance = 0.5 + entity.position().subtract(center).horizontalDistance();
                    if (!(distance < (double)(4.0f * screamProgress)) || !(distance > (double)(3.5f * screamProgress)) || TileEntitySculkBoomer.isOccluded(level, Vec3.atCenterOf((Vec3i)pos), entity.position())) continue;
                    entity.hurt(entity.damageSources().magic(), (float)(6 + entity.getRandom().nextInt(3)));
                    entity.knockback((double)0.4f, center.x - entity.getX(), center.z - entity.getZ());
                }
            }
            if (tileEntity.screamTime > 0) {
                --tileEntity.screamTime;
            }
            boolean openNow = (Boolean)state.getValue((Property)BlockSculkBoomer.OPEN);
            if (!tileEntity.prevOpen && openNow) {
                SoundEvent sound = (SoundEvent)AMSoundRegistry.SCULK_BOOMER.get();
                if (level.getRandom().nextInt(100) == 0) {
                    sound = (SoundEvent)AMSoundRegistry.SCULK_BOOMER_FART.get();
                }
                level.playSound((Player)null, pos, sound, SoundSource.BLOCKS, 4.0f, level.random.nextFloat() * 0.2f + 0.9f);
                level.addParticle((ParticleOptions)AMParticleRegistry.SKULK_BOOM.get(), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
            }
            tileEntity.prevOpen = openNow;
        }
    }

    public void tick() {
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("ScreamCooldown", 99)) {
            this.screamTime = tag.getInt("ScreamCooldown");
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("ScreamCooldown", this.screamTime);
    }

    public PositionSource getListenerSource() {
        return this.blockPosSource;
    }

    public int getListenerRadius() {
        return 8;
    }

    public boolean handleGameEvent(ServerLevel serverLevel, Holder<GameEvent> event, GameEvent.Context message, Vec3 from) {
        if (!TileEntitySculkBoomer.isOccluded((Level)serverLevel, Vec3.atCenterOf((Vec3i)this.getBlockPos()), from)) {
            double distance = from.distanceTo(Vec3.atCenterOf((Vec3i)this.getBlockPos()));
            serverLevel.sendParticles((ParticleOptions)new VibrationParticleOption((PositionSource)new BlockPositionSource(this.getBlockPos()), Mth.floor((double)distance)), from.x, from.y, from.z, 1, 0.0, 0.0, 0.0, 0.0);
            if (this.screamTime == 0) {
                this.screamTime = -20;
            }
            return true;
        }
        return false;
    }

    private static boolean isOccluded(Level level, Vec3 vec1, Vec3 vec2) {
        Vec3 vec3 = new Vec3((double)Mth.floor((double)vec1.x) + 0.5, (double)Mth.floor((double)vec1.y) + 0.5, (double)Mth.floor((double)vec1.z) + 0.5);
        Vec3 vec31 = new Vec3((double)Mth.floor((double)vec2.x) + 0.5, (double)Mth.floor((double)vec2.y) + 0.5, (double)Mth.floor((double)vec2.z) + 0.5);
        for (Direction direction : Direction.values()) {
            Vec3 vec32 = vec3.relative(direction, (double)1.0E-5f);
            if (level.isBlockInLine(new ClipBlockStateContext(vec32, vec31, p_223780_ -> p_223780_.is(BlockTags.OCCLUDES_VIBRATION_SIGNALS))).getType() == HitResult.Type.BLOCK) continue;
            return false;
        }
        return true;
    }
}

