/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.tileentity;

import com.github.alexthe666.alexsmobs.block.BlockEndPirateAnchor;
import com.github.alexthe666.alexsmobs.block.BlockEndPirateAnchorWinch;
import com.github.alexthe666.alexsmobs.tileentity.AMTileEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileEntityEndPirateAnchorWinch
extends BlockEntity {
    public float clientRoll;
    public int windCounter = 0;
    private int prevTargetChainLength = this.targetChainLength;
    private int targetChainLength = 0;
    private float prevMaximumChainLength;
    private float chainLength;
    private float prevChainLength;
    private int windTime = 0;
    private int ticksExisted = 0;
    private float windProgress;
    private float prevWindProgress;
    private boolean draggingAnchor;
    private boolean anchorEW;
    private boolean pullingUp;
    private boolean hasPower;
    private int anchorPlaceCooldown = 0;

    public TileEntityEndPirateAnchorWinch(BlockPos pos, BlockState state) {
        super((BlockEntityType)AMTileEntityRegistry.END_PIRATE_ANCHOR_WINCH.get(), pos, state);
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, TileEntityEndPirateAnchorWinch entity) {
        entity.tick();
    }

    private int calcChainLength(boolean goBelowAnchor) {
        BlockPos down = this.getBlockPos().below();
        while (this.level != null && down.getY() > this.level.getMinBuildHeight() && !this.isAnchorTop(this.level, down) && (this.isEmptyBlock(down) || this.isAnchorChain(this.level, down))) {
            down = down.below();
        }
        int i = 0;
        if (this.isAnchorTop(this.level, down) || goBelowAnchor) {
            i = goBelowAnchor ? this.getBlockPos().getY() - 1 - this.keepMovingBelowAnchor(down.below(2)) : this.getBlockPos().getY() - 1 - down.getY();
        }
        if (this.draggingAnchor) {
            return i - 3;
        }
        return i;
    }

    private int keepMovingBelowAnchor(BlockPos below) {
        while (below.getY() > this.level.getMinBuildHeight() && this.isEmptyBlock(below)) {
            below = below.below();
        }
        return below.getY();
    }

    private boolean isEmptyBlock(BlockPos pos) {
        return this.level.isEmptyBlock(pos) || this.isAnchorChain(this.level, pos) || this.level.getBlockState(pos).canBeReplaced();
    }

    private boolean isAnchorChain(Level level, BlockPos pos) {
        return level.getBlockState(pos).getBlock() instanceof BlockEndPirateAnchor && level.getBlockState(pos).getValue(BlockEndPirateAnchor.PIECE) == BlockEndPirateAnchor.PieceType.CHAIN;
    }

    private boolean isAnchorTop(Level level, BlockPos pos) {
        return level.getBlockState(pos).getBlock() instanceof BlockEndPirateAnchor && level.getBlockState(pos.below(2)).getBlock() instanceof BlockEndPirateAnchor && level.getBlockState(pos.below(2)).getValue(BlockEndPirateAnchor.PIECE) == BlockEndPirateAnchor.PieceType.ANCHOR;
    }

    private void tick() {
        this.prevChainLength = this.chainLength;
        this.prevWindProgress = this.windProgress;
        this.prevTargetChainLength = this.targetChainLength;
        ++this.ticksExisted;
        boolean powered = false;
        if (this.getBlockState().getBlock() instanceof BlockEndPirateAnchorWinch) {
            powered = (Boolean)this.getBlockState().getValue((Property)BlockEndPirateAnchorWinch.POWERED);
        }
        if (powered && this.pullingUp) {
            this.sendDownChains();
        }
        if (!powered && !this.pullingUp) {
            this.pullUpChains();
        }
        if (this.chainLength < (float)this.targetChainLength) {
            this.chainLength = Math.min(this.chainLength + 0.1f, (float)this.targetChainLength);
        }
        if (this.chainLength > (float)this.targetChainLength) {
            this.chainLength = Math.max(this.chainLength - 0.1f, (float)this.targetChainLength);
        }
        if (Math.abs((float)this.targetChainLength - this.chainLength) > 0.2f) {
            this.windTime = 5;
        }
        if (this.windTime > 0) {
            ++this.windCounter;
            --this.windTime;
            if (this.windProgress < 1.0f) {
                this.windProgress += 0.25f;
            }
        } else {
            this.windCounter = 0;
            if (this.windProgress > 0.0f) {
                this.windProgress -= 0.25f;
            }
        }
        if (this.anchorPlaceCooldown > 0) {
            --this.anchorPlaceCooldown;
        }
        if (this.chainLength != (float)this.targetChainLength && this.isWindingUp() && !this.draggingAnchor) {
            BlockPos down = this.getBlockPos();
            if (this.anchorPlaceCooldown == 0 && (this.checkAndBreakAnchor(down.below()) || this.checkAndBreakAnchor(down.below(1 + (int)Math.ceil(this.chainLength))))) {
                this.draggingAnchor = true;
            }
        }
        if (this.chainLength == (float)this.targetChainLength && this.draggingAnchor) {
            int offset;
            int n = offset = this.isWindingUp() ? 0 : this.targetChainLength;
            if (this.anchorPlaceCooldown == 0 && this.tryPlaceAnchor(offset)) {
                this.draggingAnchor = false;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public boolean checkAndBreakAnchor(BlockPos down) {
        if (this.level.getBlockState(down).getBlock() instanceof BlockEndPirateAnchor) {
            this.anchorEW = (Boolean)this.level.getBlockState(down).getValue((Property)BlockEndPirateAnchor.EASTORWEST);
            BlockPos actualAnchorPos = down.below(2);
            if (this.level.getBlockState(actualAnchorPos).getBlock() instanceof BlockEndPirateAnchor) {
                BlockEndPirateAnchor.removeAnchor(this.level, actualAnchorPos, this.level.getBlockState(actualAnchorPos));
                this.removeChainBlocks();
                return true;
            }
        }
        return false;
    }

    public boolean tryPlaceAnchor(int offset) {
        BlockPos at = this.getBlockPos().below(3 + offset);
        if (BlockEndPirateAnchor.isClearForPlacement((LevelReader)this.level, at, this.anchorEW)) {
            BlockState anchorState = null;
            this.level.setBlock(at, anchorState, 2);
            BlockEndPirateAnchor.placeAnchor(this.level, at, anchorState);
            this.placeChainBlocks(offset);
            return true;
        }
        return false;
    }

    private void placeChainBlocks(int offset) {
        BlockPos at = this.getBlockPos().below(3 + offset);
        BlockPos chainPos = at.above(3);
        while (chainPos.getY() < this.getBlockPos().getY() - 1 && this.isEmptyBlock(chainPos)) {
            chainPos = chainPos.above();
        }
    }

    private void removeChainBlocks() {
        BlockPos chainPos = this.getBlockPos().below(1 + (int)Math.ceil(this.chainLength));
        while (chainPos.getY() < this.getBlockPos().getY()) {
            if (this.isAnchorChain(this.level, chainPos)) {
                this.level.setBlock(chainPos, Blocks.AIR.defaultBlockState(), 3);
            }
            chainPos = chainPos.above();
        }
    }

    public void recalculateChains() {
        BlockPos at;
        if (this.targetChainLength != 0) {
            this.prevMaximumChainLength = this.targetChainLength;
        }
        if (this.isAnchorTop(this.level, at = this.getBlockPos().below(1)) && this.anchorPlaceCooldown == 0 && this.checkAndBreakAnchor(at)) {
            this.draggingAnchor = true;
        }
        this.targetChainLength = this.calcChainLength(this.draggingAnchor);
    }

    public void sendDownChains() {
        this.recalculateChains();
        this.pullingUp = false;
    }

    public void pullUpChains() {
        if (this.targetChainLength != 0) {
            this.prevMaximumChainLength = this.targetChainLength;
        }
        this.targetChainLength = 0;
        this.pullingUp = true;
    }

    public void onInteract() {
    }

    public float getChainLengthForRender() {
        return Math.max((float)this.targetChainLength, this.prevMaximumChainLength);
    }

    public float getChainLength(float partialTick) {
        return this.prevChainLength + (this.chainLength - this.prevChainLength) * partialTick;
    }

    public float getWindProgress(float partialTick) {
        return this.prevWindProgress + (this.windProgress - this.prevWindProgress) * partialTick;
    }

    public boolean isAnchorEW() {
        return this.anchorEW;
    }

    public boolean isWinching() {
        return this.windTime > 0;
    }

    public boolean isWindingUp() {
        return this.pullingUp;
    }

    public boolean hasAnchor() {
        return this.draggingAnchor;
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.pullingUp = compound.getBoolean("PullingUp");
        this.draggingAnchor = compound.getBoolean("DraggingAnchor");
        this.anchorEW = compound.getBoolean("EWAnchor");
        this.prevChainLength = this.chainLength = compound.getFloat("ChainLength");
        this.targetChainLength = compound.getInt("TargetChainLength");
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putBoolean("PullingUp", this.pullingUp);
        compound.putBoolean("DraggingAnchor", this.draggingAnchor);
        compound.putBoolean("EWAnchor", this.anchorEW);
        compound.putFloat("ChainLength", this.chainLength);
        compound.putInt("TargetChainLength", this.targetChainLength);
    }
}

