/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.tileentity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.block.BlockCapsid;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityEnderiophage;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.CapsidRecipe;
import com.github.alexthe666.alexsmobs.network.MessageUpdateCapsid;
import com.github.alexthe666.alexsmobs.tileentity.AMTileEntityRegistry;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileEntityCapsid
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] slotsTop = new int[]{0};
    public int ticksExisted;
    public float prevFloatUpProgress;
    public float floatUpProgress;
    public float prevYawSwitchProgress;
    public float yawSwitchProgress;
    public boolean vibratingThisTick = false;
    private float yawTarget = 0.0f;
    private int transformTime = 0;
    private boolean fnaf = false;
    private CapsidRecipe lastRecipe = null;
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);

    public TileEntityCapsid(BlockPos pos, BlockState state) {
        super((BlockEntityType)AMTileEntityRegistry.CAPSID.get(), pos, state);
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, TileEntityCapsid entity) {
        entity.tick();
    }

    public void tick() {
        this.prevFloatUpProgress = this.floatUpProgress;
        this.prevYawSwitchProgress = this.yawSwitchProgress;
        ++this.ticksExisted;
        this.vibratingThisTick = false;
        if (!this.getItem(0).isEmpty()) {
            BlockEntity up = this.level.getBlockEntity(this.worldPosition.above());
            if (up instanceof Container) {
                if (this.floatUpProgress >= 1.0f) {
                    Container containerAbove = (Container)up;
                    ItemStack toInsert = this.getItem(0).copy();
                    boolean inserted = false;
                    for (int i = 0; i < containerAbove.getContainerSize() && !toInsert.isEmpty(); ++i) {
                        ItemStack slotStack = containerAbove.getItem(i);
                        if (slotStack.isEmpty()) {
                            containerAbove.setItem(i, toInsert.copy());
                            toInsert = ItemStack.EMPTY;
                            inserted = true;
                            continue;
                        }
                        if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)toInsert) || slotStack.getCount() >= slotStack.getMaxStackSize()) continue;
                        int canAdd = Math.min(toInsert.getCount(), slotStack.getMaxStackSize() - slotStack.getCount());
                        slotStack.grow(canAdd);
                        toInsert.shrink(canAdd);
                        inserted = true;
                    }
                    if (inserted && toInsert.isEmpty()) {
                        this.setItem(0, ItemStack.EMPTY);
                    }
                    this.yawTarget = 0.0f;
                    this.floatUpProgress = 0.0f;
                    this.yawSwitchProgress = 0.0f;
                } else {
                    this.yawTarget = up instanceof TileEntityCapsid ? Mth.wrapDegrees((float)(((TileEntityCapsid)up).getBlockAngle() - this.getBlockAngle())) : 0.0f;
                    if (this.yawTarget < this.yawSwitchProgress) {
                        this.yawSwitchProgress += this.yawTarget * 0.1f;
                    } else if (this.yawTarget > this.yawSwitchProgress) {
                        this.yawSwitchProgress += this.yawTarget * 0.1f;
                    }
                    this.floatUpProgress += 0.05f;
                }
            } else {
                this.floatUpProgress = 0.0f;
            }
            if (this.getItem(0).getItem() == Items.ENDER_EYE && this.level.getBlockState(this.getBlockPos().below()).getBlock() == Blocks.END_ROD && ((Direction)this.level.getBlockState(this.getBlockPos().below()).getValue((Property)EndRodBlock.FACING)).getAxis() == Direction.Axis.Y) {
                this.vibratingThisTick = true;
                if (this.transformTime > 20) {
                    this.setItem(0, ItemStack.EMPTY);
                    this.level.destroyBlock(this.getBlockPos(), false);
                    this.level.destroyBlock(this.getBlockPos().below(), false);
                    EntityEnderiophage phage = (EntityEnderiophage)((EntityType)AMEntityRegistry.ENDERIOPHAGE.get()).create(this.level);
                    phage.setPos((float)this.getBlockPos().getX() + 0.5f, (float)this.getBlockPos().getY() - 1.0f, (float)this.getBlockPos().getZ() + 0.5f);
                    phage.setVariant(0);
                    if (!this.level.isClientSide) {
                        this.level.addFreshEntity((Entity)phage);
                    }
                }
            } else if (!this.getItem(0).isEmpty() && this.level.getBlockState(this.getBlockPos().above()).getBlock() != this.getBlockState().getBlock() && this.lastRecipe != null && this.lastRecipe.matches(this.getItem(0))) {
                this.floatUpProgress = 0.0f;
                this.vibratingThisTick = true;
                if (this.transformTime == 1 && (AlexsMobs.isAprilFools() || new Random().nextInt(100) == 0)) {
                    this.fnaf = true;
                    this.level.playSound(null, this.getBlockPos(), (SoundEvent)AMSoundRegistry.MOSQUITO_CAPSID_CONVERT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (this.transformTime > (this.fnaf ? Math.max(160, this.lastRecipe.getTime()) : this.lastRecipe.getTime())) {
                    ItemStack current = this.getItem(0).copy();
                    current.shrink(1);
                    this.fnaf = false;
                    if (!current.isEmpty()) {
                        ItemEntity itemEntity = new ItemEntity(this.level, (double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() + 0.5f), (double)((float)this.getBlockPos().getZ() + 0.5f), current);
                        if (!this.level.isClientSide) {
                            this.level.addFreshEntity((Entity)itemEntity);
                        }
                    }
                    this.setItem(0, this.lastRecipe.getResult().copy());
                }
            }
        }
        this.transformTime = !this.vibratingThisTick ? 0 : ++this.transformTime;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return new AABB((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (double)(this.worldPosition.getX() + 1), 2.0, 1.0);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.stacks = items;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.stacks.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        if (!((ItemStack)this.stacks.get(index)).isEmpty()) {
            if (((ItemStack)this.stacks.get(index)).getCount() <= count) {
                ItemStack itemstack = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, (Object)ItemStack.EMPTY);
                return itemstack;
            }
            ItemStack itemstack = ((ItemStack)this.stacks.get(index)).split(count);
            if (((ItemStack)this.stacks.get(index)).isEmpty()) {
                this.stacks.set(index, (Object)ItemStack.EMPTY);
            }
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getStackInSlotOnClosing(int index) {
        if (!((ItemStack)this.stacks.get(index)).isEmpty()) {
            ItemStack itemstack = (ItemStack)this.stacks.get(index);
            this.stacks.set(index, (Object)itemstack);
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int index, ItemStack stack) {
        boolean flag = !stack.isEmpty() && ItemStack.matches((ItemStack)stack, (ItemStack)((ItemStack)this.stacks.get(index)));
        this.stacks.set(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.lastRecipe = AlexsMobs.PROXY.getCapsidRecipeManager().getRecipeFor(stack);
        if (!this.level.isClientSide) {
            AlexsMobs.sendMSGToAll(new MessageUpdateCapsid(this.getBlockPos().asLong(), (ItemStack)this.stacks.get(0)));
        }
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)registries);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        ContainerHelper.saveAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)registries);
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.stacks.clear();
    }

    public int[] getSlotsForFace(Direction side) {
        return slotsTop;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean hasCustomName() {
        return false;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        if (packet != null && packet.getTag() != null) {
            this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)packet.getTag(), this.stacks, (HolderLookup.Provider)registries);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack lvt_2_1_ = (ItemStack)this.stacks.get(index);
        if (lvt_2_1_.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.stacks.set(index, (Object)ItemStack.EMPTY);
        return lvt_2_1_;
    }

    public Component getDisplayName() {
        return this.getDefaultName();
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.alexsmobs.capsid");
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return null;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public float getBlockAngle() {
        if (this.getBlockState().getBlock() instanceof BlockCapsid) {
            Direction dir = (Direction)this.getBlockState().getValue((Property)BlockCapsid.HORIZONTAL_FACING);
            return dir.toYRot();
        }
        return 0.0f;
    }
}

