/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.network;

import com.github.alexthe666.alexsmobs.tileentity.TileEntityCapsid;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageUpdateCapsid(long blockPos, ItemStack heldStack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageUpdateCapsid> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"update_capsid"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageUpdateCapsid> CODEC = new StreamCodec<RegistryFriendlyByteBuf, MessageUpdateCapsid>(){

        public MessageUpdateCapsid decode(RegistryFriendlyByteBuf buf) {
            long blockPos = buf.readLong();
            ItemStack heldStack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            return new MessageUpdateCapsid(blockPos, heldStack);
        }

        public void encode(RegistryFriendlyByteBuf buf, MessageUpdateCapsid packet) {
            buf.writeLong(packet.blockPos);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)packet.heldStack);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handleClient(MessageUpdateCapsid payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player != null && player.level() != null) {
                BlockPos pos = BlockPos.of((long)payload.blockPos);
                BlockEntity patt0$temp = player.level().getBlockEntity(pos);
                if (patt0$temp instanceof TileEntityCapsid) {
                    TileEntityCapsid podium = (TileEntityCapsid)patt0$temp;
                    podium.setItem(0, payload.heldStack);
                }
            }
        });
    }
}

