/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.network;

import com.github.alexthe666.alexsmobs.inventory.MenuTransmutationTable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageTransmuteFromMenu(int playerId, int choice) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageTransmuteFromMenu> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"transmute_from_menu"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageTransmuteFromMenu> CODEC = new StreamCodec<RegistryFriendlyByteBuf, MessageTransmuteFromMenu>(){

        public MessageTransmuteFromMenu decode(RegistryFriendlyByteBuf buf) {
            int playerId = buf.readInt();
            int choice = buf.readInt();
            return new MessageTransmuteFromMenu(playerId, choice);
        }

        public void encode(RegistryFriendlyByteBuf buf, MessageTransmuteFromMenu packet) {
            buf.writeInt(packet.playerId);
            buf.writeInt(packet.choice);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handleServer(MessageTransmuteFromMenu payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            AbstractContainerMenu patt0$temp;
            Player player = context.player();
            if (player.getId() == payload.playerId && (patt0$temp = player.containerMenu) instanceof MenuTransmutationTable) {
                MenuTransmutationTable table = (MenuTransmutationTable)patt0$temp;
                table.transmute(player, payload.choice);
            }
        });
    }
}

