/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.network;

import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityTarantulaHawk;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageTarantulaHawkSting(int hawk, int spider) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageTarantulaHawkSting> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"tarantula_hawk_sting"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageTarantulaHawkSting> CODEC = new StreamCodec<RegistryFriendlyByteBuf, MessageTarantulaHawkSting>(){

        public MessageTarantulaHawkSting decode(RegistryFriendlyByteBuf buf) {
            int hawk = buf.readInt();
            int spider = buf.readInt();
            return new MessageTarantulaHawkSting(hawk, spider);
        }

        public void encode(RegistryFriendlyByteBuf buf, MessageTarantulaHawkSting packet) {
            buf.writeInt(packet.hawk);
            buf.writeInt(packet.spider);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handleClient(MessageTarantulaHawkSting payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player != null && player.level() != null) {
                LivingEntity livingSpider;
                Entity entity = player.level().getEntity(payload.hawk);
                Entity spider = player.level().getEntity(payload.spider);
                if (entity instanceof EntityTarantulaHawk && spider instanceof LivingEntity && (livingSpider = (LivingEntity)spider).getType().is(EntityTypeTags.ARTHROPOD)) {
                    livingSpider.addEffect(new MobEffectInstance(AMEffectRegistry.DEBILITATING_STING, 2400));
                }
            }
        });
    }
}

