/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.network;

import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageSyncEntityData(int entityId, CompoundTag data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageSyncEntityData> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"sync_entity_data"));
    public static final StreamCodec<FriendlyByteBuf, MessageSyncEntityData> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, MessageSyncEntityData::entityId, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, MessageSyncEntityData::data, MessageSyncEntityData::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handleClient(MessageSyncEntityData message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity;
            if (Minecraft.getInstance().level != null && (entity = Minecraft.getInstance().level.getEntity(message.entityId)) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                CitadelEntityData.setCitadelTag((LivingEntity)living, (CompoundTag)message.data);
            }
        });
    }
}

