/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.network;

import com.github.alexthe666.alexsmobs.entity.EntityKangaroo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageKangarooInventorySync(int kangaroo, int slotId, ItemStack stack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageKangarooInventorySync> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"kangaroo_inventory_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageKangarooInventorySync> CODEC = new StreamCodec<RegistryFriendlyByteBuf, MessageKangarooInventorySync>(){

        public MessageKangarooInventorySync decode(RegistryFriendlyByteBuf buf) {
            int kangaroo = buf.readInt();
            int slotId = buf.readInt();
            ItemStack stack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            return new MessageKangarooInventorySync(kangaroo, slotId, stack);
        }

        public void encode(RegistryFriendlyByteBuf buf, MessageKangarooInventorySync packet) {
            buf.writeInt(packet.kangaroo);
            buf.writeInt(packet.slotId);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)packet.stack);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handleClient(MessageKangarooInventorySync payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity;
            Player player = context.player();
            if (player != null && player.level() != null && (entity = player.level().getEntity(payload.kangaroo)) instanceof EntityKangaroo) {
                EntityKangaroo kangaroo = (EntityKangaroo)entity;
                if (kangaroo.kangarooInventory != null && payload.slotId >= 0) {
                    kangaroo.kangarooInventory.setItem(payload.slotId, payload.stack);
                }
            }
        });
    }
}

