/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.network;

import com.github.alexthe666.alexsmobs.entity.EntityKangaroo;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageKangarooEat(int kangaroo, ItemStack stack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageKangarooEat> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"kangaroo_eat"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageKangarooEat> CODEC = new StreamCodec<RegistryFriendlyByteBuf, MessageKangarooEat>(){

        public MessageKangarooEat decode(RegistryFriendlyByteBuf buf) {
            int kangaroo = buf.readInt();
            ItemStack stack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            return new MessageKangarooEat(kangaroo, stack);
        }

        public void encode(RegistryFriendlyByteBuf buf, MessageKangarooEat packet) {
            buf.writeInt(packet.kangaroo);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)packet.stack);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handleClient(MessageKangarooEat payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity;
            Player player = context.player();
            if (player != null && player.level() != null && (entity = player.level().getEntity(payload.kangaroo)) instanceof EntityKangaroo) {
                EntityKangaroo kangaroo = (EntityKangaroo)entity;
                if (kangaroo.kangarooInventory != null) {
                    for (int i = 0; i < 7; ++i) {
                        double d2 = kangaroo.getRandom().nextGaussian() * 0.02;
                        double d0 = kangaroo.getRandom().nextGaussian() * 0.02;
                        double d1 = kangaroo.getRandom().nextGaussian() * 0.02;
                        entity.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, payload.stack), entity.getX() + (double)(kangaroo.getRandom().nextFloat() * entity.getBbWidth()) - (double)entity.getBbWidth() * 0.5, entity.getY() + (double)(entity.getBbHeight() * 0.5f) + (double)(kangaroo.getRandom().nextFloat() * entity.getBbHeight() * 0.5f), entity.getZ() + (double)(kangaroo.getRandom().nextFloat() * entity.getBbWidth()) - (double)entity.getBbWidth() * 0.5, d0, d1, d2);
                    }
                }
            }
        });
    }
}

