/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageInteractMultipart(int parent, boolean offhand) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageInteractMultipart> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"interact_multipart"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageInteractMultipart> CODEC = new StreamCodec<RegistryFriendlyByteBuf, MessageInteractMultipart>(){

        public MessageInteractMultipart decode(RegistryFriendlyByteBuf buf) {
            int parent = buf.readInt();
            boolean offhand = buf.readBoolean();
            return new MessageInteractMultipart(parent, offhand);
        }

        public void encode(RegistryFriendlyByteBuf buf, MessageInteractMultipart packet) {
            buf.writeInt(packet.parent);
            buf.writeBoolean(packet.offhand);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handle(MessageInteractMultipart payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity parent;
            Player player = context.player();
            if (player != null && player.level() != null && (parent = player.level().getEntity(payload.parent)) != null && player.distanceTo(parent) < 20.0f && parent instanceof Mob) {
                player.interactOn(parent, payload.offhand ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
            }
        });
    }

    public static void handleServer(MessageInteractMultipart payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity parent;
            Player player = context.player();
            if (player != null && player.level() != null && player.distanceTo(parent = player.level().getEntity(payload.parent)) < 20.0f && parent instanceof Mob) {
                player.interactOn(parent, payload.offhand ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
            }
        });
    }
}

