/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.misc;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class TransmutationData {
    private final Object2DoubleMap<ItemStack> itemstackData = new Object2DoubleOpenHashMap();

    public void onTransmuteItem(ItemStack beingTransmuted, ItemStack turnedInto) {
        double fromWeight = this.getWeight(beingTransmuted);
        double toWeight = this.getWeight(turnedInto);
        this.putWeight(beingTransmuted, fromWeight + TransmutationData.calculateAddWeight(beingTransmuted.getCount()));
        this.putWeight(turnedInto, toWeight + TransmutationData.calculateRemoveWeight(turnedInto.getCount()));
    }

    public double getWeight(ItemStack stack) {
        for (Object2DoubleMap.Entry entry : this.itemstackData.object2DoubleEntrySet()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)((ItemStack)entry.getKey()))) continue;
            return entry.getDoubleValue();
        }
        return 0.0;
    }

    private static double calculateAddWeight(int count) {
        return Math.log(Math.pow(count, AMConfig.transmutingWeightAddStep));
    }

    private static double calculateRemoveWeight(int count) {
        return -Math.log(Math.pow(count, AMConfig.transmutingWeightRemoveStep));
    }

    public void putWeight(ItemStack stack, double newWeight) {
        ItemStack replace = stack;
        for (ItemStack entry : this.itemstackData.keySet()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)entry)) continue;
            replace = entry;
            break;
        }
        this.itemstackData.put((Object)replace, Math.max(newWeight, 0.0));
    }

    @Nullable
    public ItemStack getRandomItem(Random random) {
        ItemStack result = null;
        double bestValue = Double.MAX_VALUE;
        for (Object2DoubleMap.Entry entry : this.itemstackData.object2DoubleEntrySet()) {
            double value;
            if (entry.getDoubleValue() <= 0.0 || !((value = -Math.log(random.nextDouble()) / entry.getDoubleValue()) < bestValue)) continue;
            bestValue = value;
            result = ((ItemStack)entry.getKey()).copy();
        }
        return result;
    }

    public CompoundTag saveAsNBT(HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        ListTag listTag = new ListTag();
        for (Object2DoubleMap.Entry entry : this.itemstackData.object2DoubleEntrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.put("Item", ((ItemStack)entry.getKey()).save(provider, (Tag)new CompoundTag()));
            tag.putDouble("Weight", entry.getDoubleValue());
            listTag.add((Object)tag);
        }
        compound.put("TransmutationData", (Tag)listTag);
        return compound;
    }

    public static TransmutationData fromNBT(CompoundTag compound) {
        TransmutationData data = new TransmutationData();
        if (compound.contains("TransmutationData")) {
            ListTag listtag = compound.getList("TransmutationData", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag innerTag = listtag.getCompound(i);
                try {
                    ItemStack from = ItemStack.parseOptional((HolderLookup.Provider)HolderLookup.Provider.create(Stream.empty()), (CompoundTag)innerTag.getCompound("Item"));
                    if (from.isEmpty()) continue;
                    data.putWeight(from, innerTag.getDouble("Weight"));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return data;
    }

    public double getTotalWeight() {
        return this.itemstackData.values().doubleStream().sum();
    }
}

