/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.misc;

import com.github.alexthe666.citadel.client.model.container.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.reflect.Type;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class CapsidRecipe {
    private final NonNullList<Ingredient> ingredients;
    private ItemStack result = ItemStack.EMPTY;
    private int time = 0;

    public CapsidRecipe(NonNullList<Ingredient> ingredients, ItemStack result, int time) {
        this.result = result;
        this.ingredients = ingredients;
        this.time = time;
    }

    private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
        NonNullList nonnulllist = NonNullList.create();
        for (int i = 0; i < ingredientArray.size(); ++i) {
            Ingredient ingredient = Ingredient.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)ingredientArray.get(i)).result().orElse(Ingredient.EMPTY);
            if (ingredient.isEmpty()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public int getTime() {
        return this.time;
    }

    public boolean matches(ItemStack ... stacks) {
        IntArrayList taken = new IntArrayList();
        ItemStack[] copy = new ItemStack[stacks.length];
        for (int j = 0; j < copy.length; ++j) {
            copy[j] = stacks[j].copy();
            for (int i = 0; i < this.ingredients.size(); ++i) {
                if (!((Ingredient)this.ingredients.get(i)).test(copy[j])) continue;
                taken.add(j);
                copy[j].shrink(1);
            }
        }
        return taken.size() >= this.ingredients.size();
    }

    public static class Deserializer
    implements JsonDeserializer<CapsidRecipe> {
        public CapsidRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = json.getAsJsonObject();
            int time = JsonUtils.getInt((JsonObject)jsonobject, (String)"time");
            ItemStack result = ItemStack.EMPTY;
            if (jsonobject.has("result")) {
                JsonObject resultObj = JsonUtils.getJsonObject((JsonObject)jsonobject, (String)"result");
                ResourceLocation itemId = ResourceLocation.parse((String)resultObj.get("item").getAsString());
                Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
                int count = resultObj.has("count") ? resultObj.get("count").getAsInt() : 1;
                result = new ItemStack((ItemLike)item, count);
            }
            NonNullList<Ingredient> nonnulllist = CapsidRecipe.readIngredients(JsonUtils.getJsonArray((JsonObject)jsonobject, (String)"ingredients"));
            return new CapsidRecipe(nonnulllist, result, time);
        }
    }
}

