/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.misc;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.NotNull;

public class BananaLootModifier
implements IGlobalLootModifier {
    public static final Supplier<MapCodec<BananaLootModifier>> CODEC = () -> MapCodec.unit(() -> new BananaLootModifier(new LootItemCondition[0]));
    private static final ResourceLocation JUNGLE_LEAVES = ResourceLocation.withDefaultNamespace((String)"blocks/jungle_leaves");
    private final LootItemCondition[] conditions;

    public BananaLootModifier(LootItemCondition[] conditionsIn) {
        this.conditions = conditionsIn;
    }

    @NotNull
    public ObjectArrayList<ItemStack> apply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation lootTableId = context.getQueriedLootTableId();
        if (lootTableId.equals((Object)JUNGLE_LEAVES)) {
            return this.doApply(generatedLoot, context);
        }
        return generatedLoot;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (AMConfig.bananasDropFromLeaves) {
            int bananaStep;
            int silkTouch;
            ItemStack ctxTool = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
            RandomSource random = context.getRandom();
            if (ctxTool != null && ((silkTouch = ctxTool.getEnchantmentLevel((Holder)context.getLevel().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH))) > 0 || ctxTool.getItem() instanceof ShearsItem)) {
                return generatedLoot;
            }
            int bonusLevel = ctxTool != null ? 0 : 0;
            int bananaRarity = AMConfig.bananaChance - bonusLevel * (bananaStep = (int)Math.floor((float)AMConfig.bananaChance * 0.1f));
            if (bananaRarity < 1 || random.nextInt(bananaRarity) == 0) {
                generatedLoot.add((Object)new ItemStack((ItemLike)AMItemRegistry.BANANA.get()));
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

