/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.misc;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AMDamageTypes {
    public static final ResourceKey<DamageType> FARSEER = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"alexsmobs:farseer"));
    public static final ResourceKey<DamageType> FREDDY = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"alexsmobs:freddy"));

    public static DamageSource causeFarseerDamage(LivingEntity attacker) {
        return new DamageSourceRandomMessages((Holder<DamageType>)((Registry)attacker.level().registryAccess().registry(Registries.DAMAGE_TYPE).get()).getHolderOrThrow(FARSEER), (Entity)attacker);
    }

    public static DamageSource causeFreddyBearDamage(LivingEntity attacker) {
        return new DamageSource((Holder)((Registry)attacker.level().registryAccess().registry(Registries.DAMAGE_TYPE).get()).getHolderOrThrow(FREDDY), (Entity)attacker);
    }

    private static class DamageSourceRandomMessages
    extends DamageSource {
        public DamageSourceRandomMessages(Holder<DamageType> damageTypeHolder, @Nullable Entity entity1, @Nullable Entity entity2, @Nullable Vec3 from) {
            super(damageTypeHolder, entity1, entity2, from);
        }

        public DamageSourceRandomMessages(Holder<DamageType> damageTypeHolder, @Nullable Entity entity1, @Nullable Entity entity2) {
            super(damageTypeHolder, entity1, entity2);
        }

        public DamageSourceRandomMessages(Holder<DamageType> damageTypeHolder, Vec3 from) {
            super(damageTypeHolder, from);
        }

        public DamageSourceRandomMessages(Holder<DamageType> damageTypeHolder, @Nullable Entity entity) {
            super(damageTypeHolder, entity);
        }

        public DamageSourceRandomMessages(Holder<DamageType> p_270475_) {
            super(p_270475_);
        }

        public Component getLocalizedDeathMessage(LivingEntity attacked) {
            int type = attacked.getRandom().nextInt(3);
            LivingEntity livingentity = attacked.getKillCredit();
            String s = "death.attack." + this.getMsgId() + "_" + type;
            String s1 = s + ".player";
            return livingentity != null ? Component.translatable((String)s1, (Object[])new Object[]{attacked.getDisplayName(), livingentity.getDisplayName()}) : Component.translatable((String)s, (Object[])new Object[]{attacked.getDisplayName()});
        }
    }
}

