/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.item.AMDataComponents;
import com.github.alexthe666.alexsmobs.item.ItemInventoryOnly;
import com.github.alexthe666.alexsmobs.item.data.TabIconDisplay;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class ItemTabIcon
extends ItemInventoryOnly {
    public ItemTabIcon(Item.Properties properties) {
        super(properties);
    }

    public static boolean hasCustomEntityDisplay(ItemStack stack) {
        TabIconDisplay display = (TabIconDisplay)stack.get((DataComponentType)AMDataComponents.TAB_ICON_DISPLAY.get());
        return display != null && !display.displayEntityType().isEmpty();
    }

    public static String getCustomDisplayEntityString(ItemStack stack) {
        TabIconDisplay display = (TabIconDisplay)stack.get((DataComponentType)AMDataComponents.TAB_ICON_DISPLAY.get());
        return display != null ? display.displayEntityType() : "";
    }

    public static int getDisplayMobFlags(ItemStack stack) {
        TabIconDisplay display = (TabIconDisplay)stack.get((DataComponentType)AMDataComponents.TAB_ICON_DISPLAY.get());
        return display != null ? display.displayMobFlags() : 0;
    }

    public static float getDisplayMobScale(ItemStack stack) {
        TabIconDisplay display = (TabIconDisplay)stack.get((DataComponentType)AMDataComponents.TAB_ICON_DISPLAY.get());
        return display != null ? display.displayMobScale() : 0.0f;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)AlexsMobs.PROXY.getISTERProperties());
    }

    @Nullable
    public static EntityType getEntityType(ItemStack stack) {
        TabIconDisplay display = (TabIconDisplay)stack.get((DataComponentType)AMDataComponents.TAB_ICON_DISPLAY.get());
        if (display != null && !display.displayEntityType().isEmpty()) {
            return (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)display.displayEntityType()));
        }
        return null;
    }

    @Nullable
    public static EntityType getEntityType(@Nullable CompoundTag tag) {
        if (tag != null && tag.contains("DisplayEntityType")) {
            String entityType = tag.getString("DisplayEntityType");
            return (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)entityType));
        }
        return null;
    }
}

