/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.entity.EntityFart;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class ItemStinkRay
extends Item {
    public static final Predicate<ItemStack> IS_FART_BOTTLE = stack -> stack.getItem() == AMItemRegistry.STINK_BOTTLE.get();

    public ItemStinkRay(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return ItemStinkRay.isUsable(stack) ? 72000 : 0;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public static boolean isUsable(ItemStack stack) {
        return stack.getDamageValue() < stack.getMaxDamage() - 1;
    }

    public boolean isBarVisible(ItemStack itemStack) {
        return super.isBarVisible(itemStack) && ItemStinkRay.isUsable(itemStack);
    }

    public static float getPowerForTime(int i) {
        float f = (float)i / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void releaseUsing(ItemStack itemStack, Level level, LivingEntity entity, int time) {
        if (entity instanceof Player) {
            int i;
            Player player = (Player)entity;
            if (ItemStinkRay.isUsable(itemStack) && (i = this.getUseDuration(itemStack, entity) - time) >= 10) {
                boolean left = false;
                if (entity.getUsedItemHand() == InteractionHand.OFF_HAND && entity.getMainArm() == HumanoidArm.RIGHT || entity.getUsedItemHand() == InteractionHand.MAIN_HAND && entity.getMainArm() == HumanoidArm.LEFT) {
                    left = true;
                }
                EntityFart blood = new EntityFart(level, entity, !left);
                Vec3 vector3d = entity.getViewVector(1.0f);
                RandomSource rand = level.getRandom();
                entity.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
                entity.playSound((SoundEvent)AMSoundRegistry.STINK_RAY.get(), 1.0f, 0.9f + (rand.nextFloat() - rand.nextFloat()) * 0.2f);
                blood.shoot(vector3d.x(), vector3d.y(), vector3d.z(), 0.2f + ItemStinkRay.getPowerForTime(i) * 0.4f, 10.0f);
                if (!level.isClientSide) {
                    level.addFreshEntity((Entity)blood);
                }
                itemStack.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        playerIn.startUsingItem(handIn);
        if (!ItemStinkRay.isUsable(itemstack)) {
            ItemStack ammo = this.findAmmo(playerIn);
            boolean flag = playerIn.isCreative();
            if (!ammo.isEmpty()) {
                ammo.shrink(1);
                ItemStack bottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                if (!playerIn.addItem(bottle)) {
                    playerIn.drop(bottle, false);
                }
                flag = true;
            }
            if (flag) {
                itemstack.setDamageValue(0);
            }
        }
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public ItemStack findAmmo(Player entity) {
        if (entity.isCreative()) {
            return new ItemStack((ItemLike)AMItemRegistry.STINK_BOTTLE.get());
        }
        for (int i = 0; i < entity.getInventory().getContainerSize(); ++i) {
            ItemStack itemstack1 = entity.getInventory().getItem(i);
            if (!IS_FART_BOTTLE.test(itemstack1)) continue;
            return itemstack1;
        }
        return ItemStack.EMPTY;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)AlexsMobs.PROXY.getISTERProperties());
    }
}

