/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import com.github.alexthe666.alexsmobs.entity.EntitySandShot;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class ItemPocketSand
extends Item {
    public static final Predicate<ItemStack> IS_SAND = stack -> stack.is(ItemTags.SAND);

    public ItemPocketSand(Item.Properties properties) {
        super(properties);
    }

    public ItemStack findAmmo(Player entity) {
        if (entity.isCreative()) {
            return ItemStack.EMPTY;
        }
        for (int i = 0; i < entity.getInventory().getContainerSize(); ++i) {
            ItemStack itemstack1 = entity.getInventory().getItem(i);
            if (!IS_SAND.test(itemstack1)) continue;
            return itemstack1;
        }
        return ItemStack.EMPTY;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player livingEntityIn, InteractionHand handIn) {
        ItemStack itemstack = livingEntityIn.getItemInHand(handIn);
        ItemStack ammo = this.findAmmo(livingEntityIn);
        if (livingEntityIn.isCreative()) {
            ammo = new ItemStack((ItemLike)Items.SAND);
        }
        if (!worldIn.isClientSide && !ammo.isEmpty()) {
            livingEntityIn.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
            worldIn.playSound((Player)null, livingEntityIn.getX(), livingEntityIn.getY(), livingEntityIn.getZ(), SoundEvents.SAND_BREAK, SoundSource.PLAYERS, 0.5f, 0.4f + (livingEntityIn.getRandom().nextFloat() * 0.4f + 0.8f));
            boolean left = false;
            if (livingEntityIn.getUsedItemHand() == InteractionHand.OFF_HAND && livingEntityIn.getMainArm() == HumanoidArm.RIGHT || livingEntityIn.getUsedItemHand() == InteractionHand.MAIN_HAND && livingEntityIn.getMainArm() == HumanoidArm.LEFT) {
                left = true;
            }
            EntitySandShot blood = new EntitySandShot(worldIn, (LivingEntity)livingEntityIn, !left);
            Vec3 vector3d = livingEntityIn.getViewVector(1.0f);
            blood.shoot(vector3d.x(), vector3d.y(), vector3d.z(), 1.2f, 11.0f);
            if (!worldIn.isClientSide) {
                worldIn.addFreshEntity((Entity)blood);
            }
            livingEntityIn.getCooldowns().addCooldown((Item)this, 2);
            ammo.shrink(1);
            itemstack.hurtAndBreak(1, (LivingEntity)livingEntityIn, EquipmentSlot.MAINHAND);
        }
        livingEntityIn.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)worldIn.isClientSide());
    }
}

