/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWorm;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTrigger;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class ItemMysteriousWorm
extends Item {
    public ItemMysteriousWorm(Item.Properties props) {
        super(props);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)AlexsMobs.PROXY.getISTERProperties());
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        String dim;
        if (AMConfig.voidWormSummonable && AMConfig.voidWormSpawnDimensions.contains(dim = entity.level().dimension().location().toString()) && entity.getY() < -60.0 && !entity.isRemoved()) {
            entity.kill();
            EntityVoidWorm worm = (EntityVoidWorm)((EntityType)AMEntityRegistry.VOID_WORM.get()).create(entity.level());
            worm.setPos(entity.getX(), 0.0, entity.getZ());
            worm.setSegmentCount(25 + new Random().nextInt(15));
            worm.setXRot(-90.0f);
            worm.updatePostSummon = true;
            worm.setBaseMaxHealth(AMConfig.voidWormMaxHealth, true);
            if (!entity.level().isClientSide) {
                Entity thrower = entity.getOwner();
                if (thrower != null) {
                    UUID uuid = thrower.getUUID();
                    if (entity.level().getPlayerByUUID(uuid) instanceof ServerPlayer) {
                        ((AMAdvancementTrigger)((Object)AMAdvancementTriggerRegistry.VOID_WORM_SUMMON.get())).trigger((ServerPlayer)entity.level().getPlayerByUUID(uuid));
                    }
                }
                entity.level().addFreshEntity((Entity)worm);
            }
        }
        return false;
    }
}

