/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCatfish;
import com.github.alexthe666.alexsmobs.entity.EntityLobster;
import com.github.alexthe666.alexsmobs.entity.util.TerrapinTypes;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemModFishBucket
extends MobBucketItem {
    private final Supplier<? extends EntityType<?>> fishTypeSupplier;

    public ItemModFishBucket(Supplier<? extends EntityType<?>> fishTypeIn, Fluid fluid, Item.Properties builder) {
        super(fishTypeIn.get(), fluid, SoundEvents.BUCKET_EMPTY_FISH, builder.stacksTo(1));
        this.fishTypeSupplier = fishTypeIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        String s;
        int i;
        Object compoundnbt;
        EntityType<?> fishType = this.fishTypeSupplier.get();
        if (fishType == AMEntityRegistry.LOBSTER.get() && (compoundnbt = null) != null && compoundnbt.contains("BucketVariantTag", 3)) {
            i = compoundnbt.getInt("BucketVariantTag");
            s = "entity.alexsmobs.lobster.variant_" + EntityLobster.getVariantName(i);
            tooltip.add((Component)Component.translatable((String)s).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
        if (fishType == AMEntityRegistry.TERRAPIN.get() && (compoundnbt = null) != null && compoundnbt.contains("TerrapinData")) {
            i = compoundnbt.getCompound("TerrapinData").getInt("TurtleType");
            tooltip.add((Component)Component.translatable((String)TerrapinTypes.values()[Mth.clamp((int)i, (int)0, (int)(TerrapinTypes.values().length - 1))].getTranslationName()).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
        if (fishType == AMEntityRegistry.COMB_JELLY.get() && (compoundnbt = null) != null && compoundnbt.contains("BucketVariantTag", 3)) {
            i = compoundnbt.getInt("BucketVariantTag");
            s = "entity.alexsmobs.comb_jelly.variant_" + i;
            tooltip.add((Component)Component.translatable((String)s).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
    }

    public void checkExtraContent(@Nullable Player player, Level level, ItemStack stack, BlockPos pos) {
        if (level instanceof ServerLevel) {
            this.spawnFish((ServerLevel)level, stack, pos);
            level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, pos);
        }
    }

    private void spawnFish(ServerLevel serverLevel, ItemStack stack, BlockPos pos) {
        Entity entity = this.fishTypeSupplier.get().spawn(serverLevel, stack, (Player)null, pos, MobSpawnType.BUCKET, true, false);
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            bucketable.loadFromBucketTag(((CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag());
            bucketable.setFromBucket(true);
        }
        this.addExtraAttributes(entity, stack);
    }

    private void addExtraAttributes(Entity entity, ItemStack stack) {
        if (entity instanceof EntityCatfish) {
            EntityCatfish catfish = (EntityCatfish)entity;
            if (stack.is((Item)AMItemRegistry.SMALL_CATFISH_BUCKET.get())) {
                catfish.setCatfishSize(0);
            } else if (stack.is((Item)AMItemRegistry.MEDIUM_CATFISH_BUCKET.get())) {
                catfish.setCatfishSize(1);
            } else if (stack.is((Item)AMItemRegistry.LARGE_CATFISH_BUCKET.get())) {
                catfish.setCatfishSize(2);
            }
        }
    }
}

