/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import com.github.alexthe666.alexsmobs.entity.EntityHemolymph;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class ItemHemolymphBlaster
extends Item {
    public static final Predicate<ItemStack> HEMOLYMPH = stack -> stack.getItem() == AMItemRegistry.HEMOLYMPH_SAC.get();

    public ItemHemolymphBlaster(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return ItemHemolymphBlaster.isUsable(stack) ? Integer.MAX_VALUE : 0;
    }

    public boolean isBarVisible(ItemStack itemStack) {
        return super.isBarVisible(itemStack) && ItemHemolymphBlaster.isUsable(itemStack);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public static boolean isUsable(ItemStack stack) {
        return stack.getDamageValue() < stack.getMaxDamage() - 1;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        playerIn.startUsingItem(handIn);
        if (!ItemHemolymphBlaster.isUsable(itemstack)) {
            ItemStack ammo = this.findAmmo(playerIn);
            boolean flag = playerIn.isCreative();
            if (!ammo.isEmpty()) {
                ammo.shrink(1);
                flag = true;
            }
            if (flag) {
                itemstack.setDamageValue(0);
            }
        }
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public ItemStack findAmmo(Player entity) {
        if (entity.isCreative()) {
            return ItemStack.EMPTY;
        }
        for (int i = 0; i < entity.getInventory().getContainerSize(); ++i) {
            ItemStack itemstack1 = entity.getInventory().getItem(i);
            if (!HEMOLYMPH.test(itemstack1)) continue;
            return itemstack1;
        }
        return ItemStack.EMPTY;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    public void onUseTick(Level worldIn, LivingEntity livingEntityIn, ItemStack stack, int count) {
        if (ItemHemolymphBlaster.isUsable(stack)) {
            if (count % 2 == 0) {
                boolean left = false;
                if (livingEntityIn.getUsedItemHand() == InteractionHand.OFF_HAND && livingEntityIn.getMainArm() == HumanoidArm.RIGHT || livingEntityIn.getUsedItemHand() == InteractionHand.MAIN_HAND && livingEntityIn.getMainArm() == HumanoidArm.LEFT) {
                    left = true;
                }
                EntityHemolymph blood = new EntityHemolymph(worldIn, livingEntityIn, !left);
                Vec3 vector3d = livingEntityIn.getViewVector(1.0f);
                RandomSource rand = worldIn.getRandom();
                livingEntityIn.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
                livingEntityIn.playSound(SoundEvents.LAVA_POP, 1.0f, 0.5f + (rand.nextFloat() - rand.nextFloat()) * 0.2f);
                blood.shoot(vector3d.x(), vector3d.y(), vector3d.z(), 1.0f, 3.0f);
                if (!worldIn.isClientSide) {
                    worldIn.addFreshEntity((Entity)blood);
                }
                stack.hurtAndBreak(1, livingEntityIn, EquipmentSlot.MAINHAND);
            }
        } else if (livingEntityIn instanceof Player) {
            ItemStack ammo = this.findAmmo((Player)livingEntityIn);
            boolean flag = ((Player)livingEntityIn).isCreative();
            if (!ammo.isEmpty()) {
                ammo.shrink(1);
                flag = true;
            }
            if (flag) {
                ((Player)livingEntityIn).getCooldowns().addCooldown((Item)this, 20);
                stack.setDamageValue(0);
            }
            livingEntityIn.stopUsingItem();
        }
    }
}

