/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import com.github.alexthe666.alexsmobs.entity.EntityEnderiophageRocket;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ItemEnderiophageRocket
extends Item {
    public ItemEnderiophageRocket(Item.Properties group) {
        super(group);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (!world.isClientSide) {
            ItemStack itemstack = context.getItemInHand();
            Vec3 vector3d = context.getClickLocation();
            Direction direction = context.getClickedFace();
            EntityEnderiophageRocket rocket = new EntityEnderiophageRocket(world, vector3d.x + (double)direction.getStepX() * 0.15, vector3d.y + (double)direction.getStepY() * 0.15, vector3d.z + (double)direction.getStepZ() * 0.15, itemstack);
            rocket.setOwner((Entity)context.getPlayer());
            world.addFreshEntity((Entity)rocket);
            if (!context.getPlayer().isCreative()) {
                itemstack.shrink(1);
            }
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (playerIn.isFallFlying()) {
            ItemStack itemstack = playerIn.getItemInHand(handIn);
            if (!worldIn.isClientSide) {
                worldIn.addFreshEntity((Entity)new EntityEnderiophageRocket(worldIn, itemstack, (LivingEntity)playerIn));
                if (!playerIn.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            }
            return InteractionResultHolder.sidedSuccess((Object)playerIn.getItemInHand(handIn), (boolean)worldIn.isClientSide());
        }
        return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
    }
}

