/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityVoidPortal;
import com.github.alexthe666.alexsmobs.item.AMDataComponents;
import com.github.alexthe666.alexsmobs.item.data.CarverPortalPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ItemDimensionalCarver
extends Item {
    public static final int MAX_TIME = 200;

    public ItemDimensionalCarver(Item.Properties props) {
        super(props);
    }

    protected static BlockHitResult rayTracePortal(Level worldIn, Player player, ClipContext.Fluid fluidMode) {
        float f = player.getXRot();
        float f1 = player.getYRot();
        Vec3 vector3d = player.getEyePosition(1.0f);
        float f11 = -f1 * ((float)Math.PI / 180) - (float)Math.PI;
        float f12 = -f * ((float)Math.PI / 180);
        float f2 = Mth.cos((float)f11);
        float f3 = Mth.sin((float)f11);
        float f4 = -Mth.cos((float)f12);
        float f5 = Mth.sin((float)f12);
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = 1.5;
        Vec3 vector3d1 = vector3d.add((double)f6 * 1.5, (double)f5 * 1.5, (double)f7 * 1.5);
        return worldIn.clip(new ClipContext(vector3d, vector3d1, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        CarverPortalPos portalPos;
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (itemstack.getDamageValue() >= itemstack.getMaxDamage()) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        playerIn.startUsingItem(handIn);
        CarverPortalPos currentPos = (CarverPortalPos)itemstack.get((DataComponentType)AMDataComponents.CARVER_PORTAL_POS.get());
        if (currentPos == null || !currentPos.active()) {
            BlockHitResult raytraceresult = ItemDimensionalCarver.rayTracePortal(worldIn, playerIn, ClipContext.Fluid.ANY);
            Direction dir = Direction.orderedByNearest((Entity)playerIn)[0];
            double x = raytraceresult.getLocation().x - (double)((float)dir.getNormal().getX() * 0.1f);
            double y = raytraceresult.getLocation().y - (double)((float)dir.getNormal().getY() * 0.1f);
            double z = raytraceresult.getLocation().z - (double)((float)dir.getNormal().getZ() * 0.1f);
            itemstack.set((DataComponentType)AMDataComponents.CARVER_PORTAL_POS.get(), (Object)new CarverPortalPos(x, y, z, true));
        }
        if ((portalPos = (CarverPortalPos)itemstack.get((DataComponentType)AMDataComponents.CARVER_PORTAL_POS.get())) != null && portalPos.active()) {
            worldIn.addParticle((ParticleOptions)AMParticleRegistry.INVERT_DIG.get(), portalPos.x(), portalPos.y(), portalPos.z(), (double)playerIn.getId(), 0.0, 0.0);
        }
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 200;
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 100.0f;
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack itemstack, int count) {
        player.swing(player.getUsedItemHand());
        RandomSource random = player.getRandom();
        if (count % 5 == 0) {
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
            player.playSound(SoundEvents.NETHERITE_BLOCK_HIT, 1.0f, 0.5f + random.nextFloat());
        }
        boolean flag = false;
        CarverPortalPos portalPos = (CarverPortalPos)itemstack.get((DataComponentType)AMDataComponents.CARVER_PORTAL_POS.get());
        if (portalPos != null && portalPos.active()) {
            double x = portalPos.x();
            double y = portalPos.y();
            double z = portalPos.z();
            if ((double)random.nextFloat() < 0.2) {
                player.level().addParticle((ParticleOptions)AMParticleRegistry.WORM_PORTAL.get(), x + random.nextGaussian() * (double)0.1f, y + random.nextGaussian() * (double)0.1f, z + random.nextGaussian() * (double)0.1f, random.nextGaussian() * (double)0.1f, (double)-0.1f, random.nextGaussian() * (double)0.1f);
            }
            if (player.distanceToSqr(x, y, z) > 9.0) {
                flag = true;
                if (player instanceof Player) {
                    ((Player)player).getCooldowns().addCooldown((Item)this, 40);
                }
            }
            if (count == 1 && !player.level().isClientSide) {
                player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
                player.playSound(SoundEvents.GLASS_BREAK, 1.0f, 0.5f);
                EntityVoidPortal portal = new EntityVoidPortal(player.level(), this);
                portal.setPos(x, y, z);
                Direction dir = Direction.orderedByNearest((Entity)player)[0].getOpposite();
                if (dir == Direction.UP) {
                    dir = Direction.DOWN;
                }
                portal.setAttachmentFacing(dir);
                player.level().addFreshEntity((Entity)portal);
                this.onPortalOpen(player.level(), player, portal, dir);
                itemstack.hurtAndBreak(1, player, EquipmentSlot.MAINHAND);
                flag = true;
                if (player instanceof Player) {
                    ((Player)player).getCooldowns().addCooldown((Item)this, 200);
                }
            }
        }
        if (flag) {
            player.stopUsingItem();
            itemstack.set((DataComponentType)AMDataComponents.CARVER_PORTAL_POS.get(), (Object)CarverPortalPos.EMPTY);
        }
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        stack.set((DataComponentType)AMDataComponents.CARVER_PORTAL_POS.get(), (Object)CarverPortalPos.EMPTY);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    public void onPortalOpen(Level worldIn, LivingEntity player, EntityVoidPortal portal, Direction dir) {
        BlockPos respawnPosition;
        portal.setLifespan(1200);
        ResourceKey respawnDimension = Level.OVERWORLD;
        BlockPos blockPos = respawnPosition = player.getSleepingPos().isPresent() ? (BlockPos)player.getSleepingPos().get() : player.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, BlockPos.ZERO);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            respawnDimension = serverPlayer.getRespawnDimension();
            if (serverPlayer.getRespawnPosition() != null) {
                respawnPosition = serverPlayer.getRespawnPosition();
            }
        }
        portal.exitDimension = respawnDimension;
        portal.setDestination(respawnPosition.above(2));
    }
}

