/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.item.CustomTabBehavior;
import net.minecraft.nbt.ListTag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.registries.DeferredHolder;

public class AMBlockItem
extends BlockItem
implements CustomTabBehavior {
    private final DeferredHolder<Block, Block> blockSupplier;

    public AMBlockItem(DeferredHolder<Block, Block> blockSupplier, Item.Properties props) {
        super((Block)null, props);
        this.blockSupplier = blockSupplier;
    }

    public Block getBlock() {
        return (Block)this.blockSupplier.get();
    }

    public boolean canFitInsideCraftingRemainingItems() {
        return !(this.blockSupplier.get() instanceof ShulkerBoxBlock);
    }

    public void onDestroyed(ItemEntity p_150700_) {
        if (this.blockSupplier.get() instanceof ShulkerBoxBlock) {
            ItemStack itemstack = p_150700_.getItem();
            Object compoundtag = null;
            if (compoundtag != null && compoundtag.contains("Items", 9)) {
                ListTag listTag = compoundtag.getList("Items", 10);
            }
        }
    }

    public boolean canBeHurtBy(DamageSource damage) {
        return this != ((Block)AMBlockRegistry.TRANSMUTATION_TABLE.get()).asItem() || !damage.is(DamageTypeTags.IS_EXPLOSION);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output contents) {
        if (!this.blockSupplier.equals(AMBlockRegistry.SAND_CIRCLE) && !this.blockSupplier.equals(AMBlockRegistry.RED_SAND_CIRCLE)) {
            contents.accept((ItemLike)this);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        return this.blockSupplier.equals(AMBlockRegistry.TRIOPS_EGGS) ? InteractionResult.PASS : super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (this.blockSupplier.equals(AMBlockRegistry.TRIOPS_EGGS)) {
            BlockHitResult blockhitresult = AMBlockItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            BlockHitResult blockhitresult1 = blockhitresult.withPosition(blockhitresult.getBlockPos().above());
            InteractionResult interactionresult = super.useOn(new UseOnContext(player, hand, blockhitresult1));
            return new InteractionResultHolder(interactionresult, (Object)player.getItemInHand(hand));
        }
        return super.use(level, player, hand);
    }
}

