/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.inventory;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.inventory.AMMenuRegistry;
import com.github.alexthe666.alexsmobs.network.MessageTransmuteFromMenu;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityTransmutationTable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class MenuTransmutationTable
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private long lastSoundTime;
    private final Player player;
    private final Slot transmuteSlot;
    private TileEntityTransmutationTable table;
    public final Container container = new SimpleContainer(1){

        public void setChanged() {
            MenuTransmutationTable.this.slotsChanged((Container)this);
            super.setChanged();
        }
    };

    public MenuTransmutationTable(int i, Inventory inventory) {
        this(i, inventory, ContainerLevelAccess.NULL, AlexsMobs.PROXY.getClientSidePlayer(), null);
    }

    public MenuTransmutationTable(int id, Inventory inventory, ContainerLevelAccess access, Player player, TileEntityTransmutationTable table) {
        super((MenuType)AMMenuRegistry.TRANSMUTATION_TABLE.get(), id);
        this.table = table;
        this.player = player;
        this.access = access;
        this.transmuteSlot = new Slot(this, this.container, 0, 83, 83){

            public boolean mayPlace(ItemStack stack) {
                ResourceLocation name = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                return stack.getMaxStackSize() > 1 && (name == null || !AMConfig.transmutationBlacklist.contains(name.toString()));
            }
        };
        this.addSlot(this.transmuteSlot);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 119 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)inventory, k, 8 + k * 18, 177));
        }
        if (table != null && player != null && !table.hasPossibilities()) {
            table.setRerollPlayerUUID(player.getUUID());
        }
    }

    public boolean stillValid(Player player) {
        return MenuTransmutationTable.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)AMBlockRegistry.TRANSMUTATION_TABLE.get()));
    }

    public void slotsChanged(Container container) {
        if (this.table != null && !this.table.hasPossibilities()) {
            this.table.setRerollPlayerUUID(this.player.getUUID());
        }
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotIndex != 0 ? !this.moveItemStackTo(itemstack1, 0, 1, false) : !this.moveItemStackTo(itemstack1, 1, 36, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
            this.broadcastChanges();
        }
        return itemstack;
    }

    public boolean clickMenuButton(Player player, int buttonId) {
        if (player.level().isClientSide) {
            AlexsMobs.sendMSGToServer(new MessageTransmuteFromMenu(player.getId(), buttonId));
        }
        return true;
    }

    public void transmute(Player player, int buttonId) {
        ItemStack from = this.transmuteSlot.getItem();
        int cost = AMConfig.transmutingExperienceCost;
        ItemStack setTo = this.table.getPossibility(buttonId).copy();
        double divisible = (double)from.getMaxStackSize() / (double)setTo.getMaxStackSize();
        if (!player.level().isClientSide && this.table != null && divisible > 0.0 && this.table.hasPossibilities() && !from.isEmpty() && (player.experienceLevel >= cost || player.getAbilities().instabuild)) {
            int newStackSize = (int)Math.floor((double)from.getCount() / divisible);
            setTo.setCount(Math.max(newStackSize, 1));
            this.transmuteSlot.set(setTo);
            player.giveExperienceLevels(-cost);
            this.table.postTransmute(player, from, setTo);
        }
    }

    public void removed(Player player) {
        super.removed(player);
        this.access.execute((p_39152_, p_39153_) -> this.clearContainer(player, this.container));
    }
}

