/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.event;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityBlobfish;
import com.github.alexthe666.alexsmobs.entity.EntityBunfungus;
import com.github.alexthe666.alexsmobs.entity.EntityCatfish;
import com.github.alexthe666.alexsmobs.entity.EntityCombJelly;
import com.github.alexthe666.alexsmobs.entity.EntityCosmicCod;
import com.github.alexthe666.alexsmobs.entity.EntityDevilsHolePupfish;
import com.github.alexthe666.alexsmobs.entity.EntityElephant;
import com.github.alexthe666.alexsmobs.entity.EntityEmu;
import com.github.alexthe666.alexsmobs.entity.EntityEndergrade;
import com.github.alexthe666.alexsmobs.entity.EntityFly;
import com.github.alexthe666.alexsmobs.entity.EntityFlyingFish;
import com.github.alexthe666.alexsmobs.entity.EntityGiantSquid;
import com.github.alexthe666.alexsmobs.entity.EntityJerboa;
import com.github.alexthe666.alexsmobs.entity.EntityLobster;
import com.github.alexthe666.alexsmobs.entity.EntityMimicOctopus;
import com.github.alexthe666.alexsmobs.entity.EntityMoose;
import com.github.alexthe666.alexsmobs.entity.EntityMudskipper;
import com.github.alexthe666.alexsmobs.entity.EntitySeaBear;
import com.github.alexthe666.alexsmobs.entity.EntitySeal;
import com.github.alexthe666.alexsmobs.entity.EntitySnowLeopard;
import com.github.alexthe666.alexsmobs.entity.EntityTerrapin;
import com.github.alexthe666.alexsmobs.entity.EntityTiger;
import com.github.alexthe666.alexsmobs.entity.EntityTriops;
import com.github.alexthe666.alexsmobs.entity.util.FlyingFishBootsUtil;
import com.github.alexthe666.alexsmobs.entity.util.RainbowUtil;
import com.github.alexthe666.alexsmobs.entity.util.RockyChestplateUtil;
import com.github.alexthe666.alexsmobs.entity.util.VineLassoUtil;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.item.ItemGhostlyPickaxe;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTrigger;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.alexsmobs.misc.EmeraldsForItemsTrade;
import com.github.alexthe666.alexsmobs.misc.ItemsForEmeraldsTrade;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@EventBusSubscriber(modid="alexsmobs")
public class ServerEvents {
    public static final UUID ALEX_UUID = UUID.fromString("71363abe-fd03-49c9-940d-aae8b8209b7c");
    public static final UUID CARRO_UUID = UUID.fromString("98905d4a-1cbc-41a4-9ded-2300404e2290");
    private static final ResourceLocation SAND_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"roadrunner_sand_speed");
    private static final ResourceLocation SNEAK_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"frontier_cap_sneak_speed");
    private static final Random RAND = new Random();
    private static EntityDataAccessor<Integer> PUFF_STATE_ACCESSOR = null;
    private static boolean PUFF_STATE_INIT_ATTEMPTED = false;
    private static Field INFLATE_COUNTER_FIELD = null;
    private static Field DEFLATE_TIMER_FIELD = null;
    private static boolean INFLATE_FIELDS_INIT_ATTEMPTED = false;

    protected static BlockHitResult rayTrace(Level worldIn, Player player, ClipContext.Fluid fluidMode) {
        float x = player.getXRot();
        float y = player.getYRot();
        Vec3 vector3d = player.getEyePosition(1.0f);
        float f0 = -y * ((float)Math.PI / 180) - (float)Math.PI;
        float f1 = -x * ((float)Math.PI / 180);
        float f2 = Mth.cos((float)f0);
        float f3 = Mth.sin((float)f0);
        float f4 = -Mth.cos((float)f1);
        float f5 = Mth.sin((float)f1);
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.blockInteractionRange();
        Vec3 vector3d1 = vector3d.add((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.clip(new ClipContext(vector3d, vector3d1, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }

    private static boolean isNotScaryForPufferfish(LivingEntity entity) {
        return entity instanceof EntityLobster || entity instanceof EntityBlobfish || entity instanceof EntityTerrapin || entity instanceof EntityCombJelly || entity instanceof EntityCosmicCod || entity instanceof EntityCatfish || entity instanceof EntityFlyingFish || entity instanceof EntityMudskipper || entity instanceof EntityTriops || entity instanceof EntityDevilsHolePupfish || entity instanceof AbstractFish || entity instanceof AbstractSchoolingFish || entity instanceof Squid || entity instanceof Dolphin;
    }

    private static void setPufferfishState(Pufferfish pufferfish, int state) {
        block10: {
            if (!PUFF_STATE_INIT_ATTEMPTED) {
                PUFF_STATE_INIT_ATTEMPTED = true;
                try {
                    for (Field field : Pufferfish.class.getDeclaredFields()) {
                        if (!Modifier.isStatic(field.getModifiers()) || !EntityDataAccessor.class.isAssignableFrom(field.getType())) continue;
                        field.setAccessible(true);
                        EntityDataAccessor accessor = (EntityDataAccessor)field.get(null);
                        try {
                            Object value = pufferfish.getEntityData().get(accessor);
                            if (!(value instanceof Integer) || !field.getName().toLowerCase().contains("puff")) continue;
                            PUFF_STATE_ACCESSOR = accessor;
                            break;
                        }
                        catch (Exception value) {
                            // empty catch block
                        }
                    }
                    if (PUFF_STATE_ACCESSOR != null) break block10;
                    int currentPuffState = pufferfish.getPuffState();
                    for (Field field : Pufferfish.class.getDeclaredFields()) {
                        if (!Modifier.isStatic(field.getModifiers()) || !EntityDataAccessor.class.isAssignableFrom(field.getType())) continue;
                        field.setAccessible(true);
                        EntityDataAccessor accessor = (EntityDataAccessor)field.get(null);
                        try {
                            Integer intVal;
                            Object value = pufferfish.getEntityData().get(accessor);
                            if (!(value instanceof Integer) || (intVal = (Integer)value) != currentPuffState) continue;
                            PUFF_STATE_ACCESSOR = accessor;
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception e) {
                    AlexsMobs.LOGGER.warn("Failed to find PUFF_STATE field: " + e.getMessage());
                }
            }
        }
        if (PUFF_STATE_ACCESSOR != null) {
            pufferfish.getEntityData().set(PUFF_STATE_ACCESSOR, (Object)state);
        }
    }

    private static void resetPufferfishInflateCounter(Pufferfish pufferfish) {
        if (!INFLATE_FIELDS_INIT_ATTEMPTED) {
            INFLATE_FIELDS_INIT_ATTEMPTED = true;
            try {
                for (Field field : Pufferfish.class.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers()) || field.getType() != Integer.TYPE) continue;
                    String name = field.getName().toLowerCase();
                    if (name.contains("inflate") || name.contains("counter")) {
                        field.setAccessible(true);
                        INFLATE_COUNTER_FIELD = field;
                        continue;
                    }
                    if (!name.contains("deflate") && !name.contains("timer")) continue;
                    field.setAccessible(true);
                    DEFLATE_TIMER_FIELD = field;
                }
                if (INFLATE_COUNTER_FIELD == null) {
                    for (Field field : Pufferfish.class.getDeclaredFields()) {
                        if (Modifier.isStatic(field.getModifiers()) || field.getType() != Integer.TYPE) continue;
                        field.setAccessible(true);
                        if (INFLATE_COUNTER_FIELD == null) {
                            INFLATE_COUNTER_FIELD = field;
                            continue;
                        }
                        if (DEFLATE_TIMER_FIELD != null) continue;
                        DEFLATE_TIMER_FIELD = field;
                    }
                }
            }
            catch (Exception e) {
                AlexsMobs.LOGGER.warn("Failed to find inflate counter fields: " + e.getMessage());
            }
        }
        try {
            if (INFLATE_COUNTER_FIELD != null) {
                INFLATE_COUNTER_FIELD.setInt(pufferfish, 0);
            }
            if (DEFLATE_TIMER_FIELD != null) {
                DEFLATE_TIMER_FIELD.setInt(pufferfish, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static BlockPos getDownPos(BlockPos entered, LevelAccessor world) {
        for (int i = 0; world.isEmptyBlock(entered) && i < 3; ++i) {
            entered = entered.below();
        }
        return entered;
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        CompoundTag playerData;
        CompoundTag data;
        if (AMConfig.giveBookOnStartup && (data = (playerData = event.getEntity().getPersistentData()).getCompound("PlayerPersisted")) != null && !data.getBoolean("alexsmobs_has_book")) {
            ItemHandlerHelper.giveItemToPlayer((Player)event.getEntity(), (ItemStack)new ItemStack((ItemLike)AMItemRegistry.ANIMAL_DICTIONARY.get()));
            boolean isAlex = Objects.equals(event.getEntity().getUUID(), ALEX_UUID);
            if (isAlex || Objects.equals(event.getEntity().getUUID(), CARRO_UUID)) {
                ItemHandlerHelper.giveItemToPlayer((Player)event.getEntity(), (ItemStack)new ItemStack((ItemLike)AMItemRegistry.BEAR_DUST.get()));
            }
            if (isAlex) {
                ItemHandlerHelper.giveItemToPlayer((Player)event.getEntity(), (ItemStack)new ItemStack((ItemLike)AMItemRegistry.NOVELTY_HAT.get()));
            }
            data.putBoolean("alexsmobs_has_book", true);
            playerData.put("PlayerPersisted", (Tag)data);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttackEntityEvent(AttackEntityEvent event) {
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (event.getEntity().getItemBySlot(EquipmentSlot.HEAD).getItem() == AMItemRegistry.MOOSE_HEADGEAR.get()) {
                living.knockback(1.0, (double)Mth.sin((float)(event.getEntity().getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(event.getEntity().getYRot() * ((float)Math.PI / 180)))));
            }
            if (event.getEntity().hasEffect(AMEffectRegistry.TIGERS_BLESSING) && !event.getTarget().isAlliedTo((Entity)event.getEntity()) && !(event.getTarget() instanceof EntityTiger)) {
                AABB bb = new AABB(event.getEntity().getX() - 32.0, event.getEntity().getY() - 32.0, event.getEntity().getZ() - 32.0, event.getEntity().getX() + 32.0, event.getEntity().getY() + 32.0, event.getEntity().getZ() + 32.0);
                List tigers = event.getEntity().level().getEntitiesOfClass(EntityTiger.class, bb, EntitySelector.ENTITY_STILL_ALIVE);
                for (EntityTiger tiger : tigers) {
                    if (tiger.isBaby()) continue;
                    tiger.setTarget(living);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        if (event.getEntity() != null && event.getEntity().isHolding((Item)AMItemRegistry.GHOSTLY_PICKAXE.get()) && ItemGhostlyPickaxe.shouldStoreInGhost((LivingEntity)event.getEntity(), event.getEntity().getMainHandItem())) {
            event.setCanHarvest(false);
        }
    }

    @SubscribeEvent
    public static void onStruckByLightning(EntityStruckByLightningEvent event) {
        if (event.getEntity().getType() == EntityType.SQUID && !event.getEntity().level().isClientSide) {
            ServerLevel level = (ServerLevel)event.getEntity().level();
            event.setCanceled(true);
            EntityGiantSquid squid = (EntityGiantSquid)((EntityType)AMEntityRegistry.GIANT_SQUID.get()).create((Level)level);
            squid.moveTo(event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), event.getEntity().getYRot(), event.getEntity().getXRot());
            squid.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(squid.blockPosition()), MobSpawnType.CONVERSION, null);
            if (event.getEntity().hasCustomName()) {
                squid.setCustomName(event.getEntity().getCustomName());
                squid.setCustomNameVisible(event.getEntity().isCustomNameVisible());
            }
            squid.setBlue(true);
            squid.setPersistenceRequired();
            level.addFreshEntityWithPassengers((Entity)squid);
            event.getEntity().discard();
        }
    }

    @SubscribeEvent
    public static void onProjectileHit(ProjectileImpactEvent event) {
        EntityHitResult hitResult;
        HitResult hitResult2 = event.getRayTraceResult();
        if (hitResult2 instanceof EntityHitResult && (hitResult2 = (hitResult = (EntityHitResult)hitResult2).getEntity()) instanceof EntityEmu) {
            EntityEmu emu = (EntityEmu)hitResult2;
            if (!event.getEntity().level().isClientSide) {
                if ((emu.getAnimation() == EntityEmu.ANIMATION_DODGE_RIGHT || emu.getAnimation() == EntityEmu.ANIMATION_DODGE_LEFT) && emu.getAnimationTick() < 7) {
                    event.setCanceled(true);
                    return;
                }
                if (emu.getAnimation() != EntityEmu.ANIMATION_DODGE_RIGHT && emu.getAnimation() != EntityEmu.ANIMATION_DODGE_LEFT) {
                    Projectile projectile;
                    Entity entity;
                    Entity entity2;
                    Vec3 arrowPos = event.getEntity().position();
                    Vec3 rightVector = emu.getLookAngle().yRot(1.5707964f).add(emu.position());
                    Vec3 leftVector = emu.getLookAngle().yRot(-1.5707964f).add(emu.position());
                    boolean left = arrowPos.distanceTo(rightVector) < arrowPos.distanceTo(leftVector) ? false : (arrowPos.distanceTo(rightVector) > arrowPos.distanceTo(leftVector) ? true : emu.getRandom().nextBoolean());
                    Vec3 vector3d2 = event.getEntity().getDeltaMovement().yRot((float)((double)(left ? -0.5f : 0.5f) * Math.PI)).normalize();
                    emu.setAnimation(left ? EntityEmu.ANIMATION_DODGE_LEFT : EntityEmu.ANIMATION_DODGE_RIGHT);
                    emu.hasImpulse = true;
                    if (!emu.horizontalCollision) {
                        emu.move(MoverType.SELF, new Vec3(vector3d2.x() * 0.25, (double)0.1f, vector3d2.z() * 0.25));
                    }
                    if ((entity2 = event.getEntity()) instanceof Projectile && (entity = (projectile = (Projectile)entity2).getOwner()) instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        AlexsMobs.LOGGER.info("Emu dodged! Triggering EMU_DODGE advancement for player: {}", (Object)serverPlayer.getName().getString());
                        ((AMAdvancementTrigger)((Object)AMAdvancementTriggerRegistry.EMU_DODGE.get())).trigger(serverPlayer);
                    }
                    emu.setDeltaMovement(emu.getDeltaMovement().add(vector3d2.x() * 0.5, (double)0.32f, vector3d2.z() * 0.5));
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        try {
            if (AMConfig.spidersAttackFlies && entity instanceof Spider) {
                Spider spider = (Spider)entity;
                spider.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)spider, EntityFly.class, 1, true, false, null));
            } else if (AMConfig.wolvesAttackMoose && entity instanceof Wolf) {
                Wolf wolf = (Wolf)entity;
                wolf.targetSelector.addGoal(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)wolf, EntityMoose.class, false, null));
            } else if (AMConfig.polarBearsAttackSeals && entity instanceof PolarBear) {
                PolarBear bear = (PolarBear)entity;
                bear.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)bear, EntitySeal.class, 15, true, true, null));
            } else if (entity instanceof Creeper) {
                Creeper creeper = (Creeper)entity;
                creeper.targetSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)creeper, EntitySnowLeopard.class, 6.0f, 1.0, 1.2));
                creeper.targetSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)creeper, EntityTiger.class, 6.0f, 1.0, 1.2));
            } else if (AMConfig.catsAndFoxesAttackJerboas && (entity instanceof Fox || entity instanceof Cat || entity instanceof Ocelot)) {
                Mob mb = (Mob)entity;
                mb.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal(mb, EntityJerboa.class, 45, true, true, null));
            } else if (AMConfig.bunfungusTransformation && entity instanceof Rabbit) {
                Rabbit rabbit = (Rabbit)entity;
                rabbit.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)rabbit, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AMItemRegistry.MUNGAL_SPORES.get()}), false));
            } else if (AMConfig.dolphinsAttackFlyingFish && entity instanceof Dolphin) {
                Dolphin dolphin = (Dolphin)entity;
                dolphin.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)dolphin, EntityFlyingFish.class, 70, true, true, null));
            }
        }
        catch (Exception e) {
            AlexsMobs.LOGGER.warn("Tried to add unique behaviors to vanilla mobs and encountered an error");
        }
    }

    @SubscribeEvent
    public static void onEntityDrops(LivingDropsEvent event) {
        if (VineLassoUtil.hasLassoData(event.getEntity())) {
            VineLassoUtil.lassoTo(null, event.getEntity());
            event.getDrops().add(new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), new ItemStack((ItemLike)AMItemRegistry.VINE_LASSO.get())));
        }
    }

    @SubscribeEvent
    public static void onItemUseLast(LivingEntityUseItemEvent.Finish event) {
        if (event.getItem().getItem() == Items.CHORUS_FRUIT && RAND.nextInt(3) == 0 && event.getEntity().hasEffect(AMEffectRegistry.ENDER_FLU)) {
            event.getEntity().removeEffect(AMEffectRegistry.ENDER_FLU);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Post event) {
        RandomSource random;
        CompoundTag tag;
        ItemStack boots;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)event.getEntity();
        if (entity instanceof Pufferfish) {
            Pufferfish pufferfish = (Pufferfish)entity;
            if (!entity.level().isClientSide) {
                List nearbyEntities = pufferfish.level().getEntitiesOfClass(LivingEntity.class, pufferfish.getBoundingBox().inflate(2.0), e -> e != pufferfish && !(e instanceof Pufferfish) && !e.isSpectator());
                boolean hasScaryEntity = false;
                boolean hasFriendlyFish = false;
                for (LivingEntity nearby : nearbyEntities) {
                    if (ServerEvents.isNotScaryForPufferfish(nearby)) {
                        hasFriendlyFish = true;
                        continue;
                    }
                    hasScaryEntity = true;
                    break;
                }
                if (hasFriendlyFish && !hasScaryEntity) {
                    ServerEvents.setPufferfishState(pufferfish, 0);
                    ServerEvents.resetPufferfishInflateCounter(pufferfish);
                }
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.getAttributes().hasAttribute(Attributes.MOVEMENT_SPEED)) {
                AttributeInstance attributes = entity.getAttribute(Attributes.MOVEMENT_SPEED);
                if (player.getItemBySlot(EquipmentSlot.FEET).getItem() == AMItemRegistry.ROADDRUNNER_BOOTS.get() || attributes.hasModifier(SAND_SPEED_ID)) {
                    boolean sand = player.level().getBlockState(ServerEvents.getDownPos(player.blockPosition(), (LevelAccessor)player.level())).is(BlockTags.SAND);
                    if (sand && !attributes.hasModifier(SAND_SPEED_ID)) {
                        attributes.addPermanentModifier(new AttributeModifier(SAND_SPEED_ID, (double)0.1f, AttributeModifier.Operation.ADD_VALUE));
                    }
                    if (player.tickCount % 25 == 0 && (player.getItemBySlot(EquipmentSlot.FEET).getItem() != AMItemRegistry.ROADDRUNNER_BOOTS.get() || !sand) && attributes.hasModifier(SAND_SPEED_ID)) {
                        attributes.removeModifier(SAND_SPEED_ID);
                    }
                }
                if (player.getItemBySlot(EquipmentSlot.HEAD).getItem() == AMItemRegistry.FRONTIER_CAP.get() || attributes.hasModifier(SNEAK_SPEED_ID)) {
                    boolean shift = player.isShiftKeyDown();
                    if (shift && !attributes.hasModifier(SNEAK_SPEED_ID)) {
                        attributes.addPermanentModifier(new AttributeModifier(SNEAK_SPEED_ID, (double)0.1f, AttributeModifier.Operation.ADD_VALUE));
                    }
                    if ((!shift || player.getItemBySlot(EquipmentSlot.HEAD).getItem() != AMItemRegistry.FRONTIER_CAP.get()) && attributes.hasModifier(SNEAK_SPEED_ID)) {
                        attributes.removeModifier(SNEAK_SPEED_ID);
                    }
                }
            }
            if (player.getItemBySlot(EquipmentSlot.HEAD).getItem() == AMItemRegistry.SPIKED_TURTLE_SHELL.get() && !player.isEyeInFluid(FluidTags.WATER)) {
                player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 310, 0, false, false, true));
            }
        }
        if (!(boots = entity.getItemBySlot(EquipmentSlot.FEET)).isEmpty() && (tag = ((CustomData)boots.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag()).contains("BisonFur") && tag.getBoolean("BisonFur")) {
            BlockPos posBelow = new BlockPos((int)entity.getX(), (int)(entity.getBoundingBox().minY - (double)0.1f), (int)entity.getZ());
            if (entity.level().getBlockState(posBelow).is(Blocks.POWDER_SNOW)) {
                entity.setOnGround(true);
                entity.setTicksFrozen(0);
                entity.setPos(entity.getX(), Math.max(entity.getY(), (double)((float)posBelow.getY() + 1.0f)), entity.getZ());
            }
            if (entity.isInPowderSnow) {
                entity.setOnGround(true);
                entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, (double)0.1f, 0.0));
            }
        }
        if (entity.getItemBySlot(EquipmentSlot.LEGS).getItem() == AMItemRegistry.CENTIPEDE_LEGGINGS.get() && entity.horizontalCollision && !entity.isInWater()) {
            entity.fallDistance = 0.0f;
            Vec3 motion = entity.getDeltaMovement();
            double d2 = 0.1;
            if (entity.isShiftKeyDown() || entity.isSuppressingSlidingDownLadder()) {
                d2 = 0.0;
            }
            motion = new Vec3(Mth.clamp((double)motion.x, (double)-0.15f, (double)0.15f), d2, Mth.clamp((double)motion.z, (double)-0.15f, (double)0.15f));
            entity.setDeltaMovement(motion);
        }
        if (entity.getItemBySlot(EquipmentSlot.HEAD).getItem() == AMItemRegistry.SOMBRERO.get() && !entity.level().isClientSide && AlexsMobs.isAprilFools() && entity.isInWaterOrBubble() && (random = entity.getRandom()).nextInt(245) == 0 && !EntitySeaBear.isMobSafe((Entity)entity)) {
            int dist = 32;
            List nearbySeabears = entity.level().getEntitiesOfClass(EntitySeaBear.class, entity.getBoundingBox().inflate((double)dist, (double)dist, (double)dist));
            if (nearbySeabears.isEmpty()) {
                EntitySeaBear bear = (EntitySeaBear)((EntityType)AMEntityRegistry.SEA_BEAR.get()).create(entity.level());
                BlockPos at = entity.blockPosition();
                BlockPos farOff = null;
                for (int i = 0; i < 15; ++i) {
                    int f1 = (int)Math.signum((float)random.nextInt() - 0.5f);
                    int f2 = (int)Math.signum((float)random.nextInt() - 0.5f);
                    BlockPos pos1 = at.offset(f1 * (10 + random.nextInt(dist - 10)), random.nextInt(1), f2 * (10 + random.nextInt(dist - 10)));
                    if (!entity.level().isWaterAt(pos1)) continue;
                    farOff = pos1;
                }
                if (farOff != null) {
                    bear.setPos((float)farOff.getX() + 0.5f, (float)farOff.getY() + 0.5f, (float)farOff.getZ() + 0.5f);
                    bear.setYRot(random.nextFloat() * 360.0f);
                    bear.setTarget(entity);
                    entity.level().addFreshEntity((Entity)bear);
                }
            } else {
                for (EntitySeaBear seaBear : nearbySeabears) {
                    seaBear.setTarget(entity);
                }
            }
        }
        if (VineLassoUtil.hasLassoData(entity)) {
            VineLassoUtil.tickLasso(entity);
        }
        if (RockyChestplateUtil.isWearing(entity)) {
            RockyChestplateUtil.tickRockyRolling(entity);
        }
        if (FlyingFishBootsUtil.isWearing(entity)) {
            FlyingFishBootsUtil.tickFlyingFishBoots(entity);
        }
    }

    @SubscribeEvent
    public static void onLivingSetTargetEvent(LivingChangeTargetEvent event) {
        LivingEntity livingEntity;
        if (event.getNewAboutToBeSetTarget() != null && (livingEntity = event.getEntity()) instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            if (mob.getType().is(EntityTypeTags.ARTHROPOD) && event.getNewAboutToBeSetTarget().hasEffect(AMEffectRegistry.BUG_PHEROMONES) && event.getEntity().getLastHurtByMob() != event.getNewAboutToBeSetTarget()) {
                event.setCanceled(true);
                return;
            }
            if (mob.getType().is(EntityTypeTags.UNDEAD) && !mob.getType().is(AMTagRegistry.IGNORES_KIMONO) && event.getNewAboutToBeSetTarget().getItemBySlot(EquipmentSlot.CHEST).is((Item)AMItemRegistry.UNSETTLING_KIMONO.get()) && event.getEntity().getLastHurtByMob() != event.getNewAboutToBeSetTarget()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamageEvent(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity;
            LivingEntity attacker = (LivingEntity)entity;
            if (event.getNewDamage() > 0.0f && attacker.hasEffect(AMEffectRegistry.SOULSTEAL) && attacker.getEffect(AMEffectRegistry.SOULSTEAL) != null) {
                int level = attacker.getEffect(AMEffectRegistry.SOULSTEAL).getAmplifier() + 1;
                if (attacker.getHealth() < attacker.getMaxHealth() && ThreadLocalRandom.current().nextFloat() < 0.25f + (float)level * 0.25f) {
                    attacker.heal(Math.min(event.getNewDamage() / 2.0f * (float)level, (float)(2 + 2 * level)));
                }
            }
            if ((livingEntity = event.getEntity()) instanceof Player) {
                EntityMimicOctopus octopus;
                Player player = (Player)livingEntity;
                if (attacker instanceof EntityMimicOctopus && (octopus = (EntityMimicOctopus)attacker).isOwnedBy((LivingEntity)player)) {
                    event.setNewDamage(0.0f);
                    return;
                }
                if (player.getItemBySlot(EquipmentSlot.HEAD).getItem() == AMItemRegistry.SPIKED_TURTLE_SHELL.get() && attacker.distanceTo((Entity)player) < attacker.getBbWidth() + player.getBbWidth() + 0.5f) {
                    attacker.hurt(attacker.damageSources().thorns((Entity)player), 1.0f);
                    attacker.knockback(0.5, (double)Mth.sin((float)((attacker.getYRot() + 180.0f) * ((float)Math.PI / 180))), (double)(-Mth.cos((float)((attacker.getYRot() + 180.0f) * ((float)Math.PI / 180)))));
                }
            }
        }
        if (!event.getEntity().getItemBySlot(EquipmentSlot.LEGS).isEmpty() && event.getEntity().getItemBySlot(EquipmentSlot.LEGS).getItem() == AMItemRegistry.EMU_LEGGINGS.get() && event.getSource().is(DamageTypeTags.IS_PROJECTILE) && (double)event.getEntity().getRandom().nextFloat() < AMConfig.emuPantsDodgeChance) {
            event.setNewDamage(0.0f);
        }
    }

    @SubscribeEvent
    public static void onUseItem(PlayerInteractEvent.RightClickItem event) {
        BlockHitResult raytraceresult;
        EntityElephant elephant;
        Entity entity;
        Player player = event.getEntity();
        if (event.getItemStack().getItem() == Items.WHEAT && (entity = player.getVehicle()) instanceof EntityElephant && (elephant = (EntityElephant)entity).triggerCharge(event.getItemStack())) {
            player.swing(event.getHand());
            if (!player.isCreative()) {
                event.getItemStack().shrink(1);
            }
        }
        if (event.getItemStack().getItem() == Items.GLASS_BOTTLE && AMConfig.lavaBottleEnabled && (raytraceresult = ServerEvents.rayTrace(event.getLevel(), player, ClipContext.Fluid.SOURCE_ONLY)).getType() == HitResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.getBlockPos();
            if (event.getLevel().mayInteract(player, blockpos) && event.getLevel().getFluidState(blockpos).is(FluidTags.LAVA)) {
                player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
                event.getLevel().playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                player.awardStat(Stats.ITEM_USED.get((Object)Items.GLASS_BOTTLE));
                player.igniteForSeconds(6.0f);
                if (!player.addItem(new ItemStack((ItemLike)AMItemRegistry.LAVA_BOTTLE.get()))) {
                    player.spawnAtLocation(new ItemStack((ItemLike)AMItemRegistry.LAVA_BOTTLE.get()));
                }
                player.swing(event.getHand());
                if (!player.isCreative()) {
                    event.getItemStack().shrink(1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!event.getEntity().isShiftKeyDown() && VineLassoUtil.hasLassoData(living)) {
                if (!event.getEntity().level().isClientSide) {
                    event.getTarget().spawnAtLocation(new ItemStack((ItemLike)AMItemRegistry.VINE_LASSO.get()));
                }
                VineLassoUtil.lassoTo(null, living);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            if (!(event.getTarget() instanceof Player) && !(event.getTarget() instanceof EntityEndergrade) && living.hasEffect(AMEffectRegistry.ENDER_FLU) && event.getItemStack().getItem() == Items.CHORUS_FRUIT) {
                if (!event.getEntity().isCreative()) {
                    event.getItemStack().shrink(1);
                }
                event.getTarget().gameEvent((Holder)GameEvent.EAT);
                event.getTarget().playSound(SoundEvents.GENERIC_EAT, 1.0f, 0.5f + event.getEntity().getRandom().nextFloat());
                if (event.getEntity().getRandom().nextFloat() < 0.4f) {
                    living.removeEffect(AMEffectRegistry.ENDER_FLU);
                    Items.CHORUS_FRUIT.finishUsingItem(event.getItemStack().copy(), event.getLevel(), living);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            if (RainbowUtil.getRainbowType(living) > 0 && event.getItemStack().getItem() == Items.SPONGE) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                RainbowUtil.setRainbowType(living, 0);
                if (!event.getEntity().isCreative()) {
                    event.getItemStack().shrink(1);
                }
                ItemStack wetSponge = new ItemStack((ItemLike)Items.WET_SPONGE);
                if (!event.getEntity().addItem(wetSponge)) {
                    event.getEntity().drop(wetSponge, true);
                }
            }
            if (living instanceof Rabbit) {
                Rabbit rabbit = (Rabbit)living;
                if (event.getItemStack().getItem() == AMItemRegistry.MUNGAL_SPORES.get() && AMConfig.bunfungusTransformation) {
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    if (!event.getEntity().level().isClientSide && random.nextFloat() < 0.15f) {
                        EntityBunfungus bunfungus = (EntityBunfungus)rabbit.convertTo((EntityType)AMEntityRegistry.BUNFUNGUS.get(), true);
                        if (bunfungus != null) {
                            event.getEntity().level().addFreshEntity((Entity)bunfungus);
                            bunfungus.setTransformsIn(50);
                        }
                    } else {
                        for (int i = 0; i < 2 + random.nextInt(2); ++i) {
                            double d0 = random.nextGaussian() * 0.02;
                            double d1 = (double)0.05f + random.nextGaussian() * 0.02;
                            double d2 = random.nextGaussian() * 0.02;
                            event.getTarget().level().addParticle((ParticleOptions)AMParticleRegistry.BUNFUNGUS_TRANSFORMATION.get(), event.getTarget().getRandomX((double)0.7f), event.getTarget().getY((double)0.6f), event.getTarget().getRandomZ((double)0.7f), d0, d1, d2);
                        }
                    }
                    if (!event.getEntity().isCreative()) {
                        event.getItemStack().shrink(1);
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onUseItemAir(PlayerInteractEvent.RightClickEmpty event) {
        ItemStack stack = event.getEntity().getItemInHand(event.getHand());
        if (stack.isEmpty()) {
            stack = event.getEntity().getItemBySlot(EquipmentSlot.MAINHAND);
        }
        if (RainbowUtil.getRainbowType((LivingEntity)event.getEntity()) > 0 && stack.is(Items.SPONGE)) {
            event.getEntity().swing(InteractionHand.MAIN_HAND);
            RainbowUtil.setRainbowType((LivingEntity)event.getEntity(), 0);
            if (!event.getEntity().isCreative()) {
                stack.shrink(1);
            }
            ItemStack wetSponge = new ItemStack((ItemLike)Items.WET_SPONGE);
            if (!event.getEntity().addItem(wetSponge)) {
                event.getEntity().drop(wetSponge, true);
            }
        }
    }

    @SubscribeEvent
    public static void onUseItemOnBlock(PlayerInteractEvent.RightClickBlock event) {
        if (AlexsMobs.isAprilFools() && event.getItemStack().is(Items.STICK) && !event.getEntity().getCooldowns().isOnCooldown(Items.STICK)) {
            BlockState state = event.getEntity().level().getBlockState(event.getPos());
            boolean flag = false;
            if (state.is(Blocks.SAND)) {
                flag = true;
                event.getEntity().level().setBlockAndUpdate(event.getPos(), ((Block)AMBlockRegistry.SAND_CIRCLE.get()).defaultBlockState());
            } else if (state.is(Blocks.RED_SAND)) {
                flag = true;
                event.getEntity().level().setBlockAndUpdate(event.getPos(), ((Block)AMBlockRegistry.RED_SAND_CIRCLE.get()).defaultBlockState());
            }
            if (flag) {
                event.setCanceled(true);
                event.getEntity().gameEvent((Holder)GameEvent.BLOCK_PLACE);
                event.getEntity().playSound(SoundEvents.SAND_BREAK, 1.0f, 1.0f);
                event.getEntity().getCooldowns().addCooldown(Items.STICK, 30);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public static void onTradeSetup(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.FISHERMAN) {
            EmeraldsForItemsTrade ambergrisTrade = new EmeraldsForItemsTrade((ItemLike)AMItemRegistry.AMBERGRIS.get(), 20, 3, 4);
            List list = (List)event.getTrades().get(2);
            list.add(ambergrisTrade);
            event.getTrades().put(2, (Object)list);
        }
    }

    @SubscribeEvent
    public static void onWanderingTradeSetup(WandererTradesEvent event) {
        if (AMConfig.wanderingTraderOffers) {
            List genericTrades = event.getGenericTrades();
            List rareTrades = event.getRareTrades();
            genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.ANIMAL_DICTIONARY.get(), 4, 1, 2, 1));
            genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.ACACIA_BLOSSOM.get(), 3, 2, 2, 1));
            if (AMConfig.cockroachSpawnWeight > 0) {
                genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.COCKROACH_OOTHECA.get(), 2, 1, 2, 1));
            }
            if (AMConfig.blobfishSpawnWeight > 0) {
                genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.BLOBFISH_BUCKET.get(), 4, 1, 3, 1));
            }
            if (AMConfig.crocodileSpawnWeight > 0) {
                genericTrades.add(new ItemsForEmeraldsTrade(((Block)AMBlockRegistry.CROCODILE_EGG.get()).asItem(), 6, 1, 2, 1));
            }
            genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.BEAR_FUR.get(), 1, 1, 2, 1));
            genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.CROCODILE_SCUTE.get(), 5, 1, 2, 1));
            genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.ROADRUNNER_FEATHER.get(), 1, 2, 2, 2));
            genericTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.MOSQUITO_LARVA.get(), 1, 3, 5, 1));
            rareTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.SOMBRERO.get(), 20, 1, 1, 1));
            rareTrades.add(new ItemsForEmeraldsTrade((Block)AMBlockRegistry.BANANA_PEEL.get(), 1, 2, 1, 1));
            rareTrades.add(new ItemsForEmeraldsTrade((Item)AMItemRegistry.BLOOD_SAC.get(), 5, 2, 3, 1));
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        CompoundTag tag;
        CustomData customData = (CustomData)event.getItemStack().get(DataComponents.CUSTOM_DATA);
        if (customData != null && (tag = customData.copyTag()).contains("BisonFur") && tag.getBoolean("BisonFur")) {
            event.getToolTip().add(Component.translatable((String)"item.alexsmobs.insulated_with_fur").withStyle(ChatFormatting.AQUA));
        }
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        AlexsMobs.LOGGER.info("Adding datapack listener capsid_recipes");
        event.addListener((PreparableReloadListener)AlexsMobs.PROXY.getCapsidRecipeManager());
    }
}

