/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.util;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.entity.EntityTendonSegment;
import com.github.alexthe666.alexsmobs.network.MessageSyncEntityData;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class TendonWhipUtil {
    private static final String LAST_TENDON_UUID = "LastTendonUUIDAlexsMobs";
    private static final String LAST_TENDON_ID = "LastTendonIDAlexsMobs";

    private static void sync(LivingEntity enchanted, CompoundTag tag) {
        CitadelEntityData.setCitadelTag((LivingEntity)enchanted, (CompoundTag)tag);
        if (!enchanted.level().isClientSide) {
            AlexsMobs.sendMSGToAll(new MessageSyncEntityData(enchanted.getId(), tag));
        }
    }

    public static void setLastTendon(LivingEntity entity, EntityTendonSegment tendon) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        if (tendon == null) {
            tag.remove(LAST_TENDON_UUID);
            tag.putInt(LAST_TENDON_ID, -1);
        } else {
            tag.putUUID(LAST_TENDON_UUID, tendon.getUUID());
            tag.putInt(LAST_TENDON_ID, tendon.getId());
        }
        TendonWhipUtil.sync(entity, tag);
    }

    private static UUID getLastTendonUUID(LivingEntity entity) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        if (tag.contains(LAST_TENDON_UUID)) {
            return tag.getUUID(LAST_TENDON_UUID);
        }
        return null;
    }

    public static int getLastTendonId(LivingEntity entity) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        if (tag.contains(LAST_TENDON_ID)) {
            return tag.getInt(LAST_TENDON_ID);
        }
        return -1;
    }

    public static void retractFarTendons(Level level, LivingEntity player) {
        EntityTendonSegment last = TendonWhipUtil.getLastTendon(player);
        if (last != null) {
            last.remove(Entity.RemovalReason.DISCARDED);
            TendonWhipUtil.setLastTendon(player, null);
        }
    }

    public static boolean canLaunchTendons(Level level, LivingEntity player) {
        EntityTendonSegment last = TendonWhipUtil.getLastTendon(player);
        if (last != null) {
            return last.isRemoved() || last.distanceTo((Entity)player) > 30.0f;
        }
        return true;
    }

    public static EntityTendonSegment getLastTendon(LivingEntity player) {
        UUID uuid = TendonWhipUtil.getLastTendonUUID(player);
        int id = TendonWhipUtil.getLastTendonId(player);
        if (!player.level().isClientSide) {
            if (uuid != null) {
                Entity e = player.level().getEntity(id);
                return e instanceof EntityTendonSegment ? (EntityTendonSegment)e : null;
            }
        } else if (id != -1) {
            Entity e = player.level().getEntity(id);
            return e instanceof EntityTendonSegment ? (EntityTendonSegment)e : null;
        }
        return null;
    }
}

