/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.util;

import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class RockyChestplateUtil {
    private static final int MAX_ROLL_TICKS = 30;
    private static final Map<UUID, Integer> rollTicksMap = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> rollTimestampMap = new HashMap<UUID, Integer>();

    public static void rollFor(LivingEntity roller, int ticks) {
        UUID uuid = roller.getUUID();
        rollTicksMap.put(uuid, ticks);
        if (ticks == 30) {
            rollTimestampMap.put(uuid, roller.tickCount);
        }
    }

    public static int getRollingTicksLeft(LivingEntity entity) {
        return rollTicksMap.getOrDefault(entity.getUUID(), 0);
    }

    public static int getRollingTimestamp(LivingEntity entity) {
        return rollTimestampMap.getOrDefault(entity.getUUID(), 0);
    }

    public static boolean isWearing(LivingEntity entity) {
        return entity.getItemBySlot(EquipmentSlot.CHEST).getItem() == AMItemRegistry.ROCKY_CHESTPLATE.get();
    }

    public static boolean isRockyRolling(LivingEntity entity) {
        return RockyChestplateUtil.isWearing(entity) && RockyChestplateUtil.getRollingTicksLeft(entity) > 0;
    }

    public static void tickRockyRolling(LivingEntity roller) {
        int rollCounter;
        if (roller.isInWaterOrBubble()) {
            roller.setDeltaMovement(roller.getDeltaMovement().add(0.0, (double)-0.015f, 0.0));
        }
        if ((rollCounter = RockyChestplateUtil.getRollingTicksLeft(roller)) == 0) {
            if (!(!roller.isSprinting() || roller.isShiftKeyDown() || roller instanceof Player && ((Player)roller).getAbilities().flying || !RockyChestplateUtil.canRollAgain(roller) || roller.isPassenger())) {
                RockyChestplateUtil.rollFor(roller, 30);
            }
            if (roller instanceof Player && ((Player)roller).getForcedPose() == Pose.SWIMMING) {
                ((Player)roller).setForcedPose(null);
            }
        } else {
            if (roller instanceof Player) {
                ((Player)roller).setForcedPose(Pose.SWIMMING);
            }
            if (!roller.level().isClientSide) {
                for (Entity entity : roller.level().getEntitiesOfClass(LivingEntity.class, roller.getBoundingBox().inflate(1.0))) {
                    if (roller.isAlliedTo(entity) || entity.isAlliedTo((Entity)roller) || entity == roller) continue;
                    entity.hurt(entity.damageSources().mobAttack(roller), 2.0f + roller.getRandom().nextFloat() * 1.0f);
                }
            }
            if (roller.fallDistance > 3.0f) {
                roller.fallDistance -= 0.5f;
            }
            roller.refreshDimensions();
            Vec3 vec3 = roller.onGround() ? roller.getDeltaMovement() : roller.getDeltaMovement().multiply(0.9, 1.0, 0.9);
            float f = roller.getYRot() * ((float)Math.PI / 180);
            float f1 = roller.isInWaterOrBubble() ? 0.05f : 0.15f;
            Vec3 rollDelta = new Vec3(vec3.x + (double)(-Mth.sin((float)f) * f1), 0.0, vec3.z + (double)(Mth.cos((float)f) * f1));
            double rollY = roller.isInWaterOrBubble() || roller.isShiftKeyDown() ? (double)-0.1f : (rollCounter >= 30 ? 0.27 : vec3.y);
            roller.setDeltaMovement(rollDelta.add(0.0, rollY, 0.0));
            if (rollCounter > 1 || !roller.isSprinting()) {
                RockyChestplateUtil.rollFor(roller, rollCounter - 1);
            }
            if ((roller instanceof Player && ((Player)roller).getAbilities().flying || roller.isShiftKeyDown()) && RockyChestplateUtil.canRollAgain(roller)) {
                RockyChestplateUtil.rollFor(roller, 0);
            }
        }
    }

    private static boolean canRollAgain(LivingEntity roller) {
        return roller.tickCount - RockyChestplateUtil.getRollingTimestamp(roller) >= 20 || Math.abs(roller.tickCount - RockyChestplateUtil.getRollingTimestamp(roller)) > 100;
    }

    public static void cleanup(UUID uuid) {
        rollTicksMap.remove(uuid);
        rollTimestampMap.remove(uuid);
    }
}

