/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntitySnowLeopard;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class SnowLeopardAIMelee
extends Goal {
    private final EntitySnowLeopard leopard;
    private LivingEntity target;
    private boolean secondPartOfLeap = false;
    private Vec3 leapPos = null;
    private int jumpCooldown = 0;
    private boolean stalk = false;

    public SnowLeopardAIMelee(EntitySnowLeopard snowLeopard) {
        this.leopard = snowLeopard;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Nullable
    private static BlockPos getRandomDelta(RandomSource p_226343_0_, int p_226343_1_, int p_226343_2_, int p_226343_3_, @Nullable Vec3 p_226343_4_, double p_226343_5_) {
        if (p_226343_4_ != null && p_226343_5_ < Math.PI) {
            double lvt_7_2_ = Mth.atan2((double)p_226343_4_.z, (double)p_226343_4_.x) - 1.5707963705062866;
            double lvt_9_2_ = lvt_7_2_ + (double)(2.0f * p_226343_0_.nextFloat() - 1.0f) * p_226343_5_;
            double lvt_11_1_ = Math.sqrt(p_226343_0_.nextDouble()) * (double)Mth.SQRT_OF_TWO * (double)p_226343_1_;
            double lvt_13_1_ = -lvt_11_1_ * Math.sin(lvt_9_2_);
            double lvt_15_1_ = lvt_11_1_ * Math.cos(lvt_9_2_);
            if (Math.abs(lvt_13_1_) <= (double)p_226343_1_ && Math.abs(lvt_15_1_) <= (double)p_226343_1_) {
                int lvt_17_1_ = p_226343_0_.nextInt(2 * p_226343_2_ + 1) - p_226343_2_ + p_226343_3_;
                return AMBlockPos.fromCoords(lvt_13_1_, lvt_17_1_, lvt_15_1_);
            }
            return null;
        }
        int lvt_7_1_ = p_226343_0_.nextInt(2 * p_226343_1_ + 1) - p_226343_1_;
        int lvt_8_1_ = p_226343_0_.nextInt(2 * p_226343_2_ + 1) - p_226343_2_ + p_226343_3_;
        int lvt_9_1_ = p_226343_0_.nextInt(2 * p_226343_1_ + 1) - p_226343_1_;
        return new BlockPos(lvt_7_1_, lvt_8_1_, lvt_9_1_);
    }

    public static BlockPos moveUpToAboveSolid(BlockPos p_226342_0_, int p_226342_1_, int p_226342_2_, Predicate<BlockPos> p_226342_3_) {
        BlockPos lvt_6_1_;
        if (p_226342_1_ < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + p_226342_1_ + ", expected >= 0");
        }
        if (!p_226342_3_.test(p_226342_0_)) {
            return p_226342_0_;
        }
        BlockPos lvt_4_1_ = p_226342_0_.above();
        while (lvt_4_1_.getY() < p_226342_2_ && p_226342_3_.test(lvt_4_1_)) {
            lvt_4_1_ = lvt_4_1_.above();
        }
        BlockPos lvt_5_1_ = lvt_4_1_;
        while (lvt_5_1_.getY() < p_226342_2_ && lvt_5_1_.getY() - lvt_4_1_.getY() < p_226342_1_ && !p_226342_3_.test(lvt_6_1_ = lvt_5_1_.above())) {
            lvt_5_1_ = lvt_6_1_;
        }
        return lvt_5_1_;
    }

    public boolean canUse() {
        return this.leopard.getTarget() != null && !this.leopard.isSleeping() && !this.leopard.isSitting() && (this.leopard.getTarget().isAlive() || this.leopard.getTarget() instanceof Player) && !this.leopard.isBaby();
    }

    public void start() {
        this.target = this.leopard.getTarget();
        this.stalk = this.target instanceof Player && this.leopard.getLastHurtByMob() != null && this.leopard.getLastHurtByMob() == this.target ? this.leopard.distanceTo((Entity)this.target) > 10.0f : this.leopard.distanceTo((Entity)this.target) > 4.0f;
        this.secondPartOfLeap = false;
    }

    public void stop() {
        this.secondPartOfLeap = false;
        this.stalk = false;
        this.leapPos = null;
        this.jumpCooldown = 0;
        this.leopard.setTackling(false);
        this.leopard.setSlSneaking(false);
    }

    public void tick() {
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        if (this.stalk) {
            if (this.secondPartOfLeap) {
                this.leopard.setTackling(!this.leopard.onGround());
                this.leopard.lookAt((Entity)this.target, 180.0f, 10.0f);
                this.leopard.yBodyRot = this.leopard.getYRot();
                if (this.leopard.distanceTo((Entity)this.target) < 3.0f && this.leopard.hasLineOfSight((Entity)this.target)) {
                    this.target.hurt(this.leopard.damageSources().mobAttack((LivingEntity)this.leopard), (float)(this.leopard.getAttribute(Attributes.ATTACK_DAMAGE).getValue() * 2.5));
                    this.stalk = false;
                    this.secondPartOfLeap = false;
                } else if (this.leopard.onGround() && this.jumpCooldown == 0) {
                    this.leopard.setSlSneaking(false);
                    this.jumpCooldown = 10 + this.leopard.getRandom().nextInt(10);
                    Vec3 vector3d = this.leopard.getDeltaMovement();
                    Vec3 vector3d1 = new Vec3(this.target.getX() - this.leopard.getX(), 0.0, this.target.getZ() - this.leopard.getZ());
                    if (vector3d1.lengthSqr() > 1.0E-7) {
                        vector3d1 = vector3d1.normalize().scale(0.9).add(vector3d.scale(0.8));
                    }
                    this.leopard.setDeltaMovement(vector3d1.x, vector3d1.y + (double)0.6f, vector3d1.z);
                }
            } else if (this.leapPos == null || this.target.distanceToSqr(this.leapPos) > 250.0) {
                Vec3 vector3d1 = this.calculateFarPoint(50.0);
                this.leapPos = vector3d1 != null ? vector3d1 : LandRandomPos.getPosTowards((PathfinderMob)this.leopard, (int)10, (int)10, (Vec3)this.target.position());
            } else {
                this.leopard.setSlSneaking(true);
                this.leopard.getNavigation().moveTo(this.leapPos.x, this.leapPos.y, this.leapPos.z, 1.0);
                if (this.leopard.distanceToSqr(this.leapPos.x, this.leapPos.y, this.leapPos.z) < 9.0 && this.leopard.hasLineOfSight((Entity)this.target)) {
                    this.secondPartOfLeap = true;
                    this.leopard.getNavigation().stop();
                }
            }
        } else {
            this.leopard.setSlSneaking(false);
            this.leopard.getNavigation().moveTo((Entity)this.target, 1.0);
            if (this.leopard.distanceTo((Entity)this.target) < 3.0f) {
                if (this.leopard.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    this.leopard.setAnimation(this.leopard.getRandom().nextBoolean() ? EntitySnowLeopard.ANIMATION_ATTACK_R : EntitySnowLeopard.ANIMATION_ATTACK_L);
                } else if (this.leopard.getAnimationTick() == 5) {
                    this.leopard.doHurtTarget((Entity)this.target);
                }
            }
        }
    }

    private Vec3 calculateFarPoint(double dist) {
        Vec3 highest = null;
        for (int i = 0; i < 10; ++i) {
            Vec3 vector3d1 = this.calculateVantagePoint(this.target, 8, 3, 1, this.target.position().subtract(this.leopard.getX(), this.leopard.getY(), this.leopard.getZ()), false, 1.5707963705062866, arg_0 -> ((EntitySnowLeopard)this.leopard).getWalkTargetValue(arg_0), false, 0, 0, true);
            if (vector3d1 == null || !(this.target.distanceToSqr(vector3d1) > dist) || highest != null && !(highest.y() < vector3d1.y)) continue;
            highest = vector3d1;
        }
        return highest;
    }

    @Nullable
    private Vec3 calculateVantagePoint(LivingEntity creature, int xz, int y, int p_226339_3_, @Nullable Vec3 p_226339_4_, boolean p_226339_5_, double p_226339_6_, ToDoubleFunction<BlockPos> p_226339_8_, boolean p_226339_9_, int p_226339_10_, int p_226339_11_, boolean p_226339_12_) {
        PathNavigation lvt_13_1_ = this.leopard.getNavigation();
        RandomSource lvt_14_1_ = creature.getRandom();
        boolean lvt_15_2_ = this.leopard.hasRestriction() ? this.leopard.getRestrictCenter().closerToCenterThan((Position)creature.position(), (double)(this.leopard.getRestrictRadius() + (float)xz) + 1.0) : false;
        boolean lvt_16_1_ = false;
        double lvt_17_1_ = Double.NEGATIVE_INFINITY;
        BlockPos lvt_19_1_ = creature.blockPosition();
        for (int lvt_20_1_ = 0; lvt_20_1_ < 10; ++lvt_20_1_) {
            double lvt_27_1_;
            PathType lvt_26_1_;
            BlockPos lvt_25_2_;
            BlockPos lvt_21_1_ = SnowLeopardAIMelee.getRandomDelta(lvt_14_1_, xz, y, p_226339_3_, p_226339_4_, p_226339_6_);
            if (lvt_21_1_ == null) continue;
            int lvt_22_1_ = lvt_21_1_.getX();
            int lvt_23_1_ = lvt_21_1_.getY();
            int lvt_24_1_ = lvt_21_1_.getZ();
            if (this.leopard.hasRestriction() && xz > 1) {
                lvt_25_2_ = this.leopard.getRestrictCenter();
                lvt_22_1_ = creature.getX() > (double)lvt_25_2_.getX() ? (lvt_22_1_ -= lvt_14_1_.nextInt(xz / 2)) : (lvt_22_1_ += lvt_14_1_.nextInt(xz / 2));
                lvt_24_1_ = creature.getZ() > (double)lvt_25_2_.getZ() ? (lvt_24_1_ -= lvt_14_1_.nextInt(xz / 2)) : (lvt_24_1_ += lvt_14_1_.nextInt(xz / 2));
            }
            if ((lvt_25_2_ = AMBlockPos.fromCoords((double)lvt_22_1_ + creature.getX(), (double)lvt_23_1_ + creature.getY(), (double)lvt_24_1_ + creature.getZ())).getY() < 0 || lvt_25_2_.getY() > creature.level().getMaxBuildHeight() || lvt_15_2_ && !this.leopard.isWithinRestriction(lvt_25_2_) || p_226339_12_ && !lvt_13_1_.isStableDestination(lvt_25_2_)) continue;
            if (p_226339_9_) {
                lvt_25_2_ = SnowLeopardAIMelee.moveUpToAboveSolid(lvt_25_2_, lvt_14_1_.nextInt(p_226339_10_ + 1) + p_226339_11_, creature.level().getMaxBuildHeight(), p_226341_1_ -> creature.level().getBlockState(p_226341_1_).isSolid());
            }
            if (!p_226339_5_ && creature.level().getFluidState(lvt_25_2_).is(FluidTags.WATER) || this.leopard.getPathfindingMalus(lvt_26_1_ = PathType.WALKABLE) != 0.0f || !((lvt_27_1_ = p_226339_8_.applyAsDouble(lvt_25_2_)) > lvt_17_1_)) continue;
            lvt_17_1_ = lvt_27_1_;
            lvt_19_1_ = lvt_25_2_;
            lvt_16_1_ = true;
        }
        if (lvt_16_1_) {
            return Vec3.atBottomCenterOf((Vec3i)lvt_19_1_);
        }
        return null;
    }
}

