/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityShoebill;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class ShoebillAIFlightFlee
extends Goal {
    private final EntityShoebill bird;
    private BlockPos currentTarget = null;
    private int executionTime = 0;

    public ShoebillAIFlightFlee(EntityShoebill bird) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.bird = bird;
    }

    public void stop() {
        this.currentTarget = null;
        this.executionTime = 0;
        this.bird.setFlying(false);
    }

    public boolean canContinueToUse() {
        return this.bird.isFlying() && (this.executionTime < 15 || !this.bird.onGround());
    }

    public boolean canUse() {
        return this.bird.revengeCooldown > 0 && this.bird.onGround();
    }

    public void start() {
        if (this.bird.onGround()) {
            this.bird.setFlying(true);
        }
    }

    public void tick() {
        ++this.executionTime;
        if (this.currentTarget == null) {
            this.currentTarget = this.bird.revengeCooldown == 0 ? this.getBlockGrounding(this.bird.position()) : this.getBlockInViewAway(this.bird.position());
        }
        if (this.currentTarget != null) {
            this.bird.getNavigation().moveTo((double)((float)this.currentTarget.getX() + 0.5f), (double)((float)this.currentTarget.getY() + 0.5f), (double)((float)this.currentTarget.getZ() + 0.5f), 1.0);
            if (this.bird.distanceToSqr(Vec3.atCenterOf((Vec3i)this.currentTarget)) < 4.0) {
                this.currentTarget = null;
            }
        }
        if (this.bird.revengeCooldown == 0 && (this.bird.isInWater() || !this.bird.level().isEmptyBlock(this.bird.blockPosition().below()))) {
            this.stop();
            this.bird.setFlying(false);
        }
    }

    public BlockPos getBlockInViewAway(Vec3 fleePos) {
        float radius = -9.45f - (float)this.bird.getRandom().nextInt(24);
        float neg = this.bird.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.bird.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.bird.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = AMBlockPos.fromCoords(fleePos.x() + extraX, 0.0, fleePos.z() + extraZ);
        BlockPos ground = this.bird.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        int distFromGround = (int)this.bird.getY() - ground.getY();
        int flightHeight = 4 + this.bird.getRandom().nextInt(10);
        BlockPos newPos = radialPos.above(distFromGround > 8 ? flightHeight : (int)this.bird.getY() + this.bird.getRandom().nextInt(6) + 1);
        if (!this.bird.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos)) && this.bird.distanceToSqr(Vec3.atCenterOf((Vec3i)newPos)) > 6.0) {
            return newPos;
        }
        return null;
    }

    public BlockPos getBlockGrounding(Vec3 fleePos) {
        float radius = -9.45f - (float)this.bird.getRandom().nextInt(24);
        float neg = this.bird.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.bird.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.bird.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = AMBlockPos.fromCoords(fleePos.x() + extraX, 0.0, fleePos.z() + extraZ);
        BlockPos ground = this.bird.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        if (!this.bird.isTargetBlocked(Vec3.atCenterOf((Vec3i)ground.above()))) {
            return ground;
        }
        return null;
    }
}

