/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.EntitySeagull;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTrigger;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class SeagullAIStealFromPlayers
extends Goal {
    private final EntitySeagull seagull;
    private Vec3 fleeVec = null;
    private Player target;
    private int fleeTime = 0;

    public SeagullAIStealFromPlayers(EntitySeagull entitySeagull) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
        this.seagull = entitySeagull;
    }

    public boolean canUse() {
        Player valid;
        long worldTime = this.seagull.level().getGameTime() % 10L;
        if (this.seagull.getNoActionTime() >= 100 && worldTime != 0L || this.seagull.isSitting() || !AMConfig.seagullStealing) {
            return false;
        }
        if (this.seagull.getRandom().nextInt(12) != 0 && worldTime != 0L || this.seagull.stealCooldown > 0) {
            return false;
        }
        if (this.seagull.getMainHandItem().isEmpty() && (valid = this.getClosestValidPlayer()) != null) {
            this.target = valid;
            return true;
        }
        return false;
    }

    public void start() {
        this.seagull.aiItemFlag = true;
    }

    public void stop() {
        this.seagull.aiItemFlag = false;
        this.target = null;
        this.fleeVec = null;
        this.fleeTime = 0;
    }

    public boolean canContinueToUse() {
        return this.target != null && !this.target.isCreative() && (this.seagull.getMainHandItem().isEmpty() || this.fleeTime > 0);
    }

    public void tick() {
        this.seagull.setFlying(true);
        this.seagull.getMoveControl().setWantedPosition(this.target.getX(), this.target.getEyeY(), this.target.getZ(), (double)1.2f);
        if (this.seagull.distanceTo((Entity)this.target) < 2.0f && this.seagull.getMainHandItem().isEmpty()) {
            if (this.hasFoods(this.target)) {
                ItemStack foodStack = this.getFoodItemFrom(this.target);
                if (!foodStack.isEmpty()) {
                    ItemStack copy = foodStack.copy();
                    foodStack.shrink(1);
                    copy.setCount(1);
                    this.seagull.peck();
                    this.seagull.setItemInHand(InteractionHand.MAIN_HAND, copy);
                    this.fleeTime = 60;
                    this.seagull.stealCooldown = 1500 + this.seagull.getRandom().nextInt(1500);
                    if (this.target instanceof ServerPlayer) {
                        ((AMAdvancementTrigger)((Object)AMAdvancementTriggerRegistry.SEAGULL_STEAL.get())).trigger((ServerPlayer)this.target);
                    }
                } else {
                    this.stop();
                }
            } else {
                this.stop();
            }
        }
        if (this.fleeTime > 0) {
            if (this.fleeVec == null) {
                this.fleeVec = this.seagull.getBlockInViewAway(this.target.position(), 4.0f);
            }
            if (this.fleeVec != null) {
                this.seagull.setFlying(true);
                this.seagull.getMoveControl().setWantedPosition(this.fleeVec.x, this.fleeVec.y, this.fleeVec.z, (double)1.2f);
                if (this.seagull.distanceToSqr(this.fleeVec) < 5.0) {
                    this.fleeVec = this.seagull.getBlockInViewAway(this.fleeVec, 4.0f);
                }
            }
            --this.fleeTime;
        }
    }

    private Player getClosestValidPlayer() {
        List list = this.seagull.level().getEntitiesOfClass(Player.class, this.seagull.getBoundingBox().inflate(10.0, 25.0, 10.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR);
        Player closest = null;
        if (!list.isEmpty()) {
            for (Player player : list) {
                if (closest != null && !(closest.distanceTo((Entity)this.seagull) > player.distanceTo((Entity)this.seagull)) || !this.hasFoods(player)) continue;
                closest = player;
            }
        }
        return closest;
    }

    private boolean hasFoods(Player player) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stackIn = (ItemStack)player.getInventory().items.get(i);
            if (!stackIn.has(DataComponents.FOOD) || this.isBlacklisted(stackIn)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlacklisted(ItemStack stack) {
        ResourceLocation loc = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (loc != null) {
            for (String string : AMConfig.seagullStealingBlacklist) {
                if (!loc.toString().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private ItemStack getFoodItemFrom(Player player) {
        ArrayList<ItemStack> foods = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            ItemStack stackIn = (ItemStack)player.getInventory().items.get(i);
            if (!stackIn.has(DataComponents.FOOD) || this.isBlacklisted(stackIn)) continue;
            foods.add(stackIn);
        }
        if (!foods.isEmpty()) {
            return (ItemStack)foods.get(foods.size() <= 1 ? 0 : this.seagull.getRandom().nextInt(foods.size() - 1));
        }
        return ItemStack.EMPTY;
    }
}

