/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntitySeagull;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class SeagullAIRevealTreasure
extends Goal {
    private final EntitySeagull seagull;
    private BlockPos sitPos;

    public SeagullAIRevealTreasure(EntitySeagull entitySeagull) {
        this.seagull = entitySeagull;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean canUse() {
        return this.seagull.getTreasurePos() != null && this.seagull.treasureSitTime > 0;
    }

    public void start() {
        this.seagull.aiItemFlag = true;
        this.sitPos = this.seagull.getSeagullGround(this.seagull.getTreasurePos());
    }

    public void stop() {
        this.sitPos = null;
        this.seagull.setSitting(false);
        this.seagull.aiItemFlag = false;
    }

    public void tick() {
        if (this.sitPos != null) {
            Vec3 vec3 = new Vec3((double)((float)this.sitPos.getX() + 0.5f), this.seagull.getY(), (double)((float)this.sitPos.getZ() + 0.5f));
            if (this.seagull.distanceToSqr(vec3) > 2.5) {
                this.seagull.getMoveControl().setWantedPosition((double)((float)this.sitPos.getX() + 0.5f), (double)(this.sitPos.getY() + 2), (double)((float)this.sitPos.getZ() + 0.5f), 1.0);
                if (!this.seagull.onGround()) {
                    this.seagull.setFlying(true);
                }
            } else {
                Vec3 vec = Vec3.upFromBottomCenterOf((Vec3i)this.sitPos, (double)1.0);
                if (vec.subtract(this.seagull.position()).length() > (double)0.04f) {
                    this.seagull.setDeltaMovement(vec.subtract(this.seagull.position()).scale((double)0.2f));
                }
                this.seagull.eatItem();
                this.seagull.treasureSitTime = Math.min(this.seagull.treasureSitTime, 100);
                this.seagull.setFlying(false);
                this.seagull.setSitting(true);
            }
        }
    }
}

