/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityMudBall;
import com.github.alexthe666.alexsmobs.entity.EntityMudskipper;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.EnumSet;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.gameevent.GameEvent;

public class MudskipperAIAttack
extends Goal {
    private final EntityMudskipper entity;
    private int shootCooldown = 0;
    private boolean strafed = false;

    public MudskipperAIAttack(EntityMudskipper mob) {
        this.entity = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.entity.getTarget() != null && this.entity.getTarget().isAlive();
    }

    public void stop() {
        this.shootCooldown = 0;
        this.strafed = false;
    }

    public void tick() {
        LivingEntity target = this.entity.getTarget();
        boolean keepFollowing = true;
        if (this.shootCooldown > 0) {
            --this.shootCooldown;
        }
        if (this.entity.getSensing().hasLineOfSight((Entity)target)) {
            float dist = this.entity.distanceTo((Entity)target);
            if (dist < this.entity.getBbWidth() + target.getBbWidth() + 3.0f) {
                keepFollowing = false;
                this.entity.lookAt((Entity)target, 360.0f, 360.0f);
                this.entity.getMoveControl().strafe(-3.0f, 0.0f);
                this.strafed = true;
            }
            if (dist < 8.0f && this.shootCooldown == 0) {
                EntityMudBall mudball = new EntityMudBall(this.entity.level(), this.entity);
                double d0 = target.getX() - mudball.getX();
                double d1 = target.getY((double)0.3f) - mudball.getY();
                double d2 = target.getZ() - mudball.getZ();
                float f = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2))) * 0.4f;
                mudball.shoot(d0, d1 + (double)f, d2, 1.0f, 10.0f);
                if (!this.entity.isSilent()) {
                    this.entity.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
                    this.entity.level().playSound(null, this.entity.getX(), this.entity.getY(), this.entity.getZ(), (SoundEvent)AMSoundRegistry.MUDSKIPPER_SPIT.get(), this.entity.getSoundSource(), 1.0f, 1.0f + (this.entity.getRandom().nextFloat() - this.entity.getRandom().nextFloat()) * 0.2f);
                }
                this.entity.level().addFreshEntity((Entity)mudball);
                this.shootCooldown = 10 + this.entity.getRandom().nextInt(10);
                this.entity.openMouth(10);
            }
        }
        if (keepFollowing) {
            if (this.strafed) {
                this.entity.getMoveControl().strafe(0.0f, 0.0f);
                this.strafed = false;
            }
            this.entity.getNavigation().moveTo((Entity)target, 1.5);
        } else {
            this.entity.getNavigation().stop();
        }
    }
}

