/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityMoose;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;

public class MooseAIJostle
extends Goal {
    private static final TargetingConditions JOSTLE_PREDICATE = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight();
    protected EntityMoose targetMoose;
    private EntityMoose moose;
    private Level world;
    private float angle;

    public MooseAIJostle(EntityMoose moose) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        this.moose = moose;
        this.world = moose.level();
    }

    public boolean canUse() {
        if (this.moose.isJostling() || !this.moose.isAntlered() || this.moose.isBaby() || this.moose.getTarget() != null || this.moose.jostleCooldown > 0) {
            return false;
        }
        if (this.moose.instantlyTriggerJostleAI || this.moose.getRandom().nextInt(30) == 0) {
            this.moose.instantlyTriggerJostleAI = false;
            if (this.moose.getJostlingPartner() instanceof EntityMoose) {
                this.targetMoose = (EntityMoose)this.moose.getJostlingPartner();
                return this.targetMoose.jostleCooldown == 0;
            }
            EntityMoose possiblePartner = this.getNearbyMoose();
            if (possiblePartner != null) {
                this.moose.setJostlingPartner((Entity)possiblePartner);
                possiblePartner.setJostlingPartner((Entity)this.moose);
                this.targetMoose = possiblePartner;
                this.targetMoose.instantlyTriggerJostleAI = true;
                return true;
            }
        }
        return false;
    }

    public void start() {
        this.moose.jostleTimer = 0;
        this.angle = 0.0f;
        this.setJostleDirection(this.moose.getRandom().nextBoolean());
    }

    public void setJostleDirection(boolean dir) {
        this.moose.jostleDirection = dir;
        this.targetMoose.jostleDirection = dir;
    }

    public void stop() {
        this.moose.setJostling(false);
        this.moose.setJostlingPartner(null);
        this.moose.jostleTimer = 0;
        this.angle = 0.0f;
        this.moose.getNavigation().stop();
        if (this.targetMoose != null) {
            this.targetMoose.setJostling(false);
            this.targetMoose.setJostlingPartner(null);
            this.targetMoose.jostleTimer = 0;
            this.targetMoose = null;
        }
    }

    public void tick() {
        if (this.targetMoose != null) {
            this.moose.lookAt((Entity)this.targetMoose, 360.0f, 180.0f);
            this.moose.setJostling(true);
            float f = (float)(this.moose.getX() - this.targetMoose.getX());
            float f1 = Math.abs((float)(this.moose.getY() - this.targetMoose.getY()));
            float f2 = (float)(this.moose.getZ() - this.targetMoose.getZ());
            double distXZ = Math.sqrt(f * f + f2 * f2);
            if (distXZ < 4.0) {
                this.moose.getNavigation().stop();
                this.moose.getMoveControl().strafe(-0.5f, 0.0f);
            } else if (distXZ > 4.5) {
                this.moose.setJostling(false);
                this.moose.getNavigation().moveTo((Entity)this.targetMoose, 1.0);
            } else {
                this.moose.lookAt((Entity)this.targetMoose, 360.0f, 180.0f);
                if (this.moose.jostleDirection) {
                    if (this.angle < 30.0f) {
                        this.angle += 1.0f;
                    }
                    this.moose.getMoveControl().strafe(0.0f, -0.2f);
                }
                if (!this.moose.jostleDirection) {
                    if (this.angle > -30.0f) {
                        this.angle -= 1.0f;
                    }
                    this.moose.getMoveControl().strafe(0.0f, 0.2f);
                }
                if (this.moose.getRandom().nextInt(55) == 0 && this.moose.onGround()) {
                    this.moose.pushBackJostling(this.targetMoose, 0.2f);
                }
                if (this.moose.getRandom().nextInt(25) == 0 && this.moose.onGround()) {
                    this.moose.playJostleSound();
                }
                this.moose.setJostleAngle(this.angle);
                if (this.moose.jostleTimer % 60 == 0 || this.moose.getRandom().nextInt(80) == 0) {
                    this.setJostleDirection(!this.moose.jostleDirection);
                }
                ++this.moose.jostleTimer;
                ++this.targetMoose.jostleTimer;
                if (this.moose.jostleTimer > 1000 || f1 > 2.0f) {
                    this.moose.hasImpulse = true;
                    if (this.moose.onGround()) {
                        this.moose.pushBackJostling(this.targetMoose, 0.9f);
                    }
                    if (this.targetMoose.onGround()) {
                        this.targetMoose.pushBackJostling(this.moose, 0.9f);
                    }
                    this.moose.jostleTimer = 0;
                    this.targetMoose.jostleTimer = 0;
                    this.moose.jostleCooldown = 500 + this.moose.getRandom().nextInt(2000);
                    this.targetMoose.jostleTimer = 0;
                    this.targetMoose.jostleCooldown = 500 + this.targetMoose.getRandom().nextInt(2000);
                    this.stop();
                }
            }
        }
    }

    public boolean canContinueToUse() {
        return !this.moose.isBaby() && this.moose.isAntlered() && this.moose.getTarget() == null && this.targetMoose != null && this.targetMoose.isAntlered() && this.targetMoose.isAlive() && this.moose.jostleCooldown == 0 && this.targetMoose.jostleCooldown == 0;
    }

    @Nullable
    private EntityMoose getNearbyMoose() {
        List listOfMeese = this.world.getNearbyEntities(EntityMoose.class, JOSTLE_PREDICATE, (LivingEntity)this.moose, this.moose.getBoundingBox().inflate(16.0));
        double lvt_2_1_ = Double.MAX_VALUE;
        EntityMoose lvt_4_1_ = null;
        for (EntityMoose lvt_6_1_ : listOfMeese) {
            if (!this.moose.canJostleWith(lvt_6_1_) || !(this.moose.distanceToSqr((Entity)lvt_6_1_) < lvt_2_1_)) continue;
            lvt_4_1_ = lvt_6_1_;
            lvt_2_1_ = this.moose.distanceToSqr((Entity)lvt_6_1_);
        }
        return lvt_4_1_;
    }
}

