/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;

public class LavaAndWaterAIRandomSwimming
extends RandomStrollGoal {
    public LavaAndWaterAIRandomSwimming(PathfinderMob creature, double speed, int chance) {
        super(creature, speed, chance, false);
    }

    public boolean canUse() {
        Vec3 vector3d;
        if (this.mob.isVehicle() || this.mob.getTarget() != null) {
            return false;
        }
        if (!this.forceTrigger) {
            int i;
            int n = i = this.mob.isInLava() || this.mob.isInWater() ? this.interval : this.interval * 2;
            if (this.mob.getRandom().nextInt(i) != 0) {
                return false;
            }
        }
        if ((vector3d = this.getPosition()) == null) {
            return false;
        }
        this.wantedX = vector3d.x;
        this.wantedY = vector3d.y;
        this.wantedZ = vector3d.z;
        this.forceTrigger = false;
        return true;
    }

    @Nullable
    protected Vec3 getPosition() {
        Vec3 vector3d;
        float f = this.mob.getRandom().nextFloat();
        float f2 = this.mob.isInLava() ? 0.7f : 0.3f;
        if (f < f2 && (vector3d = this.findSurfaceTarget(this.mob, 32, 16)) != null) {
            return vector3d;
        }
        vector3d = DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)32, (int)16);
        int i = 0;
        while (vector3d != null && !this.mob.level().getBlockState(AMBlockPos.fromVec3(vector3d)).isPathfindable(PathComputationType.WATER) && i++ < 10) {
            vector3d = DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7);
        }
        return vector3d;
    }

    private boolean canJumpTo(BlockPos pos, int dx, int dz, int scale) {
        BlockPos blockpos = pos.offset(dx * scale, 0, dz * scale);
        return this.mob.level().getFluidState(blockpos).is(FluidTags.WATER) && !this.mob.level().getBlockState(blockpos).blocksMotion() || this.mob.level().getFluidState(blockpos).is(FluidTags.LAVA);
    }

    private boolean isAirAbove(BlockPos pos, int dx, int dz, int scale) {
        return this.mob.level().getBlockState(pos.offset(dx * scale, 1, dz * scale)).isAir() && this.mob.level().getBlockState(pos.offset(dx * scale, 2, dz * scale)).isAir();
    }

    protected Vec3 findSurfaceTarget(PathfinderMob creature, int i, int i1) {
        Vec3 creaturePos = creature.position();
        BlockPos upPos = creature.blockPosition();
        while (creature.level().getFluidState(upPos).is(FluidTags.LAVA) || creature.level().getFluidState(upPos).is(FluidTags.WATER)) {
            upPos = upPos.above();
        }
        if (this.isAirAbove(upPos.below(), 0, 0, 0) && this.canJumpTo(upPos.below(), 0, 0, 0)) {
            return new Vec3((double)((float)upPos.getX() + 0.5f), (double)((float)upPos.getY() - 0.5f), (double)((float)upPos.getZ() + 0.5f));
        }
        return null;
    }
}

