/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.entity.EntityGorilla;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class GorillaAIFollowCaravan
extends Goal {
    public final EntityGorilla gorilla;
    private double speedModifier;
    private int distCheckCounter;

    public GorillaAIFollowCaravan(EntityGorilla llamaIn, double speedModifierIn) {
        this.gorilla = llamaIn;
        this.speedModifier = speedModifierIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!(this.gorilla.isSilverback() || this.gorilla.inCaravan() || this.gorilla.isSitting())) {
            double dist = 15.0;
            List list = this.gorilla.level().getEntitiesOfClass(EntityGorilla.class, this.gorilla.getBoundingBox().inflate(dist, dist / 2.0, dist));
            EntityGorilla gorilla = null;
            double d0 = Double.MAX_VALUE;
            for (Entity entity : list) {
                double d1;
                EntityGorilla gorilla1 = (EntityGorilla)entity;
                if (!gorilla1.inCaravan() || gorilla1.hasCaravanTrail() || (d1 = this.gorilla.distanceToSqr((Entity)gorilla1)) > d0) continue;
                d0 = d1;
                gorilla = gorilla1;
            }
            if (gorilla == null) {
                for (Entity entity1 : list) {
                    double d2;
                    EntityGorilla llamaentity2 = (EntityGorilla)entity1;
                    if (!llamaentity2.isSilverback() || llamaentity2.hasCaravanTrail() || (d2 = this.gorilla.distanceToSqr((Entity)llamaentity2)) > d0) continue;
                    d0 = d2;
                    gorilla = llamaentity2;
                }
            }
            if (gorilla == null) {
                return false;
            }
            if (d0 < 2.0) {
                return false;
            }
            if (!gorilla.isSilverback() && !this.firstIsSilverback(gorilla, 1)) {
                return false;
            }
            this.gorilla.joinCaravan(gorilla);
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.gorilla.isSitting()) {
            return false;
        }
        if (this.gorilla.inCaravan() && this.gorilla.getCaravanHead().isAlive() && this.firstIsSilverback(this.gorilla, 0)) {
            double d0 = this.gorilla.distanceToSqr((Entity)this.gorilla.getCaravanHead());
            if (d0 > 676.0) {
                if (this.speedModifier <= 1.5) {
                    this.speedModifier *= 1.2;
                    this.distCheckCounter = 40;
                    return true;
                }
                if (this.distCheckCounter == 0) {
                    return false;
                }
            }
            if (this.distCheckCounter > 0) {
                --this.distCheckCounter;
            }
            return true;
        }
        return false;
    }

    public void stop() {
        this.gorilla.leaveCaravan();
        this.speedModifier = 1.5;
    }

    public void tick() {
        EntityGorilla llamaentity;
        if (this.gorilla.inCaravan() && !this.gorilla.isSitting() && (llamaentity = this.gorilla.getCaravanHead()) != null) {
            double d0 = this.gorilla.distanceTo((Entity)llamaentity);
            Vec3 vector3d = new Vec3(llamaentity.getX() - this.gorilla.getX(), llamaentity.getY() - this.gorilla.getY(), llamaentity.getZ() - this.gorilla.getZ()).normalize().scale(Math.max(d0 - 2.0, 0.0));
            if (this.gorilla.getNavigation().isDone()) {
                try {
                    this.gorilla.getNavigation().moveTo(this.gorilla.getX() + vector3d.x, this.gorilla.getY() + vector3d.y, this.gorilla.getZ() + vector3d.z, this.speedModifier);
                }
                catch (NullPointerException e) {
                    AlexsMobs.LOGGER.warn("gorilla encountered issue following caravan head");
                }
            }
        }
    }

    private boolean firstIsSilverback(EntityGorilla llama, int p_190858_2_) {
        if (p_190858_2_ > 8) {
            return false;
        }
        if (llama.inCaravan()) {
            if (llama.getCaravanHead().isSilverback()) {
                return true;
            }
            EntityGorilla llamaentity = llama.getCaravanHead();
            return this.firstIsSilverback(llamaentity, ++p_190858_2_);
        }
        return false;
    }
}

