/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.IFollower;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;

public class FlyingAIFollowOwner
extends Goal {
    private final TamableAnimal tameable;
    private LivingEntity owner;
    private final LevelReader world;
    private final double followSpeed;
    private final PathNavigation navigator;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private float oldWaterCost;
    private final boolean teleportToLeaves;
    private final IFollower follower;

    public FlyingAIFollowOwner(TamableAnimal tameable, double speed, float minDist, float maxDist, boolean teleportToLeaves) {
        this.tameable = tameable;
        this.world = tameable.level();
        this.followSpeed = speed;
        this.navigator = tameable.getNavigation();
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.teleportToLeaves = teleportToLeaves;
        this.follower = (IFollower)tameable;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity livingentity = this.tameable.getOwner();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.isSpectator()) {
            return false;
        }
        if (this.tameable.isOrderedToSit()) {
            return false;
        }
        if (this.tameable.distanceToSqr((Entity)livingentity) < (double)(this.minDist * this.minDist) || this.isInCombat()) {
            return false;
        }
        this.owner = livingentity;
        return this.follower.shouldFollow();
    }

    public boolean canContinueToUse() {
        if (this.tameable.isOrderedToSit() || this.isInCombat()) {
            return false;
        }
        return this.tameable.distanceToSqr((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
    }

    private boolean isInCombat() {
        LivingEntity owner = this.tameable.getOwner();
        if (owner != null) {
            return this.tameable.distanceTo((Entity)owner) < 30.0f && this.tameable.getTarget() != null && this.tameable.getTarget().isAlive();
        }
        return false;
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tameable.getPathfindingMalus(PathType.WATER);
        this.tameable.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.navigator.stop();
        this.tameable.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        this.tameable.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.tameable.getMaxHeadXRot());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.tameable.isLeashed() && !this.tameable.isPassenger()) {
                if (this.tameable.distanceToSqr((Entity)this.owner) >= 144.0) {
                    this.tryToTeleportNearEntity();
                }
                this.follower.followEntity(this.tameable, this.owner, this.followSpeed);
            }
        }
    }

    private void tryToTeleportNearEntity() {
        BlockPos blockpos = this.owner.blockPosition();
        for (int i = 0; i < 10; ++i) {
            int j = this.getRandomNumber(-3, 3);
            int k = this.getRandomNumber(-1, 1);
            int l = this.getRandomNumber(-3, 3);
            boolean flag = this.tryToTeleportToLocation(blockpos.getX() + j, blockpos.getY() + k, blockpos.getZ() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean tryToTeleportToLocation(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.getX()) < 2.0 && Math.abs((double)z - this.owner.getZ()) < 2.0) {
            return false;
        }
        if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
            return false;
        }
        this.tameable.moveTo((double)x + 0.5, (double)y, (double)z + 0.5, this.tameable.getYRot(), this.tameable.getXRot());
        this.navigator.stop();
        return true;
    }

    private boolean isTeleportFriendlyBlock(BlockPos pos) {
        if (this.world.getBlockState(pos).isAir()) {
            BlockPos blockpos = pos.subtract((Vec3i)this.tameable.blockPosition());
            return this.world.noCollision((Entity)this.tameable, this.tameable.getBoundingBox().move(blockpos));
        }
        PathType pathnodetype = PathType.WALKABLE;
        if (pathnodetype != PathType.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.world.getBlockState(pos.below());
        if (!this.teleportToLeaves && blockstate.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.subtract((Vec3i)this.tameable.blockPosition());
        return this.world.noCollision((Entity)this.tameable, this.tameable.getBoundingBox().move(blockpos));
    }

    private int getRandomNumber(int min, int max) {
        return this.tameable.getRandom().nextInt(max - min + 1) + min;
    }
}

