/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityCrocodile;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class CrocodileAIMelee
extends MeleeAttackGoal {
    private final EntityCrocodile crocodile;

    public CrocodileAIMelee(EntityCrocodile crocodile, double speedIn, boolean useLongMemory) {
        super((PathfinderMob)crocodile, speedIn, useLongMemory);
        this.crocodile = crocodile;
    }

    public boolean canUse() {
        return super.canUse() && this.crocodile.getPassengers().isEmpty();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.crocodile.getPassengers().isEmpty();
    }

    protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
        double d0 = this.mob.getBbWidth() * 2.0f * this.mob.getBbWidth() * 2.0f + enemy.getBbWidth();
        if (distToEnemySqr <= d0) {
            this.resetAttackCooldown();
            this.mob.swing(InteractionHand.MAIN_HAND);
            this.mob.doHurtTarget((Entity)enemy);
        }
    }
}

