/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityBlueJay;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class BlueJayAIMelee
extends Goal {
    private final EntityBlueJay blueJay;
    float circlingTime = 0.0f;
    float circleDistance = 1.0f;
    float yLevel = 2.0f;
    boolean clockwise = false;
    private int maxCircleTime;

    public BlueJayAIMelee(EntityBlueJay blueJay) {
        this.blueJay = blueJay;
    }

    public boolean canUse() {
        LivingEntity entity = this.blueJay.getTarget();
        return entity != null && entity.isAlive();
    }

    public void start() {
        this.clockwise = this.blueJay.getRandom().nextBoolean();
        this.yLevel = this.blueJay.getRandom().nextInt(2);
        this.circlingTime = 0.0f;
        this.maxCircleTime = 20 + this.blueJay.getRandom().nextInt(20);
        this.circleDistance = 0.5f + this.blueJay.getRandom().nextFloat() * 2.0f;
    }

    public void stop() {
        this.clockwise = this.blueJay.getRandom().nextBoolean();
        this.yLevel = this.blueJay.getRandom().nextInt(2);
        this.circlingTime = 0.0f;
        this.maxCircleTime = 20 + this.blueJay.getRandom().nextInt(20);
        this.circleDistance = 0.5f + this.blueJay.getRandom().nextFloat() * 2.0f;
        if (this.blueJay.onGround()) {
            this.blueJay.setFlying(false);
        }
    }

    public void tick() {
        LivingEntity target;
        if (this.blueJay.isFlying()) {
            this.circlingTime += 1.0f;
        }
        if ((target = this.blueJay.getTarget()) != null) {
            if (this.blueJay.distanceTo((Entity)target) < 3.0f) {
                this.blueJay.peck();
                target.hurt(target.damageSources().generic(), 1.0f);
                this.stop();
            }
            if (this.circlingTime > (float)this.maxCircleTime) {
                this.blueJay.getMoveControl().setWantedPosition(target.getX(), target.getY() + (double)(target.getEyeHeight() / 2.0f), target.getZ(), (double)1.6f);
            } else {
                Vec3 circlePos = this.getVultureCirclePos(target.position());
                if (circlePos == null) {
                    circlePos = target.position();
                }
                this.blueJay.setFlying(true);
                this.blueJay.getMoveControl().setWantedPosition(circlePos.x(), circlePos.y() + (double)target.getEyeHeight() + (double)0.2f, circlePos.z(), (double)1.6f);
            }
        }
    }

    public Vec3 getVultureCirclePos(Vec3 target) {
        float angle = 0.2268928f * (this.clockwise ? -this.circlingTime : this.circlingTime);
        double extraX = this.circleDistance * Mth.sin((float)angle);
        double extraZ = this.circleDistance * Mth.cos((float)angle);
        Vec3 pos = new Vec3(target.x() + extraX, target.y() + (double)this.yLevel, target.z() + extraZ);
        if (this.blueJay.level().isEmptyBlock(AMBlockPos.fromVec3(pos))) {
            return pos;
        }
        return null;
    }
}

