/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.block.BlockLeafcutterAntChamber;
import com.github.alexthe666.alexsmobs.block.BlockLeafcutterAnthill;
import com.github.alexthe666.alexsmobs.entity.EntityAnteater;
import com.github.alexthe666.alexsmobs.entity.EntityLeafcutterAnt;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityLeafcutterAnthill;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class AnteaterAIRaidNest
extends MoveToBlockGoal {
    public static final ResourceLocation ANTEATER_REWARD = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"gameplay/anteater_reward");
    private final EntityAnteater anteater;
    private int idleAtHiveTime = 0;
    private boolean isAboveDestinationAnteater;
    private boolean shootTongue;
    private int maxEatingTime = 0;

    public AnteaterAIRaidNest(EntityAnteater anteater) {
        super((PathfinderMob)anteater, 1.0, 32, 8);
        this.anteater = anteater;
    }

    private static List<ItemStack> getItemStacks(EntityAnteater anteater) {
        LootTable loottable = anteater.level().getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ANTEATER_REWARD));
        return loottable.getRandomItems(new LootParams.Builder((ServerLevel)anteater.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)anteater).create(LootContextParamSets.PIGLIN_BARTER));
    }

    private void dropDigItems() {
        List<ItemStack> lootList = AnteaterAIRaidNest.getItemStacks(this.anteater);
        if (lootList.size() > 0) {
            for (ItemStack stack : lootList) {
                ItemEntity e = this.anteater.spawnAtLocation(stack.copy());
                e.hasImpulse = true;
                e.setDeltaMovement(e.getDeltaMovement().multiply(0.2, 0.2, 0.2));
            }
        }
    }

    public boolean canUse() {
        return !this.anteater.isBaby() && super.canUse() && this.anteater.eatAntCooldown <= 0;
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.anteater.eatAntCooldown <= 0;
    }

    public void start() {
        super.start();
        this.maxEatingTime = 150 + this.anteater.getRandom().nextInt(200);
    }

    public void stop() {
        super.stop();
        this.idleAtHiveTime = 0;
        this.maxEatingTime = 150 + this.anteater.getRandom().nextInt(200);
        this.anteater.setLeaning(false);
        this.anteater.resetAntCooldown();
    }

    public double acceptedDistance() {
        return 1.2;
    }

    public void tick() {
        super.tick();
        BlockPos blockpos = this.getMoveToTarget();
        if (!this.isWithinXZDist(blockpos, this.mob.position(), this.acceptedDistance())) {
            this.isAboveDestinationAnteater = false;
            ++this.tryTicks;
            if (this.shouldRecalculatePath()) {
                this.mob.getNavigation().moveTo((double)blockpos.getX() + 0.5, (double)blockpos.getY(), (double)blockpos.getZ() + 0.5, this.speedModifier);
            }
        } else {
            this.isAboveDestinationAnteater = true;
            --this.tryTicks;
        }
        if (this.isReachedTarget()) {
            this.anteater.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3((double)this.blockPos.getX() + 0.5, (double)(this.blockPos.getY() - 1), (double)this.blockPos.getZ() + 0.5));
            if (this.idleAtHiveTime >= 20 && this.idleAtHiveTime % 20 == 0) {
                boolean bl = this.shootTongue = this.anteater.getRandom().nextInt(2) == 0;
                if (this.shootTongue) {
                    this.eatHive();
                } else {
                    this.breakHiveEffect();
                }
            }
            ++this.idleAtHiveTime;
            if (this.shootTongue && this.anteater.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                this.anteater.setLeaning(false);
                this.anteater.setAnimation(EntityAnteater.ANIMATION_TOUNGE_IDLE);
            } else if (this.anteater.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                this.anteater.setLeaning(true);
                this.anteater.setAnimation(this.anteater.getRandom().nextBoolean() ? EntityAnteater.ANIMATION_SLASH_L : EntityAnteater.ANIMATION_SLASH_R);
            }
            if (this.idleAtHiveTime > this.maxEatingTime) {
                this.stop();
            }
        }
    }

    private boolean isWithinXZDist(BlockPos blockpos, Vec3 positionVec, double distance) {
        return blockpos.distSqr((Vec3i)AMBlockPos.fromCoords(positionVec.x(), blockpos.getY(), positionVec.z())) < distance * distance;
    }

    protected boolean isReachedTarget() {
        return this.isAboveDestinationAnteater;
    }

    private void breakHiveEffect() {
        if (EventHooks.canEntityGrief((Level)this.anteater.level(), (Entity)this.anteater)) {
            BlockState blockstate = this.anteater.level().getBlockState(this.blockPos);
            if (blockstate.is((Block)AMBlockRegistry.LEAFCUTTER_ANTHILL.get())) {
                if (this.anteater.level().getBlockEntity(this.blockPos) instanceof TileEntityLeafcutterAnthill) {
                    TileEntityLeafcutterAnthill anthill = (TileEntityLeafcutterAnthill)this.anteater.level().getBlockEntity(this.blockPos);
                    anthill.angerAntsBecauseAnteater((LivingEntity)this.anteater, blockstate, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                    this.anteater.level().destroyBlock(this.blockPos, false);
                    if (blockstate.getBlock() instanceof BlockLeafcutterAnthill) {
                        this.anteater.level().setBlockAndUpdate(this.blockPos, blockstate);
                    }
                    this.dropDigItems();
                }
            } else if (blockstate.is((Block)AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER.get())) {
                this.anteater.level().destroyBlock(this.blockPos, false);
                this.anteater.level().setBlockAndUpdate(this.blockPos, blockstate);
            }
        }
    }

    private void eatHive() {
        if (EventHooks.canEntityGrief((Level)this.anteater.level(), (Entity)this.anteater)) {
            BlockState blockstate = this.anteater.level().getBlockState(this.blockPos);
            if (blockstate.is((Block)AMBlockRegistry.LEAFCUTTER_ANTHILL.get())) {
                if (this.anteater.level().getBlockEntity(this.blockPos) instanceof TileEntityLeafcutterAnthill) {
                    rand = this.anteater.getRandom();
                    TileEntityLeafcutterAnthill anthill = (TileEntityLeafcutterAnthill)this.anteater.level().getBlockEntity(this.blockPos);
                    anthill.angerAntsBecauseAnteater((LivingEntity)this.anteater, blockstate, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                    this.anteater.level().updateNeighbourForOutputSignal(this.blockPos, blockstate.getBlock());
                    if (!anthill.hasNoAnts()) {
                        BlockState state = anthill.shrinkFungus();
                        if (state != null && state.is((Block)AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER.get()) && (Integer)state.getValue((Property)BlockLeafcutterAntChamber.FUNGUS) >= 5) {
                            ItemStack stack = new ItemStack((ItemLike)AMItemRegistry.GONGYLIDIA.get());
                            ItemEntity itementity = new ItemEntity(this.anteater.level(), (double)((float)this.blockPos.getX() + rand.nextFloat()), (double)((float)this.blockPos.getY() + rand.nextFloat()), (double)((float)this.blockPos.getZ() + rand.nextFloat()), stack);
                            itementity.setDefaultPickUpDelay();
                            this.anteater.level().addFreshEntity((Entity)itementity);
                        }
                        this.anteater.setAntOnTongue(true);
                    }
                }
            } else if (blockstate.is((Block)AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER.get())) {
                this.anteater.level().destroyBlock(this.blockPos, false);
                if ((Integer)blockstate.getValue((Property)BlockLeafcutterAntChamber.FUNGUS) >= 5) {
                    rand = this.anteater.getRandom();
                    ItemStack stack = new ItemStack((ItemLike)AMItemRegistry.GONGYLIDIA.get());
                    ItemEntity itementity = new ItemEntity(this.anteater.level(), (double)((float)this.blockPos.getX() + rand.nextFloat()), (double)((float)this.blockPos.getY() + rand.nextFloat()), (double)((float)this.blockPos.getZ() + rand.nextFloat()), stack);
                    itementity.setDefaultPickUpDelay();
                    this.anteater.level().addFreshEntity((Entity)itementity);
                }
                this.anteater.level().setBlockAndUpdate(this.blockPos, Blocks.COARSE_DIRT.defaultBlockState());
                this.anteater.setAntOnTongue(true);
            }
            double d0 = 15.0;
            for (EntityLeafcutterAnt leafcutter : this.anteater.level().getEntitiesOfClass(EntityLeafcutterAnt.class, new AABB((double)this.blockPos.getX() - d0, (double)this.blockPos.getY() - d0, (double)this.blockPos.getZ() - d0, (double)this.blockPos.getX() + d0, (double)this.blockPos.getY() + d0, (double)this.blockPos.getZ() + d0))) {
                leafcutter.setRemainingPersistentAngerTime(100);
                leafcutter.setTarget((LivingEntity)this.anteater);
                leafcutter.setStayOutOfHiveCountdown(400);
            }
        }
    }

    protected boolean isValidTarget(LevelReader worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos).is((Block)AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER.get()) || worldIn.getBlockState(pos).is((Block)AMBlockRegistry.LEAFCUTTER_ANTHILL.get()) && worldIn.getBlockEntity(pos) instanceof TileEntityLeafcutterAnthill && this.isValidAnthill(pos, (TileEntityLeafcutterAnthill)worldIn.getBlockEntity(pos));
    }

    private boolean isValidAnthill(BlockPos pos, TileEntityLeafcutterAnthill blockEntity) {
        return blockEntity.hasAtleastThisManyAnts(2);
    }
}

