/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class AnimalAIMeleeNearby
extends Goal {
    private final Mob entity;
    private final int range;
    private final double speed;
    private BlockPos fightStartPos = null;

    public AnimalAIMeleeNearby(Mob entity, int range, double speed) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.entity = entity;
        this.range = range;
        this.speed = speed;
    }

    public boolean canUse() {
        return this.entity.getTarget() != null && this.entity.getTarget().isAlive() && !this.entity.isVehicle();
    }

    public void start() {
        this.fightStartPos = this.entity.getOnPos();
    }

    public void stop() {
        this.entity.getNavigation().stop();
        this.fightStartPos = null;
    }

    public void tick() {
        if (this.entity.distanceTo((Entity)this.entity.getTarget()) < 3.0f + this.entity.getBbWidth() + this.entity.getTarget().getBbWidth()) {
            this.entity.doHurtTarget((Entity)this.entity.getTarget());
            this.entity.lookAt((Entity)this.entity.getTarget(), 180.0f, 180.0f);
        } else if (this.fightStartPos != null) {
            if (this.entity.distanceToSqr(Vec3.atCenterOf((Vec3i)this.fightStartPos)) < (double)(this.range * this.range)) {
                this.entity.getNavigation().moveTo((Entity)this.entity.getTarget(), this.speed);
            } else {
                this.entity.getNavigation().moveTo((double)((float)this.fightStartPos.getX() + 0.5f), (double)((float)this.fightStartPos.getY() + 0.5f), (double)((float)this.fightStartPos.getZ() + 0.5f), (double)0.4f + this.speed);
            }
        }
    }
}

