/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.block.BlockEnderResidue;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityVoidPortal;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWormPart;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWormShot;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTrigger;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;

public class EntityVoidWorm
extends Monster {
    public static final ResourceKey<LootTable> SPLITTER_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"entities/void_worm_splitter"));
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.defineId(EntityVoidWorm.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Optional<UUID>> SPLIT_FROM_UUID = SynchedEntityData.defineId(EntityVoidWorm.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> SEGMENT_COUNT = SynchedEntityData.defineId(EntityVoidWorm.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> JAW_TICKS = SynchedEntityData.defineId(EntityVoidWorm.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> WORM_ANGLE = SynchedEntityData.defineId(EntityVoidWorm.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> SPEEDMOD = SynchedEntityData.defineId(EntityVoidWorm.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> SPLITTER = SynchedEntityData.defineId(EntityVoidWorm.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> PORTAL_TICKS = SynchedEntityData.defineId(EntityVoidWorm.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    public float prevWormAngle;
    public float prevJawProgress;
    public float jawProgress;
    public Vec3 teleportPos = null;
    public EntityVoidPortal portalTarget = null;
    public boolean fullyThrough = true;
    public boolean updatePostSummon = false;
    private int makePortalCooldown = 0;
    private int stillTicks = 0;
    private int blockBreakCounter;
    private int makeIdlePortalCooldown = 200 + this.random.nextInt(800);

    protected EntityVoidWorm(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 10;
        this.moveControl = new FlightMoveController((Mob)this, 1.0f, false, true);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.VOID_WORM_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.VOID_WORM_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.VOID_WORM_HURT.get();
    }

    protected float getSoundVolume() {
        return this.isSilent() ? 0.0f : 5.0f;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.voidWormSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static boolean canVoidWormSpawn(EntityType animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return true;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, AMConfig.voidWormMaxHealth).add(Attributes.ARMOR, 4.0).add(Attributes.FOLLOW_RANGE, 256.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 5.0);
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return this.isSplitter() ? SPLITTER_LOOT : super.getDefaultLootTable();
    }

    public void kill() {
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void die(DamageSource cause) {
        super.die(cause);
        if (!this.level().isClientSide && !this.isSplitter() && cause != null && cause.getEntity() instanceof ServerPlayer) {
            ((AMAdvancementTrigger)((Object)AMAdvancementTriggerRegistry.VOID_WORM_SLAY_HEAD.get())).trigger((ServerPlayer)cause.getEntity());
        }
    }

    public ItemEntity spawnAtLocation(ItemStack stack) {
        ItemEntity itementity = this.spawnAtLocation(stack, 0.0f);
        if (itementity != null) {
            itementity.setNoGravity(true);
            itementity.setGlowingTag(true);
            itementity.setExtendedLifetime();
        }
        return itementity;
    }

    protected void dropAllDeathLootCustom(DamageSource source) {
    }

    private void placeDropsSafely(Collection<ItemEntity> drops) {
        BlockPos pos = this.blockPosition();
        while (!this.level().getBlockState(pos).canBeReplaced() && pos.getY() < this.level().getMaxBuildHeight() - 2) {
            pos = pos.above();
        }
        int radius = 2;
        BlockState residue = (BlockState)((Block)AMBlockRegistry.ENDER_RESIDUE.get()).defaultBlockState().setValue((Property)BlockEnderResidue.SLOW_DECAY, (Comparable)Boolean.valueOf(true));
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double sq = x * x + y * y + z * z;
                    BlockPos pos1 = pos.offset(x, y, z);
                    BlockState state = this.level().getBlockState(pos1);
                    if (!(sq <= (double)(radius * radius)) || !(sq >= (double)((float)(radius * radius) - 2.0f)) || !state.canBeReplaced() && !state.is((Block)AMBlockRegistry.ENDER_RESIDUE.get())) continue;
                    this.level().setBlockAndUpdate(pos1, residue);
                }
            }
        }
        this.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        for (ItemEntity drop : drops) {
            drop.setPos(Vec3.atBottomCenterOf((Vec3i)pos));
            drop.setGlowingTag(true);
            drop.setNoGravity(true);
            drop.setDefaultPickUpDelay();
            drop.setUnlimitedLifetime();
            drop.setDeltaMovement(Vec3.ZERO);
            this.level().addFreshEntity((Entity)drop);
        }
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypes.FALL) || source.is(DamageTypes.DROWN) || source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.LAVA) || source.is(DamageTypes.FELL_OUT_OF_WORLD) || source.is(DamageTypeTags.IS_FIRE) || super.isInvulnerableTo(source);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AIEnterPortal());
        this.goalSelector.addGoal(2, (Goal)new AIAttack());
        this.goalSelector.addGoal(3, (Goal)new AIFlyIdle(this));
        this.targetSelector.addGoal(1, new EntityAINearestTarget3D<Player>((Mob)this, Player.class, 10, false, true, null));
        this.targetSelector.addGoal(2, new EntityAINearestTarget3D<EnderDragon>((Mob)this, EnderDragon.class, 10, false, true, null));
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new DirectPathNavigator((Mob)this, this.level());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("ChildUUID")) {
            this.setChildId(compound.getUUID("ChildUUID"));
        }
        this.setWormSpeed(compound.getFloat("WormSpeed"));
        this.setSplitter(compound.getBoolean("Splitter"));
        this.setPortalTicks(compound.getInt("PortalTicks"));
        this.makeIdlePortalCooldown = compound.getInt("MakePortalTime");
        this.makePortalCooldown = compound.getInt("MakePortalCooldown");
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getDisplayName());
        }
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossInfo.setName(this.getDisplayName());
    }

    public boolean isNoGravity() {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getChildId() != null) {
            compound.putUUID("ChildUUID", this.getChildId());
        }
        compound.putInt("PortalTicks", this.getPortalTicks());
        compound.putInt("MakePortalTime", this.makeIdlePortalCooldown);
        compound.putInt("MakePortalCooldown", this.makePortalCooldown);
        compound.putFloat("WormSpeed", this.getWormSpeed());
        compound.putBoolean("Splitter", this.isSplitter());
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.level().isClientSide) {
            return ((ServerLevel)this.level()).getEntity(id);
        }
        return null;
    }

    public boolean canBeLeashed(Player player) {
        return true;
    }

    public int getExperienceReward() {
        return this.isSplitter() ? 8 : 50;
    }

    public void tick() {
        Entity child;
        super.tick();
        this.prevWormAngle = this.getWormAngle();
        this.prevJawProgress = this.jawProgress;
        float threshold = 0.05f;
        this.xpReward = this.isSplitter() ? 10 : 70;
        if (this.yRotO - this.getYRot() > threshold) {
            this.setWormAngle(this.getWormAngle() + 15.0f);
        } else if (this.yRotO - this.getYRot() < -threshold) {
            this.setWormAngle(this.getWormAngle() - 15.0f);
        } else if (this.getWormAngle() > 0.0f) {
            this.setWormAngle(Math.max(this.getWormAngle() - 20.0f, 0.0f));
        } else if (this.getWormAngle() < 0.0f) {
            this.setWormAngle(Math.min(this.getWormAngle() + 20.0f, 0.0f));
        }
        if (!this.level().isClientSide) {
            if (!this.fullyThrough) {
                this.setDeltaMovement(this.getDeltaMovement().multiply((double)0.9f, (double)0.9f, (double)0.9f).add(0.0, -0.01, 0.0));
            } else {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.01, 0.0));
            }
        }
        this.stillTicks = Math.abs(this.xo - this.getX()) < (double)0.01f && Math.abs(this.yo - this.getY()) < (double)0.01f && Math.abs(this.zo - this.getZ()) < (double)0.01f ? ++this.stillTicks : 0;
        if (this.stillTicks > 40 && this.makePortalCooldown == 0) {
            this.createStuckPortal();
        }
        if (this.makePortalCooldown > 0) {
            --this.makePortalCooldown;
        }
        if (this.makeIdlePortalCooldown > 0) {
            --this.makeIdlePortalCooldown;
        }
        if (this.makeIdlePortalCooldown == 0 && this.random.nextInt(100) == 0) {
            this.createPortalRandomDestination();
            this.makeIdlePortalCooldown = 200 + this.random.nextInt(1000);
        }
        if ((Integer)this.entityData.get(JAW_TICKS) > 0) {
            if (this.jawProgress < 5.0f) {
                this.jawProgress += 1.0f;
            }
            this.entityData.set(JAW_TICKS, (Object)((Integer)this.entityData.get(JAW_TICKS) - 1));
        } else if (this.jawProgress > 0.0f) {
            this.jawProgress -= 1.0f;
        }
        if (this.isAlive()) {
            for (Entity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(2.0))) {
                if (entity.is((Entity)this) || entity instanceof EntityVoidWormPart || entity.isAlliedTo((Entity)this) || entity == this) continue;
                this.launch(entity, false);
            }
        } else {
            this.setDeltaMovement(new Vec3(0.0, (double)0.03f, 0.0));
        }
        this.yBodyRot = this.getYRot();
        float f2 = (float)(-((double)((float)this.getDeltaMovement().y) * 57.2957763671875));
        this.setXRot(f2);
        if (!this.level().isClientSide && (child = this.getChild()) == null) {
            Object partParent = this;
            int tailstart = Math.min(3 + this.random.nextInt(2), this.getSegmentCount());
            int segments = this.getSegmentCount();
            for (int i = 0; i < segments; ++i) {
                float scale = 1.0f + (float)i / (float)segments * 0.5f;
                boolean tail = false;
                if (i >= segments - tailstart) {
                    tail = true;
                    scale *= 0.85f;
                }
                EntityVoidWormPart part = new EntityVoidWormPart((EntityType)AMEntityRegistry.VOID_WORM_PART.get(), (LivingEntity)partParent, 1.0f + scale * (tail ? 0.65f : 0.3f) + (i == 0 ? 0.8f : 0.0f), 180.0f, i == 0 ? -0.0f : (i == segments - tailstart ? -0.3f : 0.0f));
                part.setInvulnerable(partParent.isInvulnerable());
                part.setParent((Entity)partParent);
                if (this.updatePostSummon) {
                    part.setPortalTicks(i * 2);
                }
                part.setBodyIndex(i);
                part.setTail(tail);
                part.setWormScale(scale);
                if (partParent == this) {
                    this.setChildId(part.getUUID());
                } else if (partParent instanceof EntityVoidWormPart) {
                    ((EntityVoidWormPart)partParent).setChildId(part.getUUID());
                }
                part.setInitialPartPos((Entity)this);
                partParent = part;
                this.level().addFreshEntity((Entity)part);
            }
        }
        if (this.getPortalTicks() > 0) {
            this.setPortalTicks(this.getPortalTicks() - 1);
            if (this.getPortalTicks() == 2 && this.teleportPos != null) {
                this.setPos(this.teleportPos.x, this.teleportPos.y, this.teleportPos.z);
                this.teleportPos = null;
            }
        }
        if (this.portalTarget != null && this.portalTarget.getLifespan() < 5) {
            this.portalTarget = null;
        }
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        this.breakBlock();
        if (this.updatePostSummon) {
            this.updatePostSummon = false;
        }
        if (!this.isSilent() && !this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)67);
        }
    }

    public double getBaseMaxHealth() {
        return this.getAttributeBaseValue(Attributes.MAX_HEALTH);
    }

    public void setBaseMaxHealth(double maxHealth, boolean heal) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(maxHealth);
        if (heal) {
            this.heal(this.getMaxHealth());
        }
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == (this.isSplitter() ? 20 : 80) && !this.level().isClientSide()) {
            boolean flag;
            DamageSource source = this.getLastDamageSource() == null ? this.damageSources().generic() : this.getLastDamageSource();
            Entity entity = source.getEntity();
            boolean i = false;
            this.captureDrops(new ArrayList());
            boolean bl = flag = this.lastHurtByPlayerTime > 0;
            if (this.shouldDropLoot() && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                this.dropFromLootTable(source, flag);
            }
            this.dropEquipment();
            this.dropExperience(null);
            Collection drops = this.captureDrops(null);
            if (!CommonHooks.onLivingDrops((LivingEntity)this, (DamageSource)source, (Collection)drops, (this.lastHurtByPlayerTime > 0 ? 1 : 0) != 0) && !drops.isEmpty()) {
                this.placeDropsSafely(drops);
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void teleportTo(Vec3 vec) {
        this.setPortalTicks(10);
        this.teleportPos = vec;
        this.fullyThrough = false;
        if (this.getChild() instanceof EntityVoidWormPart) {
            ((EntityVoidWormPart)this.getChild()).teleportTo(this.position(), this.teleportPos);
        }
    }

    private void launch(Entity e, boolean huge) {
        if (e.onGround()) {
            double d0 = e.getX() - this.getX();
            double d1 = e.getZ() - this.getZ();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            float f = huge ? 2.0f : 0.5f;
            e.push(d0 / d2 * (double)f, huge ? 0.5 : (double)0.2f, d1 / d2 * (double)f);
        }
    }

    public void resetWormScales() {
        Entity child;
        if (!this.level().isClientSide && (child = this.getChild()) == null) {
            Object nextPart = this;
            int tailstart = Math.min(3 + this.random.nextInt(2), this.getSegmentCount());
            int segments = this.getSegmentCount();
            int i = 0;
            while (nextPart instanceof EntityVoidWormPart) {
                EntityVoidWormPart part = (EntityVoidWormPart)((EntityVoidWormPart)nextPart).getChild();
                float scale = 1.0f + (float)(++i) / (float)segments * 0.5f;
                boolean tail = i >= segments - tailstart;
                part.setTail(tail);
                part.setWormScale(scale);
                part.radius = 1.0f + scale * (tail ? 0.65f : 0.3f) + (i == 0 ? 0.8f : 0.0f);
                part.offsetY = i == 0 ? -0.0f : (i == segments - tailstart ? -0.3f : 0.0f);
                nextPart = part;
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setSegmentCount(25 + this.random.nextInt(15));
        this.setXRot(0.0f);
        this.setBaseMaxHealth(AMConfig.voidWormMaxHealth, true);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SPLIT_FROM_UUID, Optional.empty());
        builder.define(CHILD_UUID, Optional.empty());
        builder.define(SEGMENT_COUNT, (Object)10);
        builder.define(JAW_TICKS, (Object)0);
        builder.define(WORM_ANGLE, (Object)Float.valueOf(0.0f));
        builder.define(SPEEDMOD, (Object)Float.valueOf(1.0f));
        builder.define(SPLITTER, (Object)false);
        builder.define(PORTAL_TICKS, (Object)0);
    }

    public float getWormAngle() {
        return ((Float)this.entityData.get(WORM_ANGLE)).floatValue();
    }

    public void setWormAngle(float progress) {
        this.entityData.set(WORM_ANGLE, (Object)Float.valueOf(progress));
    }

    public float getWormSpeed() {
        return ((Float)this.entityData.get(SPEEDMOD)).floatValue();
    }

    public void setWormSpeed(float progress) {
        if (this.getWormSpeed() != progress) {
            this.moveControl = new FlightMoveController((Mob)this, progress, false, true);
        }
        this.entityData.set(SPEEDMOD, (Object)Float.valueOf(progress));
    }

    public boolean isSplitter() {
        return (Boolean)this.entityData.get(SPLITTER);
    }

    public void setSplitter(boolean splitter) {
        this.entityData.set(SPLITTER, (Object)splitter);
    }

    public void openMouth(int time) {
        this.entityData.set(JAW_TICKS, (Object)time);
    }

    public boolean isMouthOpen() {
        return (float)((Integer)this.entityData.get(JAW_TICKS)).intValue() >= 5.0f;
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.entityData.get(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.entityData.set(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    @Nullable
    public UUID getSplitFromUUID() {
        return ((Optional)this.entityData.get(SPLIT_FROM_UUID)).orElse(null);
    }

    public void setSplitFromUuid(@Nullable UUID uniqueId) {
        this.entityData.set(SPLIT_FROM_UUID, Optional.ofNullable(uniqueId));
    }

    public int getPortalTicks() {
        return (Integer)this.entityData.get(PORTAL_TICKS);
    }

    public void setPortalTicks(int ticks) {
        this.entityData.set(PORTAL_TICKS, (Object)ticks);
    }

    public int getSegmentCount() {
        return (Integer)this.entityData.get(SEGMENT_COUNT);
    }

    public void setSegmentCount(int command) {
        this.entityData.set(SEGMENT_COUNT, (Object)command);
    }

    public void pushEntities() {
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards((double)0.2f, 0.0, (double)0.2f));
        entities.stream().filter(entity -> !(entity instanceof EntityVoidWormPart) && entity.isPushable()).forEach(entity -> entity.push((Entity)this));
    }

    public void push(Entity entityIn) {
    }

    public void createStuckPortal() {
        if (this.getTarget() != null) {
            this.createPortal(this.getTarget().position().add((double)(this.random.nextInt(8) - 4), (double)(2 + this.random.nextInt(3)), (double)(this.random.nextInt(8) - 4)));
        } else {
            Vec3 vec = Vec3.atCenterOf((Vec3i)this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, this.blockPosition().above(this.random.nextInt(10) + 10)));
            this.createPortal(vec);
        }
    }

    public void createPortal(Vec3 to) {
        this.createPortal(this.position().add(this.getLookAngle().scale(20.0)), to, null);
    }

    public void createPortalRandomDestination() {
        Vec3 vec = null;
        for (int i = 0; i < 15; ++i) {
            BlockPos pos = AMBlockPos.fromCoords(this.getX() + (double)this.random.nextInt(60) - 30.0, 0.0, this.getZ() + (double)this.random.nextInt(60) - 30.0);
            BlockPos height = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos);
            height = height.getY() < 10 ? height.above(50 + this.random.nextInt(50)) : height.above(this.random.nextInt(30));
            if (!this.level().isEmptyBlock(height)) continue;
            vec = Vec3.atBottomCenterOf((Vec3i)height);
        }
        if (vec != null) {
            this.createPortal(this.position().add(this.getLookAngle().scale(20.0)), vec, null);
        }
    }

    public void createPortal(Vec3 from, Vec3 to, @Nullable Direction outDir) {
        if (!this.level().isClientSide && this.portalTarget == null) {
            Vec3 vec;
            Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
            BlockHitResult result = this.level().clip(new ClipContext(Vector3d, from, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            Vec3 vec3 = vec = result.getLocation() != null ? result.getLocation() : this.position();
            if (result instanceof BlockHitResult) {
                BlockHitResult result1 = result;
                vec = vec.add(Vec3.atLowerCornerOf((Vec3i)result1.getDirection().getNormal()));
            }
            EntityVoidPortal portal = (EntityVoidPortal)((EntityType)AMEntityRegistry.VOID_PORTAL.get()).create(this.level());
            portal.setPos(vec.x, vec.y, vec.z);
            Vec3 dirVec = vec.subtract(this.position());
            Direction dir = Direction.getNearest((double)dirVec.x, (double)dirVec.y, (double)dirVec.z);
            portal.setAttachmentFacing(dir);
            portal.setLifespan(10000);
            if (!this.level().isClientSide) {
                this.level().addFreshEntity((Entity)portal);
            }
            this.portalTarget = portal;
            portal.setDestination(AMBlockPos.fromCoords(to.x, to.y, to.z), outDir);
            this.makePortalCooldown = 300;
        }
    }

    public void resetPortalLogic() {
        this.portalTarget = null;
        this.stillTicks = 0;
    }

    public boolean isPushable() {
        return false;
    }

    public void breakBlock() {
        if (this.blockBreakCounter > 0) {
            --this.blockBreakCounter;
            return;
        }
        boolean flag = false;
        if (!this.level().isClientSide && this.blockBreakCounter == 0 && EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
            for (int a = (int)Math.round(this.getBoundingBox().minX); a <= (int)Math.round(this.getBoundingBox().maxX); ++a) {
                for (int b = (int)Math.round(this.getBoundingBox().minY) - 1; b <= (int)Math.round(this.getBoundingBox().maxY) + 1 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.getBoundingBox().minZ); c <= (int)Math.round(this.getBoundingBox().maxZ); ++c) {
                        BlockPos pos = new BlockPos(a, b, c);
                        BlockState state = this.level().getBlockState(pos);
                        FluidState fluidState = this.level().getFluidState(pos);
                        Block block = state.getBlock();
                        if (state.isAir() || state.getShape((BlockGetter)this.level(), pos).isEmpty() || !state.is(AMTagRegistry.VOID_WORM_BREAKABLES) || !fluidState.isEmpty() || block == Blocks.AIR) continue;
                        this.setDeltaMovement(this.getDeltaMovement().multiply((double)0.6f, 1.0, (double)0.6f));
                        flag = true;
                        this.level().destroyBlock(pos, true);
                        if (!state.is(BlockTags.ICE)) continue;
                        this.level().setBlockAndUpdate(pos, Blocks.WATER.defaultBlockState());
                    }
                }
            }
        }
        if (flag) {
            this.blockBreakCounter = 10;
        }
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    public Vec3 getBlockInViewAway(Vec3 fleePos, float radiusAdd) {
        float radius = (-9.45f - (float)this.getRandom().nextInt(24)) * radiusAdd;
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = AMBlockPos.fromCoords(fleePos.x() + extraX, 0.0, fleePos.z() + extraZ);
        BlockPos ground = this.getGround(radialPos);
        int distFromGround = (int)this.getY() - ground.getY();
        int flightHeight = 10 + this.getRandom().nextInt(20);
        BlockPos newPos = ground.above(distFromGround > 8 ? flightHeight : this.getRandom().nextInt(10) + 15);
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos)) && this.distanceToSqr(Vec3.atCenterOf((Vec3i)newPos)) > 1.0) {
            return Vec3.atCenterOf((Vec3i)newPos);
        }
        return null;
    }

    public Vec3 getBlockInViewAwaySlam(Vec3 fleePos, int slamHeight) {
        float radius = 3 + this.random.nextInt(3);
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = AMBlockPos.fromCoords(fleePos.x() + extraX, 0.0, fleePos.z() + extraZ);
        BlockPos ground = this.getHeighestAirAbove(radialPos, slamHeight);
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)ground)) && this.distanceToSqr(Vec3.atCenterOf((Vec3i)ground)) > 1.0) {
            return Vec3.atCenterOf((Vec3i)ground);
        }
        return null;
    }

    private BlockPos getHeighestAirAbove(BlockPos radialPos, int limit) {
        BlockPos position = AMBlockPos.fromCoords(radialPos.getX(), this.getY(), radialPos.getZ());
        while (position.getY() < 256 && (double)position.getY() < this.getY() + (double)limit && this.level().isEmptyBlock(position)) {
            position = position.above();
        }
        return position;
    }

    private BlockPos getGround(BlockPos in) {
        BlockPos position = AMBlockPos.fromCoords(in.getX(), this.getY(), in.getZ());
        while (position.getY() > -63 && !this.level().getBlockState(position).isSolid()) {
            position = position.below();
        }
        if (position.getY() < -62) {
            return position.above(120 + this.random.nextInt(5));
        }
        return position;
    }

    public boolean isAlliedTo(Entity entityIn) {
        return super.isAlliedTo(entityIn) || this.getSplitFromUUID() != null && this.getSplitFromUUID().equals(entityIn.getUUID()) || entityIn instanceof EntityVoidWorm && ((EntityVoidWorm)entityIn).getSplitFromUUID() != null && ((EntityVoidWorm)entityIn).getSplitFromUUID().equals(entityIn.getUUID());
    }

    private void spit(Vec3 shotAt, boolean portal) {
        shotAt = shotAt.yRot(-this.getYRot() * ((float)Math.PI / 180));
        EntityVoidWormShot shot = new EntityVoidWormShot(this.level(), this);
        double d0 = shotAt.x;
        double d1 = shotAt.y;
        double d2 = shotAt.z;
        float f = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2))) * 0.35f;
        shot.shoot(d0, d1 + (double)f, d2, 0.5f, 3.0f);
        if (!this.isSilent()) {
            this.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.DROWNED_SHOOT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        this.openMouth(5);
        this.level().addFreshEntity((Entity)shot);
    }

    private boolean wormAttack(Entity entity, DamageSource source, float dmg) {
        dmg = (float)((double)dmg * AMConfig.voidWormDamageModifier);
        return entity instanceof EnderDragon ? entity.hurt(source, dmg * 0.5f) : entity.hurt(source, dmg);
    }

    public void playHurtSoundWorm(DamageSource source) {
        this.playHurtSound(source);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 67) {
            AlexsMobs.PROXY.onEntityStatus((Entity)this, id);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public class AIEnterPortal
    extends Goal {
        public AIEnterPortal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return EntityVoidWorm.this.portalTarget != null;
        }

        public void tick() {
            if (EntityVoidWorm.this.portalTarget != null) {
                double d2;
                double d1;
                EntityVoidWorm.this.noPhysics = true;
                double centerX = EntityVoidWorm.this.portalTarget.getX();
                double centerY = EntityVoidWorm.this.portalTarget.getY(0.5);
                double centerZ = EntityVoidWorm.this.portalTarget.getZ();
                double d0 = centerX - EntityVoidWorm.this.getX();
                Vec3 vec = new Vec3(d0, d1 = centerY - EntityVoidWorm.this.getY(0.5), d2 = centerZ - EntityVoidWorm.this.getZ());
                if (vec.length() > 1.0) {
                    vec = vec.normalize();
                }
                vec = vec.scale((double)0.4f);
                EntityVoidWorm.this.setDeltaMovement(EntityVoidWorm.this.getDeltaMovement().add(vec));
            }
        }

        public void stop() {
            EntityVoidWorm.this.noPhysics = false;
        }
    }

    public class AIAttack
    extends Goal {
        private AttackMode mode = AttackMode.CIRCLE;
        private int modeTicks = 0;
        private int maxCircleTime = 500;
        private Vec3 moveTo = null;

        public AIAttack() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return EntityVoidWorm.this.getTarget() != null && EntityVoidWorm.this.getTarget().isAlive();
        }

        public void stop() {
            this.mode = AttackMode.CIRCLE;
            this.modeTicks = 0;
        }

        public void start() {
            this.mode = AttackMode.CIRCLE;
            this.maxCircleTime = 60 + EntityVoidWorm.this.random.nextInt(200);
        }

        public void tick() {
            LivingEntity target = EntityVoidWorm.this.getTarget();
            boolean flag = false;
            float speed = 1.0f;
            for (Entity entity : EntityVoidWorm.this.level().getEntitiesOfClass(LivingEntity.class, EntityVoidWorm.this.getBoundingBox().inflate(2.0))) {
                if (entity.is((Entity)EntityVoidWorm.this) || entity instanceof EntityVoidWormPart || entity.isAlliedTo((Entity)EntityVoidWorm.this) || entity == EntityVoidWorm.this) continue;
                if (EntityVoidWorm.this.isMouthOpen()) {
                    EntityVoidWorm.this.launch(entity, true);
                    flag = true;
                    EntityVoidWorm.this.wormAttack(entity, EntityVoidWorm.this.damageSources().mobAttack((LivingEntity)EntityVoidWorm.this), 8.0f + EntityVoidWorm.this.random.nextFloat() * 8.0f);
                    continue;
                }
                EntityVoidWorm.this.openMouth(15);
            }
            if (target != null) {
                if (this.mode == AttackMode.CIRCLE) {
                    int interval;
                    if (this.moveTo == null || EntityVoidWorm.this.distanceToSqr(this.moveTo) < 16.0 || EntityVoidWorm.this.horizontalCollision) {
                        this.moveTo = EntityVoidWorm.this.getBlockInViewAway(target.position(), 0.4f + EntityVoidWorm.this.random.nextFloat() * 0.2f);
                    }
                    int n = interval = EntityVoidWorm.this.getHealth() < EntityVoidWorm.this.getMaxHealth() && !EntityVoidWorm.this.isSplitter() ? 15 : 40;
                    if (this.modeTicks % interval == 0) {
                        EntityVoidWorm.this.spit(new Vec3(3.0, 3.0, 0.0), false);
                        EntityVoidWorm.this.spit(new Vec3(-3.0, 3.0, 0.0), false);
                        EntityVoidWorm.this.spit(new Vec3(3.0, -3.0, 0.0), false);
                        EntityVoidWorm.this.spit(new Vec3(-3.0, -3.0, 0.0), false);
                    }
                    ++this.modeTicks;
                    if (this.modeTicks > this.maxCircleTime) {
                        this.maxCircleTime = 60 + EntityVoidWorm.this.random.nextInt(200);
                        this.mode = AttackMode.SLAM_RISE;
                        this.modeTicks = 0;
                        this.moveTo = null;
                    }
                } else if (this.mode == AttackMode.SLAM_RISE) {
                    if (this.moveTo == null) {
                        this.moveTo = EntityVoidWorm.this.getBlockInViewAwaySlam(target.position(), 20 + EntityVoidWorm.this.random.nextInt(20));
                    }
                    if (this.moveTo != null && EntityVoidWorm.this.getY() > target.getY() + 15.0) {
                        this.moveTo = null;
                        this.modeTicks = 0;
                        this.mode = AttackMode.SLAM_FALL;
                    }
                } else if (this.mode == AttackMode.SLAM_FALL) {
                    speed = 2.0f;
                    EntityVoidWorm.this.lookAt((Entity)target, 360.0f, 360.0f);
                    this.moveTo = target.position();
                    if (EntityVoidWorm.this.horizontalCollision) {
                        this.moveTo = new Vec3(target.getX(), EntityVoidWorm.this.getY() + 3.0, target.getZ());
                    }
                    EntityVoidWorm.this.openMouth(20);
                    if (EntityVoidWorm.this.distanceToSqr(this.moveTo) < 4.0 || flag) {
                        this.mode = AttackMode.CIRCLE;
                        this.moveTo = null;
                        this.modeTicks = 0;
                    }
                }
            }
            if (!EntityVoidWorm.this.hasLineOfSight((Entity)target) && EntityVoidWorm.this.random.nextInt(100) == 0 && EntityVoidWorm.this.makePortalCooldown == 0) {
                Vec3 to = new Vec3(target.getX(), target.getBoundingBox().maxY + 0.1, target.getZ());
                EntityVoidWorm.this.createPortal(EntityVoidWorm.this.position().add(EntityVoidWorm.this.getLookAngle().scale(20.0)), to, Direction.UP);
                EntityVoidWorm.this.makePortalCooldown = 50;
                this.mode = AttackMode.SLAM_FALL;
            }
            if (this.moveTo != null && EntityVoidWorm.this.portalTarget == null) {
                EntityVoidWorm.this.getMoveControl().setWantedPosition(this.moveTo.x, this.moveTo.y, this.moveTo.z, (double)speed);
            }
        }
    }

    private class AIFlyIdle
    extends Goal {
        protected final EntityVoidWorm voidWorm;
        protected double x;
        protected double y;
        protected double z;

        public AIFlyIdle(EntityVoidWorm entityVoidWorm) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.voidWorm = entityVoidWorm;
        }

        public boolean canUse() {
            if (this.voidWorm.isVehicle() || this.voidWorm.portalTarget != null || this.voidWorm.getTarget() != null && this.voidWorm.getTarget().isAlive() || this.voidWorm.isPassenger()) {
                return false;
            }
            Vec3 lvt_1_1_ = this.getPosition();
            if (lvt_1_1_ == null) {
                return false;
            }
            this.x = lvt_1_1_.x;
            this.y = lvt_1_1_.y;
            this.z = lvt_1_1_.z;
            return true;
        }

        public void tick() {
            this.voidWorm.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = this.voidWorm.position();
            return this.voidWorm.getBlockInViewAway(vector3d, 1.0f);
        }

        public boolean canContinueToUse() {
            return this.voidWorm.distanceToSqr(this.x, this.y, this.z) > 20.0 && this.voidWorm.portalTarget == null && !this.voidWorm.horizontalCollision && (this.voidWorm.getTarget() == null || !this.voidWorm.getTarget().isAlive());
        }

        public void start() {
            this.voidWorm.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
        }

        public void stop() {
            this.voidWorm.getNavigation().stop();
            super.stop();
        }
    }

    private static enum AttackMode {
        CIRCLE,
        SLAM_RISE,
        SLAM_FALL,
        PORTAL;

    }
}

