/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityRoadrunner;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.FlyingAIFollowOwner;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.alexsmobs.network.MessageTarantulaHawkSting;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityTarantulaHawk
extends TamableAnimal
implements IFollower {
    public static final int STING_DURATION = 2400;
    protected static final EntityDimensions FLIGHT_SIZE = EntityDimensions.fixed((float)0.9f, (float)1.5f);
    private static final EntityDataAccessor<Float> FLY_ANGLE = SynchedEntityData.defineId(EntityTarantulaHawk.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> NETHER = SynchedEntityData.defineId(EntityTarantulaHawk.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(EntityTarantulaHawk.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DRAGGING = SynchedEntityData.defineId(EntityTarantulaHawk.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(EntityTarantulaHawk.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DIGGING = SynchedEntityData.defineId(EntityTarantulaHawk.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SCARED = SynchedEntityData.defineId(EntityTarantulaHawk.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.defineId(EntityTarantulaHawk.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.defineId(EntityTarantulaHawk.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.defineId(EntityTarantulaHawk.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float prevFlyAngle;
    public float prevSitProgress;
    public float sitProgress;
    public float prevDragProgress;
    public float dragProgress;
    public float prevFlyProgress;
    public float flyProgress;
    public float prevAttackProgress;
    public float attackProgress;
    public float prevDigProgress;
    public float digProgress;
    private boolean isLandNavigator;
    private boolean flightSize = false;
    private int timeFlying = 0;
    private boolean bredBuryFlag = false;
    private int spiderFeedings = 0;
    private int dragTime = 0;

    protected EntityTarantulaHawk(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.switchNavigator(false);
    }

    public static boolean canTarantulaHawkSpawn(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return worldIn.getBlockState(pos.below()).is(AMTagRegistry.TARANTULA_HAWK_SPAWNS) && worldIn.getRawBrightness(pos, 0) > 8 || EntityTarantulaHawk.isBiomeNether(worldIn, pos) || AMConfig.fireproofTarantulaHawk;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 18.0).add(Attributes.ARMOR, 4.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 5.0);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.tarantulaHawkSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        if (EntityTarantulaHawk.isBiomeNether((LevelAccessor)worldIn, this.blockPosition())) {
            this.setNether(true);
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    private static boolean isBiomeNether(LevelAccessor worldIn, BlockPos position) {
        return worldIn.getBiome(position).is(AMTagRegistry.SPAWNS_NETHER_TARANTULA_HAWKS);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new FlyingAIFollowOwner(this, 1.0, 10.0f, 2.0f, false));
        this.goalSelector.addGoal(3, (Goal)new AIFleeRoadrunners());
        this.goalSelector.addGoal(4, (Goal)new AIMelee());
        this.goalSelector.addGoal(5, (Goal)new AIBury());
        this.goalSelector.addGoal(6, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredient.fromValues(Stream.of(new Ingredient.TagValue(AMTagRegistry.TARANTULA_HAWK_BREEDABLES), new Ingredient.TagValue(AMTagRegistry.TARANTULA_HAWK_TAMEABLES), new Ingredient.TagValue(AMTagRegistry.TARANTULA_HAWK_FOODSTUFFS))), false));
        this.goalSelector.addGoal(8, (Goal)new AIWalkIdle());
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new AnimalAIHurtByTargetNotBaby((Animal)this, new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new EntityAINearestTarget3D((Mob)this, Spider.class, 15, true, true, null){

            public boolean canUse() {
                return super.canUse() && !EntityTarantulaHawk.this.isBaby() && !EntityTarantulaHawk.this.isSitting();
            }
        });
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.TARANTULA_HAWK_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.TARANTULA_HAWK_HURT.get();
    }

    public boolean fireImmune() {
        return this.isNether() || AMConfig.fireproofTarantulaHawk;
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigation((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new MoveController();
            this.navigation = new DirectPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLY_ANGLE, (Object)Float.valueOf(0.0f));
        builder.define(NETHER, (Object)false);
        builder.define(FLYING, (Object)false);
        builder.define(SITTING, (Object)false);
        builder.define(DRAGGING, (Object)false);
        builder.define(DIGGING, (Object)false);
        builder.define(SCARED, (Object)false);
        builder.define(ANGRY, (Object)false);
        builder.define(ATTACK_TICK, (Object)0);
        builder.define(COMMAND, (Object)0);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() instanceof LivingEntity && ((LivingEntity)source.getEntity()).getType().is(EntityTypeTags.ARTHROPOD) && ((LivingEntity)source.getEntity()).hasEffect(AMEffectRegistry.DEBILITATING_STING)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("HawkSitting", this.isSitting());
        compound.putBoolean("Nether", this.isNether());
        compound.putBoolean("Digging", this.isDigging());
        compound.putBoolean("Flying", this.isFlying());
        compound.putInt("Command", this.getCommand());
        compound.putInt("SpiderFeedings", this.spiderFeedings);
        compound.putBoolean("BreedFlag", this.bredBuryFlag);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setOrderedToSit(compound.getBoolean("HawkSitting"));
        this.setNether(compound.getBoolean("Nether"));
        this.setDigging(compound.getBoolean("Digging"));
        this.setFlying(compound.getBoolean("Flying"));
        this.setCommand(compound.getInt("Command"));
        this.spiderFeedings = compound.getInt("SpiderFeedings");
        this.bredBuryFlag = compound.getBoolean("BreedFlag");
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).isOwnedBy(livingentity);
            }
            if (livingentity != null) {
                return livingentity.isAlliedTo(entityIn);
            }
        }
        return super.isAlliedTo(entityIn);
    }

    public float getFlyAngle() {
        return ((Float)this.entityData.get(FLY_ANGLE)).floatValue();
    }

    public void setFlyAngle(float progress) {
        this.entityData.set(FLY_ANGLE, (Object)Float.valueOf(progress));
    }

    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    public void setFlying(boolean flying) {
        if (flying && this.isBaby()) {
            return;
        }
        this.entityData.set(FLYING, (Object)flying);
    }

    public boolean isNether() {
        return (Boolean)this.entityData.get(NETHER);
    }

    public void setNether(boolean sit) {
        this.entityData.set(NETHER, (Object)sit);
    }

    public boolean isScared() {
        return (Boolean)this.entityData.get(SCARED);
    }

    public void setScared(boolean sit) {
        this.entityData.set(SCARED, (Object)sit);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setOrderedToSit(boolean sit) {
        this.entityData.set(SITTING, (Object)sit);
    }

    public boolean isDragging() {
        return (Boolean)this.entityData.get(DRAGGING);
    }

    public void setDragging(boolean sit) {
        this.entityData.set(DRAGGING, (Object)sit);
    }

    public boolean isDigging() {
        return (Boolean)this.entityData.get(DIGGING);
    }

    public void setDigging(boolean sit) {
        this.entityData.set(DIGGING, (Object)sit);
    }

    public void tick() {
        this.prevFlyAngle = this.getFlyAngle();
        super.tick();
        this.prevAttackProgress = this.attackProgress;
        this.prevFlyProgress = this.flyProgress;
        this.prevSitProgress = this.sitProgress;
        this.prevDragProgress = this.dragProgress;
        this.prevDigProgress = this.digProgress;
        boolean flying = this.isFlying();
        boolean sitting = this.isSitting();
        boolean dragging = this.isDragging();
        boolean digging = this.isDigging();
        if (flying) {
            if (this.flyProgress < 5.0f) {
                this.flyProgress += 1.0f;
            }
        } else if (this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (sitting) {
            if (this.sitProgress < 5.0f) {
                this.sitProgress += 1.0f;
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (dragging) {
            if (this.dragProgress < 5.0f) {
                this.dragProgress += 1.0f;
            }
        } else if (this.dragProgress > 0.0f) {
            this.dragProgress -= 1.0f;
        }
        if (digging) {
            if (this.digProgress < 5.0f) {
                this.digProgress += 1.0f;
            }
        } else if (this.digProgress > 0.0f) {
            this.digProgress -= 1.0f;
        }
        if (this.flightSize && !flying) {
            this.refreshDimensions();
            this.flightSize = false;
        }
        if (!this.flightSize && this.isFlying()) {
            this.refreshDimensions();
            this.flightSize = true;
        }
        float threshold = 0.015f;
        if (this.isFlying() && this.yRotO - this.getYRot() > threshold) {
            this.setFlyAngle(this.getFlyAngle() + 5.0f);
        } else if (this.isFlying() && this.yRotO - this.getYRot() < -threshold) {
            this.setFlyAngle(this.getFlyAngle() - 5.0f);
        } else if (this.getFlyAngle() > 0.0f) {
            this.setFlyAngle(Math.max(this.getFlyAngle() - 4.0f, 0.0f));
        } else if (this.getFlyAngle() < 0.0f) {
            this.setFlyAngle(Math.min(this.getFlyAngle() + 4.0f, 0.0f));
        }
        this.setFlyAngle(Mth.clamp((float)this.getFlyAngle(), (float)-30.0f, (float)30.0f));
        if (!this.level().isClientSide) {
            if (this.isFlying() && this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (!this.isFlying() && !this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (this.isFlying()) {
                if (this.timeFlying % 25 == 0) {
                    this.playSound((SoundEvent)AMSoundRegistry.TARANTULA_HAWK_WING.get(), this.getSoundVolume(), this.getVoicePitch());
                }
                ++this.timeFlying;
                this.setNoGravity(true);
                if (this.isSitting() || this.isPassenger() || this.isInLove()) {
                    this.setFlying(false);
                }
            } else {
                this.timeFlying = 0;
                this.setNoGravity(false);
            }
            if (this.getTarget() != null && this.getTarget() instanceof Player && !this.isTame()) {
                this.entityData.set(ANGRY, (Object)true);
            } else {
                this.entityData.set(ANGRY, (Object)false);
            }
        }
        if ((Integer)this.entityData.get(ATTACK_TICK) > 0) {
            this.entityData.set(ATTACK_TICK, (Object)((Integer)this.entityData.get(ATTACK_TICK) - 1));
            if (this.attackProgress < 5.0f) {
                this.attackProgress += 1.0f;
            }
        } else if (this.attackProgress > 0.0f) {
            this.attackProgress -= 1.0f;
        }
        if (this.isDigging() && this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).canOcclude()) {
            BlockPos posit = this.getBlockPosBelowThatAffectsMyMovement();
            BlockState understate = this.level().getBlockState(posit);
            for (int i = 0; i < 4 + this.random.nextInt(2); ++i) {
                double particleX = (float)posit.getX() + this.random.nextFloat();
                double particleY = (float)posit.getY() + 1.0f;
                double particleZ = (float)posit.getZ() + this.random.nextFloat();
                double motX = this.random.nextGaussian() * 0.02;
                double motY = 0.1f + this.random.nextFloat() * 0.2f;
                double motZ = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, understate), particleX, particleY, particleZ, motX, motY, motZ);
            }
        }
        if (this.tickCount > 0 && this.tickCount % 300 == 0 && this.getHealth() < this.getMaxHealth()) {
            this.heal(1.0f);
        }
        if (!this.level().isClientSide && this.isDragging() && this.getPassengers().isEmpty() && !this.isDigging()) {
            ++this.dragTime;
            if (this.dragTime > 5000) {
                this.dragTime = 0;
                for (Entity e : this.getPassengers()) {
                    e.hurt(this.damageSources().mobAttack((LivingEntity)this), 10.0f);
                }
                this.ejectPassengers();
                this.setDragging(false);
            }
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!this.isTame() && itemstack.is(AMTagRegistry.TARANTULA_HAWK_TAMEABLES)) {
            if (!this.level().isClientSide) {
                this.usePlayerItem(player, hand, itemstack);
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.STRIDER_EAT, this.getSoundVolume(), this.getVoicePitch());
                ++this.spiderFeedings;
                if (this.spiderFeedings >= 15 && this.getRandom().nextInt(6) == 0 || this.spiderFeedings > 25) {
                    this.tame(player);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        InteractionResult type = super.mobInteract(player, hand);
        if (this.isTame() && itemstack.is(AMTagRegistry.TARANTULA_HAWK_FOODSTUFFS)) {
            if (this.getHealth() < this.getMaxHealth()) {
                if (!this.level().isClientSide) {
                    this.usePlayerItem(player, hand, itemstack);
                    this.gameEvent((Holder)GameEvent.EAT);
                    this.playSound(SoundEvents.STRIDER_EAT, this.getSoundVolume(), this.getVoicePitch());
                    this.heal(5.0f);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            return InteractionResult.PASS;
        }
        InteractionResult interactionresult = itemstack.interactLivingEntity(player, (LivingEntity)this, hand);
        if (interactionresult != InteractionResult.SUCCESS && type != InteractionResult.SUCCESS && this.isTame() && this.isOwnedBy((LivingEntity)player)) {
            if (player.isShiftKeyDown()) {
                if (this.getMainHandItem().isEmpty()) {
                    ItemStack cop = itemstack.copy();
                    cop.setCount(1);
                    this.setItemInHand(InteractionHand.MAIN_HAND, cop);
                    itemstack.shrink(1);
                    return InteractionResult.SUCCESS;
                }
                this.spawnAtLocation(this.getMainHandItem().copy());
                this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                return InteractionResult.SUCCESS;
            }
            if (!this.isFood(itemstack)) {
                boolean sit;
                this.setCommand(this.getCommand() + 1);
                if (this.getCommand() == 3) {
                    this.setCommand(0);
                }
                player.displayClientMessage((Component)Component.translatable((String)("entity.alexsmobs.all.command_" + this.getCommand()), (Object[])new Object[]{this.getName()}), true);
                boolean bl = sit = this.getCommand() == 2;
                if (sit) {
                    this.setOrderedToSit(true);
                    return InteractionResult.SUCCESS;
                }
                this.setOrderedToSit(false);
                return InteractionResult.SUCCESS;
            }
        }
        return type;
    }

    public boolean isFood(ItemStack stack) {
        Item item = stack.getItem();
        return this.isTame() && stack.is(AMTagRegistry.TARANTULA_HAWK_BREEDABLES);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return null;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypes.CACTUS) || super.isInvulnerableTo(source);
    }

    public void spawnChildFromBreeding(ServerLevel world, Animal animalEntity) {
        this.bredBuryFlag = true;
        ServerPlayer serverplayerentity = this.getLoveCause();
        if (serverplayerentity == null && animalEntity.getLoveCause() != null) {
            serverplayerentity = animalEntity.getLoveCause();
        }
        if (serverplayerentity != null) {
            serverplayerentity.awardStat(Stats.ANIMALS_BRED);
            CriteriaTriggers.BRED_ANIMALS.trigger(serverplayerentity, (Animal)this, animalEntity, (AgeableMob)this);
        }
        this.setAge(6000);
        animalEntity.setAge(6000);
        this.resetLove();
        animalEntity.resetLove();
        world.broadcastEntityEvent((Entity)this, (byte)7);
        world.broadcastEntityEvent((Entity)this, (byte)18);
        if (world.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            world.addFreshEntity((Entity)new ExperienceOrb((Level)world, this.getX(), this.getY(), this.getZ(), this.getRandom().nextInt(7) + 1));
        }
    }

    @Override
    public void followEntity(TamableAnimal tameable, LivingEntity owner, double followSpeed) {
        if (this.distanceTo((Entity)owner) > 5.0f) {
            this.setFlying(true);
            this.getMoveControl().setWantedPosition(owner.getX(), owner.getY() + (double)owner.getBbHeight(), owner.getZ(), followSpeed);
        } else {
            if (this.onGround()) {
                this.setFlying(false);
            }
            if (this.isFlying() && !this.isOverWater()) {
                BlockPos vec = this.getCrowGround(this.blockPosition());
                if (vec != null) {
                    this.getMoveControl().setWantedPosition((double)vec.getX(), (double)vec.getY(), (double)vec.getZ(), followSpeed);
                }
            } else {
                this.getNavigation().moveTo((Entity)owner, followSpeed);
            }
        }
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunc) {
        this.setXRot(0.0f);
        float radius = 1.0f + passenger.getBbWidth() * 0.5f;
        float angle = (float)Math.PI / 180 * (this.yBodyRot - 180.0f);
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        double extraY = 0.0;
        passenger.setPos(this.getX() + extraX, this.getY() + extraY, this.getZ() + extraZ);
    }

    private boolean isOverWater() {
        BlockPos position = this.blockPosition();
        while (position.getY() > 0 && this.level().isEmptyBlock(position)) {
            position = position.below();
        }
        return !this.level().getFluidState(position).isEmpty() || position.getY() <= 0;
    }

    public Vec3 getBlockInViewAway(Vec3 fleePos, float radiusAdd) {
        float radius = -9.45f - (float)this.getRandom().nextInt(24) - radiusAdd;
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.x() + extraX), 0, (int)(fleePos.z() + extraZ));
        BlockPos ground = this.getCrowGround(radialPos);
        int distFromGround = (int)this.getY() - ground.getY();
        int flightHeight = 4 + this.getRandom().nextInt(10);
        BlockPos newPos = ground.above(distFromGround > 8 ? flightHeight : this.getRandom().nextInt(6) + 1);
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos)) && this.distanceToSqr(Vec3.atCenterOf((Vec3i)newPos)) > 1.0) {
            return Vec3.atCenterOf((Vec3i)newPos);
        }
        return null;
    }

    private BlockPos getCrowGround(BlockPos in) {
        BlockPos position = new BlockPos(in.getX(), (int)this.getY(), in.getZ());
        while (position.getY() > -64 && !this.level().getBlockState(position).isSolid() && this.level().getFluidState(position).isEmpty()) {
            position = position.below();
        }
        return position;
    }

    public Vec3 getBlockGrounding(Vec3 fleePos) {
        float radius = -9.45f - (float)this.getRandom().nextInt(24);
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.x() + extraX), (int)this.getY(), (int)(fleePos.z() + extraZ));
        BlockPos ground = this.getCrowGround(radialPos);
        if (ground.getY() == -64) {
            return this.position();
        }
        ground = this.blockPosition();
        while (ground.getY() > -62 && !this.level().getBlockState(ground).isSolid()) {
            ground = ground.below();
        }
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)ground.above()))) {
            return Vec3.atCenterOf((Vec3i)ground);
        }
        return null;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    private Vec3 getOrbitVec(Vec3 vector3d, float gatheringCircleDist, boolean orbitClockwise) {
        float angle = (float)Math.PI / 90 * (float)(orbitClockwise ? -this.tickCount : this.tickCount);
        double extraX = gatheringCircleDist * Mth.sin((float)angle);
        double extraZ = gatheringCircleDist * Mth.cos((float)angle);
        if (vector3d != null) {
            Vec3 pos = new Vec3(vector3d.x() + extraX, vector3d.y() + (double)this.random.nextInt(2) + 4.0, vector3d.z() + extraZ);
            if (this.level().isEmptyBlock(AMBlockPos.fromVec3(pos))) {
                return pos;
            }
        }
        return null;
    }

    public int getCommand() {
        return (Integer)this.entityData.get(COMMAND);
    }

    public void setCommand(int command) {
        this.entityData.set(COMMAND, (Object)command);
    }

    private BlockPos genSandPos(BlockPos parent) {
        Level world = this.level();
        Random random = new Random();
        int range = 24;
        for (int i = 0; i < 15; ++i) {
            BlockPos sandAir = parent.offset(random.nextInt(range) - range / 2, -5, random.nextInt(range) - range / 2);
            while (!world.isEmptyBlock(sandAir) && sandAir.getY() < 255) {
                sandAir = sandAir.above();
            }
            BlockState state = world.getBlockState(sandAir.below());
            if (!state.is(BlockTags.SAND)) continue;
            return sandAir.below();
        }
        return null;
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1 && !this.isDragging() && !this.isDigging() && (this.getTarget() == null || !this.getTarget().isAlive());
    }

    public boolean isAngry() {
        return (Boolean)this.entityData.get(ANGRY);
    }

    private class AIFleeRoadrunners
    extends Goal {
        private int searchCooldown = 0;
        private LivingEntity fear = null;
        private Vec3 fearVec = null;

        private AIFleeRoadrunners() {
        }

        public boolean canUse() {
            if (this.searchCooldown <= 0) {
                this.searchCooldown = 100 + EntityTarantulaHawk.this.random.nextInt(100);
                List list = EntityTarantulaHawk.this.level().getEntitiesOfClass(EntityRoadrunner.class, EntityTarantulaHawk.this.getBoundingBox().inflate(15.0, 32.0, 15.0));
                for (EntityRoadrunner roadrunner : list) {
                    if (this.fear != null && !(EntityTarantulaHawk.this.distanceTo((Entity)this.fear) > EntityTarantulaHawk.this.distanceTo((Entity)roadrunner))) continue;
                    this.fear = roadrunner;
                }
            } else {
                --this.searchCooldown;
            }
            return EntityTarantulaHawk.this.isAlive() && this.fear != null;
        }

        public boolean canContinueToUse() {
            return this.fear != null && this.fear.isAlive() && EntityTarantulaHawk.this.distanceTo((Entity)this.fear) < 32.0f;
        }

        public void start() {
            super.start();
            EntityTarantulaHawk.this.setScared(true);
        }

        public void tick() {
            if (this.fear != null) {
                if (this.fearVec == null || EntityTarantulaHawk.this.distanceToSqr(this.fearVec) < 4.0) {
                    this.fearVec = EntityTarantulaHawk.this.getBlockInViewAway(this.fearVec == null ? this.fear.position() : this.fearVec, 12.0f);
                }
                if (this.fearVec != null) {
                    EntityTarantulaHawk.this.setFlying(true);
                    EntityTarantulaHawk.this.getMoveControl().setWantedPosition(this.fearVec.x, this.fearVec.y, this.fearVec.z, (double)1.1f);
                }
            }
        }

        public void stop() {
            EntityTarantulaHawk.this.setScared(false);
            this.fear = null;
            this.fearVec = null;
        }
    }

    private class AIMelee
    extends Goal {
        private final EntityTarantulaHawk hawk;
        private int orbitCooldown = 0;
        private boolean clockwise = false;
        private Vec3 orbitVec = null;
        private BlockPos sandPos = null;

        public AIMelee() {
            this.hawk = EntityTarantulaHawk.this;
        }

        public boolean canUse() {
            return this.hawk.getTarget() != null && !this.hawk.isSitting() && !this.hawk.isScared() && this.hawk.getTarget().isAlive() && !this.hawk.isDragging() && !this.hawk.isDigging() && !this.hawk.getTarget().noPhysics && !this.hawk.getTarget().isPassenger();
        }

        public void start() {
            this.hawk.setDragging(false);
            this.clockwise = EntityTarantulaHawk.this.random.nextBoolean();
        }

        public void tick() {
            boolean paralizedWithChild;
            LivingEntity target = this.hawk.getTarget();
            boolean paralized = target != null && target.getType().is(EntityTypeTags.ARTHROPOD) && !target.noPhysics && target.hasEffect(AMEffectRegistry.DEBILITATING_STING);
            boolean bl = paralizedWithChild = paralized && target.getEffect(AMEffectRegistry.DEBILITATING_STING.getDelegate()).getAmplifier() > 0;
            if (this.sandPos == null || !EntityTarantulaHawk.this.level().getBlockState(this.sandPos).is(BlockTags.SAND)) {
                this.sandPos = this.hawk.genSandPos(target.blockPosition());
            }
            if (this.orbitCooldown > 0) {
                --this.orbitCooldown;
                this.hawk.setFlying(true);
                if (target != null && (this.orbitVec == null || this.hawk.distanceToSqr(this.orbitVec) < 4.0 || !this.hawk.getMoveControl().hasWanted())) {
                    this.orbitVec = this.hawk.getOrbitVec(target.position().add(0.0, (double)target.getBbHeight(), 0.0), 10 + EntityTarantulaHawk.this.random.nextInt(2), false);
                    if (this.orbitVec != null) {
                        this.hawk.getMoveControl().setWantedPosition(this.orbitVec.x, this.orbitVec.y, this.orbitVec.z, 1.0);
                    }
                }
            } else if ((paralized && !this.hawk.isTame() || paralizedWithChild && this.hawk.bredBuryFlag) && this.sandPos != null) {
                if (this.hawk.onGround()) {
                    this.hawk.setFlying(false);
                    this.hawk.getNavigation().moveTo((Entity)target, 1.0);
                } else {
                    Vec3 vector3d = this.hawk.getBlockGrounding(this.hawk.position());
                    if (vector3d != null && this.hawk.isFlying()) {
                        this.hawk.getMoveControl().setWantedPosition(vector3d.x, vector3d.y, vector3d.z, 1.0);
                    }
                }
                if (this.hawk.distanceTo((Entity)target) < target.getBbWidth() + 1.5f && !target.isPassenger()) {
                    this.hawk.setDragging(true);
                    this.hawk.setFlying(false);
                    target.startRiding((Entity)this.hawk, true);
                }
            } else if (target != null && !paralizedWithChild) {
                double dist = this.hawk.distanceTo((Entity)target);
                if (dist < 10.0 && !this.hawk.isFlying()) {
                    if (this.hawk.onGround()) {
                        this.hawk.setFlying(false);
                    }
                    this.hawk.getNavigation().moveTo((Entity)target, 1.0);
                } else {
                    this.hawk.setFlying(true);
                    this.hawk.getMoveControl().setWantedPosition(target.getX(), target.getEyeY(), target.getZ(), 1.0);
                }
                if (dist < (double)(target.getBbWidth() + 2.5f)) {
                    if ((Integer)this.hawk.entityData.get(ATTACK_TICK) == 0 && this.hawk.attackProgress == 0.0f) {
                        this.hawk.entityData.set(ATTACK_TICK, (Object)7);
                    }
                    if (this.hawk.attackProgress == 5.0f) {
                        this.hawk.doHurtTarget((Entity)target);
                        if (this.hawk.bredBuryFlag && target.getHealth() <= 1.0f) {
                            target.heal(5.0f);
                        }
                        target.addEffect(new MobEffectInstance(AMEffectRegistry.DEBILITATING_STING, target.getType().is(EntityTypeTags.ARTHROPOD) ? 2400 : 600, this.hawk.bredBuryFlag ? 1 : 0));
                        if (!this.hawk.level().isClientSide && target.getType().is(EntityTypeTags.ARTHROPOD)) {
                            AlexsMobs.sendMSGToAll(new MessageTarantulaHawkSting(this.hawk.getId(), target.getId()));
                        }
                        this.orbitCooldown = target.getType().is(EntityTypeTags.ARTHROPOD) ? 200 + EntityTarantulaHawk.this.random.nextInt(200) : 10 + EntityTarantulaHawk.this.random.nextInt(20);
                    }
                }
            }
        }

        public void stop() {
            this.orbitCooldown = 0;
            this.hawk.bredBuryFlag = false;
            this.clockwise = EntityTarantulaHawk.this.random.nextBoolean();
            this.orbitVec = null;
            if (this.hawk.getPassengers().isEmpty()) {
                this.hawk.setTarget(null);
            }
        }
    }

    private class AIBury
    extends Goal {
        private final EntityTarantulaHawk hawk;
        private BlockPos buryPos = null;
        private int digTime = 0;
        private double stageX;
        private double stageY;
        private double stageZ;

        private AIBury() {
            this.hawk = EntityTarantulaHawk.this;
        }

        public boolean canUse() {
            BlockPos pos;
            if (this.hawk.isDragging() && this.hawk.getTarget() != null && (pos = this.hawk.genSandPos(this.hawk.blockPosition())) != null) {
                this.buryPos = pos;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.hawk.isDragging() && this.digTime < 200 && this.hawk.getTarget() != null && this.buryPos != null && EntityTarantulaHawk.this.level().getBlockState(this.buryPos).is(BlockTags.SAND);
        }

        public void start() {
            this.digTime = 0;
            this.stageX = this.hawk.getX();
            this.stageY = this.hawk.getY();
            this.stageZ = this.hawk.getZ();
        }

        public void stop() {
            this.digTime = 0;
            this.hawk.setDigging(false);
            this.hawk.setDragging(false);
            this.hawk.setTarget(null);
            this.hawk.setLastHurtByMob(null);
        }

        public void tick() {
            this.hawk.setFlying(false);
            this.hawk.setDragging(true);
            LivingEntity target = this.hawk.getTarget();
            if (this.hawk.distanceToSqr(Vec3.atCenterOf((Vec3i)this.buryPos)) < 9.0 && !this.hawk.isDigging()) {
                this.hawk.setDigging(true);
                this.stageX = target.getX();
                this.stageY = target.getY();
                this.stageZ = target.getZ();
            }
            if (this.hawk.isDigging()) {
                target.noPhysics = true;
                ++this.digTime;
                this.hawk.ejectPassengers();
                target.setPos(this.stageX, this.stageY - (double)Math.min(3.0f, (float)this.digTime * 0.05f), this.stageZ);
                this.hawk.getNavigation().moveTo(this.stageX, this.stageY, this.stageZ, (double)0.85f);
            } else {
                this.hawk.getNavigation().moveTo((double)this.buryPos.getX(), (double)this.buryPos.getY(), (double)this.buryPos.getZ(), 0.5);
            }
        }
    }

    private class AIWalkIdle
    extends Goal {
        protected final EntityTarantulaHawk hawk;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;

        public AIWalkIdle() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.hawk = EntityTarantulaHawk.this;
        }

        public boolean canUse() {
            if (this.hawk.isVehicle() || this.hawk.isScared() || this.hawk.isDragging() || EntityTarantulaHawk.this.getCommand() == 1 || this.hawk.getTarget() != null && this.hawk.getTarget().isAlive() || this.hawk.isPassenger() || this.hawk.isSitting()) {
                return false;
            }
            if (this.hawk.getRandom().nextInt(30) != 0 && !this.hawk.isFlying()) {
                return false;
            }
            this.flightTarget = this.hawk.onGround() ? EntityTarantulaHawk.this.random.nextBoolean() : EntityTarantulaHawk.this.random.nextInt(5) > 0 && this.hawk.timeFlying < 200;
            Vec3 lvt_1_1_ = this.getPosition();
            if (lvt_1_1_ == null) {
                return false;
            }
            this.x = lvt_1_1_.x;
            this.y = lvt_1_1_.y;
            this.z = lvt_1_1_.z;
            return true;
        }

        public void tick() {
            if (this.flightTarget) {
                this.hawk.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else {
                this.hawk.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
            if (!this.flightTarget && EntityTarantulaHawk.this.isFlying() && this.hawk.onGround()) {
                this.hawk.setFlying(false);
            }
            if (EntityTarantulaHawk.this.isFlying() && this.hawk.onGround() && this.hawk.timeFlying > 10) {
                this.hawk.setFlying(false);
            }
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = this.hawk.position();
            if (this.hawk.isOverWater()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (this.hawk.timeFlying < 50 || this.hawk.isOverWater()) {
                    return this.hawk.getBlockInViewAway(vector3d, 0.0f);
                }
                return this.hawk.getBlockGrounding(vector3d);
            }
            return LandRandomPos.getPos((PathfinderMob)this.hawk, (int)10, (int)7);
        }

        public boolean canContinueToUse() {
            if (this.hawk.isSitting() || EntityTarantulaHawk.this.getCommand() == 1) {
                return false;
            }
            if (this.flightTarget) {
                return this.hawk.isFlying() && this.hawk.distanceToSqr(this.x, this.y, this.z) > 2.0;
            }
            return !this.hawk.getNavigation().isDone() && !this.hawk.isVehicle();
        }

        public void start() {
            if (this.flightTarget) {
                this.hawk.setFlying(true);
                this.hawk.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else {
                this.hawk.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
        }

        public void stop() {
            this.hawk.getNavigation().stop();
            super.stop();
        }
    }

    class MoveController
    extends MoveControl {
        private final Mob parentEntity;

        public MoveController() {
            super((Mob)EntityTarantulaHawk.this);
            this.parentEntity = EntityTarantulaHawk.this;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                double width;
                Vec3 vector3d = new Vec3(this.wantedX - this.parentEntity.getX(), this.wantedY - this.parentEntity.getY(), this.wantedZ - this.parentEntity.getZ());
                double d0 = vector3d.length();
                if (d0 < (width = this.parentEntity.getBoundingBox().getSize())) {
                    this.operation = MoveControl.Operation.WAIT;
                    this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().scale(0.5));
                } else {
                    float angle = (float)Math.PI / 180 * (this.parentEntity.yBodyRot + 90.0f);
                    float radius = (float)Math.sin((float)this.parentEntity.tickCount * 0.2f) * 2.0f;
                    double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
                    double extraZ = radius * Mth.cos((float)angle);
                    Vec3 vector3d1 = vector3d.scale(this.speedModifier * 0.05 / d0);
                    Vec3 strafPlus = new Vec3(extraX, 0.0, extraZ).scale(0.003 * Math.min(d0, 100.0));
                    this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(strafPlus));
                    this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(vector3d1));
                    this.parentEntity.setYRot(-((float)Mth.atan2((double)vector3d1.x, (double)vector3d1.z)) * 57.295776f);
                    if (!EntityTarantulaHawk.this.isDragging()) {
                        this.parentEntity.yBodyRot = this.parentEntity.getYRot();
                    }
                }
            }
        }
    }
}

