/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.enchantment.AMEnchantments;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityStraddleboard
extends Entity
implements PlayerRideableJumping {
    private static final EntityDataAccessor<ItemStack> ITEMSTACK = SynchedEntityData.defineId(EntityStraddleboard.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.defineId(EntityStraddleboard.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(EntityStraddleboard.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DEFAULT_COLOR = SynchedEntityData.defineId(EntityStraddleboard.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> BOARD_ROT = SynchedEntityData.defineId(EntityStraddleboard.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> REMOVE_SOON = SynchedEntityData.defineId(EntityStraddleboard.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float prevBoardRot = 0.0f;
    private boolean rocking;
    private float rockingIntensity;
    private float rockingAngle;
    private float prevRockingAngle;
    private int extinguishTimer = 0;
    private int jumpFor = 0;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private int rideForTicks = 0;
    private float boardForwards = 0.0f;
    private int removeIn;
    private Player returnToPlayer = null;

    public EntityStraddleboard(EntityType<?> p_i48580_1_, Level p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
        this.blocksBuilding = true;
    }

    public EntityStraddleboard(Level worldIn, double x, double y, double z) {
        this((EntityType)AMEntityRegistry.STRADDLEBOARD.get(), worldIn);
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public static boolean canVehicleCollide(Entity p_242378_0_, Entity entity) {
        return (entity.canBeCollidedWith() || entity.isPushable()) && !p_242378_0_.isPassengerOfSameVehicle(entity);
    }

    protected float getEyeHeight(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.height();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TIME_SINCE_HIT, (Object)0);
        builder.define(ITEMSTACK, (Object)new ItemStack((ItemLike)AMItemRegistry.STRADDLEBOARD.get()));
        builder.define(DEFAULT_COLOR, (Object)true);
        builder.define(COLOR, (Object)0);
        builder.define(BOARD_ROT, (Object)Float.valueOf(0.0f));
        builder.define(REMOVE_SOON, (Object)false);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean canCollideWith(Entity entity) {
        return EntityStraddleboard.canVehicleCollide(this, entity);
    }

    public Vec3 getRelativePortalPosition(Direction.Axis axis, BlockUtil.FoundRectangle result) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition((Vec3)super.getRelativePortalPosition(axis, result));
    }

    public double getPassengersRidingOffset() {
        return 0.5;
    }

    public float getBoardRot() {
        return ((Float)this.entityData.get(BOARD_ROT)).floatValue();
    }

    public void setBoardRot(float f) {
        this.entityData.set(BOARD_ROT, (Object)Float.valueOf(f));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.level().isClientSide && !this.isRemoved()) {
            this.entityData.set(REMOVE_SOON, (Object)true);
            return true;
        }
        return true;
    }

    private ItemStack getItemBoard() {
        return this.getItemStack();
    }

    public void push(Entity entityIn) {
        if (entityIn instanceof EntityStraddleboard) {
            if (entityIn.getBoundingBox().minY < this.getBoundingBox().maxY) {
                super.push(entityIn);
            }
        } else if (entityIn.getBoundingBox().minY <= this.getBoundingBox().minY) {
            super.push(entityIn);
        }
    }

    public boolean isRemoveLogic() {
        return (Boolean)this.entityData.get(REMOVE_SOON) != false || this.isRemoved();
    }

    public boolean canBeCollidedWith() {
        return !this.isRemoveLogic();
    }

    public boolean isPushable() {
        return !this.isRemoveLogic();
    }

    public boolean isPickable() {
        return !this.isRemoveLogic();
    }

    public boolean shouldBeSaved() {
        return !this.isRemoveLogic();
    }

    public boolean isAttackable() {
        return !this.isRemoveLogic();
    }

    public boolean isDefaultColor() {
        return (Boolean)this.entityData.get(DEFAULT_COLOR);
    }

    public void setDefaultColor(boolean bar) {
        this.entityData.set(DEFAULT_COLOR, (Object)bar);
    }

    public int getColor() {
        if (this.isDefaultColor()) {
            return 11387863;
        }
        return (Integer)this.entityData.get(COLOR);
    }

    public void setColor(int index) {
        this.entityData.set(COLOR, (Object)index);
    }

    public void tick() {
        super.tick();
        float boardRot = this.getBoardRot();
        if (this.jumpFor > 0) {
            --this.jumpFor;
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.extinguishTimer > 0) {
            --this.extinguishTimer;
        }
        if (((Boolean)this.entityData.get(REMOVE_SOON)).booleanValue()) {
            --this.removeIn;
            this.setBoardRot((float)Math.sin((double)((float)this.removeIn * 0.3f) * Math.PI) * 50.0f);
            if (this.removeIn <= 0 && !this.level().isClientSide) {
                this.removeIn = 0;
                boolean drop = this.getEnchantLevel(AMEnchantments.BOARD_RETURN) > 0 ? this.returnToPlayer != null && !this.returnToPlayer.addItem(this.getItemBoard()) : true;
                if (drop) {
                    this.spawnAtLocation(this.getItemStack().copy());
                }
                this.discard();
            }
        }
        Player controller = this.getControllingPlayer();
        if (this.level().isClientSide) {
            if (this.lSteps > 0) {
                double d5 = this.getX() + (this.lx - this.getX()) / (double)this.lSteps;
                double d6 = this.getY() + (this.ly - this.getY()) / (double)this.lSteps;
                double d7 = this.getZ() + (this.lz - this.getZ()) / (double)this.lSteps;
                this.setYRot(Mth.wrapDegrees((float)((float)this.lyr)));
                this.setXRot(this.getXRot() + (float)(this.lxr - (double)this.getXRot()) / (float)this.lSteps);
                --this.lSteps;
                this.setPos(d5, d6, d7);
                this.setRot(this.getYRot(), this.getXRot());
            } else {
                this.reapplyPosition();
                this.setRot(this.getYRot(), this.getXRot());
            }
        } else {
            this.checkInsideBlocks();
            float slowdown = this.isInWaterOrBubble() || this.onGround() ? 0.05f : 0.98f;
            this.tickMovement();
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)slowdown, (double)slowdown, (double)slowdown));
            float f2 = (float)(-((double)((float)this.getDeltaMovement().y * 0.5f) * 57.2957763671875));
            this.setXRot(Mth.approachDegrees((float)this.getXRot(), (float)f2, (float)5.0f));
            if (controller instanceof Player) {
                Player player;
                this.returnToPlayer = player = controller;
                ++this.rideForTicks;
                if (this.tickCount % 50 == 0 && this.getEnchantLevel(AMEnchantments.LAVAWAX) > 0) {
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 100, 0, true, false));
                }
                if (player.getRemainingFireTicks() > 0 && this.extinguishTimer == 0) {
                    player.clearFire();
                }
                this.setYRot(Mth.approachDegrees((float)this.getYRot(), (float)player.getYRot(), (float)6.0f));
                Vec3 deltaMovement = this.getDeltaMovement();
                if (deltaMovement.y > -0.5) {
                    this.fallDistance = 1.0f;
                }
                float slow = player.zza < 0.0f ? 0.0f : player.zza * 0.115f;
                float threshold = 3.0f;
                boolean flag = false;
                float boardRot1 = boardRot;
                if (this.yRotO - this.getYRot() > threshold) {
                    boardRot1 += 10.0f;
                    flag = true;
                }
                if (this.yRotO - this.getYRot() < -threshold) {
                    boardRot1 -= 10.0f;
                    flag = true;
                }
                if (!flag) {
                    if (boardRot1 > 0.0f) {
                        boardRot1 = Math.max(boardRot1 - 5.0f, 0.0f);
                    }
                    if (boardRot1 < 0.0f) {
                        boardRot1 = Math.min(boardRot1 + 5.0f, 0.0f);
                    }
                }
                this.setBoardRot(Mth.approachDegrees((float)boardRot, (float)Mth.clamp((float)boardRot1, (float)-25.0f, (float)25.0f), (float)5.0f));
                this.boardForwards = slow;
                if (player.isShiftKeyDown() || !this.isAlive() || ((Boolean)this.entityData.get(REMOVE_SOON)).booleanValue()) {
                    this.ejectPassengers();
                }
                if (player.isInWall()) {
                    this.ejectPassengers();
                    this.hurt(this.damageSources().generic(), 100.0f);
                }
            } else {
                this.rideForTicks = 0;
            }
        }
        this.prevBoardRot = boardRot;
    }

    private void tickMovement() {
        this.hasImpulse = true;
        float moveForwards = Math.min(this.boardForwards, 1.0f);
        float yRot = this.getYRot();
        Vec3 prev = this.getDeltaMovement();
        float gravity = this.isOnLava() ? 0.0f : (this.isInLava() ? 0.1f : -1.0f);
        float f1 = -Mth.sin((float)(yRot * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(yRot * ((float)Math.PI / 180)));
        Vec3 moveVec = new Vec3((double)f1, 0.0, (double)f2).scale((double)moveForwards);
        Vec3 vec31 = prev.scale((double)0.975f).add(moveVec);
        float jumpGravity = gravity;
        if (this.jumpFor > 0) {
            float jumpRunsOutIn = this.jumpFor < 5 ? (float)this.jumpFor / 5.0f : 1.0f;
            jumpGravity += jumpRunsOutIn + jumpRunsOutIn * 1.0f;
        }
        this.setDeltaMovement(vec31.x, jumpGravity, vec31.z);
    }

    private boolean isOnLava() {
        BlockPos ourPos = BlockPos.containing((double)this.getX(), (double)(this.getY() + (double)0.4f), (double)this.getZ());
        BlockPos underPos = this.getOnPos();
        return this.level().getFluidState(underPos).is(FluidTags.LAVA) && !this.level().getFluidState(ourPos).is(FluidTags.LAVA);
    }

    public void lerpTo(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.setDeltaMovement(this.lxd, this.lyd, this.lzd);
    }

    public void lerpMotion(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.setDeltaMovement(this.lxd, this.lyd, this.lzd);
    }

    public double getEyeY() {
        return this.getY() + (double)0.3f;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return this.getControllingPlayer();
    }

    @Nullable
    public boolean isControlledByLocalInstance() {
        return false;
    }

    @Nullable
    public Player getControllingPlayer() {
        for (Entity passenger : this.getPassengers()) {
            if (!(passenger instanceof Player)) continue;
            return (Player)passenger;
        }
        return null;
    }

    protected void addPassenger(Entity passenger) {
        super.addPassenger(passenger);
        if (this.isControlledByLocalInstance() && this.lSteps > 0) {
            this.lSteps = 0;
            this.absMoveTo(this.lx, this.ly, this.lz, (float)this.lyr, (float)this.lxr);
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> entityDataAccessor) {
        super.onSyncedDataUpdated(entityDataAccessor);
        if (REMOVE_SOON.equals(entityDataAccessor)) {
            this.removeIn = 5;
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide) {
            return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public int getTimeSinceHit() {
        return (Integer)this.entityData.get(TIME_SINCE_HIT);
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.entityData.set(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRockingAngle(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevRockingAngle, (float)this.rockingAngle);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setDefaultColor(compound.getBoolean("IsDefColor"));
        if (compound.contains("BoardStack")) {
            this.setItemStack(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)compound.getCompound("BoardStack")));
        }
        this.setColor(compound.getInt("Color"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putBoolean("IsDefColor", this.isDefaultColor());
        compound.putInt("Color", this.getColor());
        if (!this.getItemStack().isEmpty()) {
            CompoundTag stackTag = new CompoundTag();
            this.getItemStack().save((HolderLookup.Provider)this.level().registryAccess(), (Tag)stackTag);
            compound.put("BoardStack", (Tag)stackTag);
        }
    }

    public void onPlayerJump(int i) {
    }

    public boolean canJump() {
        return this.isOnLava();
    }

    public void handleStartJump(int i) {
        this.hasImpulse = true;
        if (this.canJump()) {
            float f = 0.075f + (float)this.getEnchantLevel(AMEnchantments.STRADDLE_JUMP) * 0.05f;
            this.jumpFor = 5 + (int)((float)i * f);
        }
    }

    private int getEnchantLevel(ResourceKey<Enchantment> enchantmentKey) {
        if (this.level().registryAccess().registry(Registries.ENCHANTMENT).isEmpty()) {
            return 0;
        }
        Registry registry = this.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Holder holder = registry.getHolder(enchantmentKey).orElse(null);
        if (holder == null) {
            return 0;
        }
        return EnchantmentHelper.getItemEnchantmentLevel((Holder)holder, (ItemStack)this.getItemStack());
    }

    public boolean shouldSerpentFriend() {
        return this.getEnchantLevel(AMEnchantments.SERPENTFRIEND) > 0;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity entity) {
        return new Vec3(this.getX(), this.getY() + 2.0, this.getZ());
    }

    public void handleStopJump() {
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.entityData.get(ITEMSTACK);
    }

    public void setItemStack(ItemStack item) {
        this.entityData.set(ITEMSTACK, (Object)item);
    }
}

