/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityFlyingFish;
import com.github.alexthe666.alexsmobs.entity.EntityOrca;
import com.github.alexthe666.alexsmobs.entity.IHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFindWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeaveWater;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.SealAIBask;
import com.github.alexthe666.alexsmobs.entity.ai.SealAIDiveForItems;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class EntitySeal
extends Animal
implements ISemiAquatic,
IHerdPanic,
ITargetsDroppedItems {
    private static final EntityDataAccessor<Float> SWIM_ANGLE = SynchedEntityData.defineId(EntitySeal.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> BASKING = SynchedEntityData.defineId(EntitySeal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DIGGING = SynchedEntityData.defineId(EntitySeal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ARCTIC = SynchedEntityData.defineId(EntitySeal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(EntitySeal.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BOB_TICKS = SynchedEntityData.defineId(EntitySeal.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public float prevSwimAngle;
    public float prevBaskProgress;
    public float baskProgress;
    public float prevDigProgress;
    public float digProgress;
    public float prevBobbingProgress;
    public float bobbingProgress;
    public int revengeCooldown = 0;
    public UUID feederUUID = null;
    private int baskingTimer = 0;
    private int swimTimer = -1000;
    private int ticksSinceInWater = 0;
    private boolean isLandNavigator;
    public int fishFeedings = 0;

    protected EntitySeal(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.SEAL_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.SEAL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.SEAL_HURT.get();
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MOVEMENT_SPEED, (double)0.18f);
    }

    public static boolean canSealSpawn(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        Holder holder = worldIn.getBiome(pos);
        if (!holder.is(Biomes.FROZEN_OCEAN) && !holder.is(Biomes.DEEP_FROZEN_OCEAN)) {
            boolean spawnBlock = worldIn.getBlockState(pos.below()).is(AMTagRegistry.SEAL_SPAWNS);
            return spawnBlock && worldIn.getRawBrightness(pos, 0) > 8;
        }
        return worldIn.getRawBrightness(pos, 0) > 8 && worldIn.getBlockState(pos.below()).is(Blocks.ICE);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SealAIBask(this));
        this.goalSelector.addGoal(1, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new AnimalAIFindWater((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new AnimalAILeaveWater((PathfinderMob)this));
        this.goalSelector.addGoal(4, (Goal)new AnimalAIHerdPanic((PathfinderMob)this, 1.6));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new SealAIDiveForItems(this));
        this.goalSelector.addGoal(7, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 7));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new AvoidEntityGoal((PathfinderMob)this, EntityOrca.class, 20.0f, 1.3, 1.0));
        this.goalSelector.addGoal(10, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredient.fromValues(Stream.of(new Ingredient.TagValue(AMTagRegistry.SEAL_BREEDABLES), new Ingredient.TagValue(AMTagRegistry.SEAL_OFFERINGS))), false));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, EntityFlyingFish.class, 55, true, true, null));
        this.targetSelector.addGoal(2, new CreatureAITargetItems((PathfinderMob)this, false));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigatorWide((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new AquaticMoveController((PathfinderMob)this, 1.5f);
            this.navigation = new SemiAquaticPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean prev = super.hurt(source, amount);
        if (prev) {
            int fleeTime;
            double range = 15.0;
            this.revengeCooldown = fleeTime = 100 + this.getRandom().nextInt(150);
            List list = this.level().getEntitiesOfClass(this.getClass(), this.getBoundingBox().inflate(15.0, 7.5, 15.0));
            for (EntitySeal gaz : list) {
                gaz.revengeCooldown = fleeTime;
                gaz.setBasking(false);
            }
            this.setBasking(false);
        }
        return prev;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SWIM_ANGLE, (Object)Float.valueOf(0.0f));
        builder.define(BASKING, (Object)false);
        builder.define(DIGGING, (Object)false);
        builder.define(ARCTIC, (Object)false);
        builder.define(VARIANT, (Object)0);
        builder.define(BOB_TICKS, (Object)0);
    }

    public boolean isTearsEasterEgg() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return s != null && s.toLowerCase().contains("he was");
    }

    public void calculateEntityAnimation(boolean flying) {
        float f1 = (float)Mth.length((double)(this.getX() - this.xo), (double)0.0, (double)(this.getZ() - this.zo));
        float f2 = Math.min(f1 * (this.isInWater() ? 4.0f : 48.0f), 1.0f);
        this.walkAnimation.update(f2, 0.4f);
    }

    public float getSwimAngle() {
        return ((Float)this.entityData.get(SWIM_ANGLE)).floatValue();
    }

    public void setSwimAngle(float progress) {
        this.entityData.set(SWIM_ANGLE, (Object)Float.valueOf(progress));
    }

    public void tick() {
        int bob;
        super.tick();
        this.prevBaskProgress = this.baskProgress;
        this.prevDigProgress = this.digProgress;
        this.prevBobbingProgress = this.bobbingProgress;
        this.prevSwimAngle = this.getSwimAngle();
        boolean dig = this.isDigging() && this.isInWaterOrBubble();
        float f2 = (float)(-((double)((float)this.getDeltaMovement().y) * 57.2957763671875));
        if (this.isInWater()) {
            this.setXRot(f2 * 2.5f);
            if (this.isLandNavigator) {
                this.switchNavigator(false);
            }
        } else if (!this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.isBasking()) {
            if (this.baskProgress < 5.0f) {
                this.baskProgress += 1.0f;
            }
        } else if (this.baskProgress > 0.0f) {
            this.baskProgress -= 1.0f;
        }
        if (dig) {
            if (this.digProgress < 5.0f) {
                this.digProgress += 1.0f;
            }
        } else if (this.digProgress > 0.0f) {
            this.digProgress -= 1.0f;
        }
        if (dig && this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).canOcclude()) {
            BlockPos posit = this.getBlockPosBelowThatAffectsMyMovement();
            BlockState understate = this.level().getBlockState(posit);
            for (int i = 0; i < 4 + this.random.nextInt(2); ++i) {
                double particleX = (float)posit.getX() + this.random.nextFloat();
                double particleY = (float)posit.getY() + 1.0f;
                double particleZ = (float)posit.getZ() + this.random.nextFloat();
                double motX = this.random.nextGaussian() * 0.02;
                double motY = 0.1f + this.random.nextFloat() * 0.2f;
                double motZ = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, understate), particleX, particleY, particleZ, motX, motY, motZ);
            }
        }
        if (!this.level().isClientSide) {
            if (this.isBasking()) {
                if (this.getLastHurtByMob() != null || this.isInLove() || this.revengeCooldown > 0 || this.isInWaterOrBubble() || this.getTarget() != null || this.baskingTimer > 1000 && this.getRandom().nextInt(100) == 0) {
                    this.setBasking(false);
                }
            } else if (!(this.getTarget() != null || this.isInLove() || this.getLastHurtByMob() != null || this.revengeCooldown != 0 || this.isBasking() || this.baskingTimer != 0 || this.getRandom().nextInt(15) != 0 || this.isInWaterOrBubble())) {
                this.setBasking(true);
            }
            if (this.revengeCooldown > 0) {
                --this.revengeCooldown;
            }
            if (this.revengeCooldown == 0 && this.getLastHurtByMob() != null) {
                this.setLastHurtByMob(null);
            }
            float threshold = 0.05f;
            if (this.isInWater() && this.yRotO - this.getYRot() > threshold) {
                this.setSwimAngle(this.getSwimAngle() + 2.0f);
            } else if (this.isInWater() && this.yRotO - this.getYRot() < -threshold) {
                this.setSwimAngle(this.getSwimAngle() - 2.0f);
            } else if (this.getSwimAngle() > 0.0f) {
                this.setSwimAngle(Math.max(this.getSwimAngle() - 10.0f, 0.0f));
            } else if (this.getSwimAngle() < 0.0f) {
                this.setSwimAngle(Math.min(this.getSwimAngle() + 10.0f, 0.0f));
            }
            this.setSwimAngle(Mth.clamp((float)this.getSwimAngle(), (float)-70.0f, (float)70.0f));
            this.baskingTimer = this.isBasking() ? ++this.baskingTimer : 0;
            if (this.isInWater()) {
                ++this.swimTimer;
                this.ticksSinceInWater = 0;
            } else {
                ++this.ticksSinceInWater;
                --this.swimTimer;
            }
        }
        if ((bob = ((Integer)this.entityData.get(BOB_TICKS)).intValue()) > 0) {
            --bob;
            if (this.bobbingProgress < 5.0f) {
                this.bobbingProgress += 1.0f;
            }
            this.entityData.set(BOB_TICKS, (Object)bob);
        } else {
            if (this.bobbingProgress > 0.0f) {
                this.bobbingProgress -= 1.0f;
            }
            if (!this.level().isClientSide && this.random.nextInt(300) == 0 && !this.isInWater() && this.revengeCooldown == 0) {
                bob = 20 + this.random.nextInt(20);
                this.entityData.set(BOB_TICKS, (Object)bob);
            }
        }
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public boolean isBasking() {
        return (Boolean)this.entityData.get(BASKING);
    }

    public void setBasking(boolean basking) {
        this.entityData.set(BASKING, (Object)basking);
    }

    public boolean isDigging() {
        return (Boolean)this.entityData.get(DIGGING);
    }

    public void setDigging(boolean digging) {
        this.entityData.set(DIGGING, (Object)digging);
    }

    public boolean isArctic() {
        return (Boolean)this.entityData.get(ARCTIC);
    }

    public void setArctic(boolean arctic) {
        this.entityData.set(ARCTIC, (Object)arctic);
    }

    public int getMaxAirSupply() {
        return 4800;
    }

    protected int increaseAirSupply(int currentAir) {
        return this.getMaxAirSupply();
    }

    public int getMaxHeadXRot() {
        return 1;
    }

    public int getMaxHeadYRot() {
        return 1;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData data) {
        int i;
        this.setArctic(this.isBiomeArctic((LevelAccessor)worldIn, this.blockPosition()));
        if (data instanceof SealGroupData) {
            i = ((SealGroupData)((Object)data)).variant;
        } else {
            i = this.random.nextInt(2);
            data = new SealGroupData(i);
        }
        this.setVariant(i);
        this.setAirSupply(this.getMaxAirSupply());
        this.setXRot(0.0f);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, data);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Arctic", this.isArctic());
        compound.putBoolean("Basking", this.isBasking());
        compound.putInt("BaskingTimer", this.baskingTimer);
        compound.putInt("SwimTimer", this.swimTimer);
        compound.putInt("FishFeedings", this.fishFeedings);
        compound.putInt("Variant", this.getVariant());
        if (this.feederUUID != null) {
            compound.putUUID("FeederUUID", this.feederUUID);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setArctic(compound.getBoolean("Arctic"));
        this.setBasking(compound.getBoolean("Basking"));
        this.baskingTimer = compound.getInt("BaskingTimer");
        this.swimTimer = compound.getInt("SwimTimer");
        this.fishFeedings = compound.getInt("FishFeedings");
        if (compound.hasUUID("FeederUUID")) {
            this.feederUUID = compound.getUUID("FeederUUID");
        }
        this.setVariant(compound.getInt("Variant"));
    }

    private boolean isBiomeArctic(LevelAccessor worldIn, BlockPos position) {
        return worldIn.getBiome(position).is(AMTagRegistry.SPAWNS_WHITE_SEALS);
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
            if (this.isDigging()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.02, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.SEAL_BREEDABLES);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntitySeal seal = (EntitySeal)((EntityType)AMEntityRegistry.SEAL.get()).create((Level)serverWorld);
        seal.setArctic(this.isBiomeArctic((LevelAccessor)serverWorld, this.blockPosition()));
        return seal;
    }

    @Override
    public boolean shouldEnterWater() {
        return !this.shouldLeaveWater() && this.swimTimer <= -1000;
    }

    @Override
    public boolean shouldLeaveWater() {
        if (!this.getPassengers().isEmpty()) {
            return false;
        }
        if (this.getTarget() != null && !this.getTarget().isInWater()) {
            return true;
        }
        return this.swimTimer > 600;
    }

    @Override
    public boolean shouldStopMoving() {
        return this.isBasking();
    }

    @Override
    public int getWaterSearchRange() {
        return 32;
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.is(AMTagRegistry.SEAL_OFFERINGS) || stack.is(AMTagRegistry.SEAL_BREEDABLES);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        if (e.getItem().is(AMTagRegistry.SEAL_OFFERINGS)) {
            ++this.fishFeedings;
            this.gameEvent((Holder)GameEvent.EAT);
            this.playSound(SoundEvents.CAT_EAT, this.getSoundVolume(), this.getVoicePitch());
            Entity itemThrower = e.getOwner();
            if (this.fishFeedings >= 3) {
                if (itemThrower != null) {
                    this.feederUUID = itemThrower.getUUID();
                }
                this.fishFeedings = 0;
            }
        } else {
            this.feederUUID = null;
        }
        this.heal(10.0f);
    }

    @Override
    public void onPanic() {
    }

    @Override
    public boolean canPanic() {
        return !this.isBasking();
    }

    public static class SealGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final int variant;

        SealGroupData(int variant) {
            super(true);
            this.variant = variant;
        }
    }
}

