/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.SeagullAIRevealTreasure;
import com.github.alexthe666.alexsmobs.entity.ai.SeagullAIStealFromPlayers;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntitySeagull
extends Animal
implements ITargetsDroppedItems {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(EntitySeagull.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> FLIGHT_LOOK_YAW = SynchedEntityData.defineId(EntitySeagull.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.defineId(EntitySeagull.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(EntitySeagull.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<BlockPos>> TREASURE_POS = SynchedEntityData.defineId(EntitySeagull.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    public float prevFlyProgress;
    public float flyProgress;
    public float prevFlapAmount;
    public float flapAmount;
    public boolean aiItemFlag = false;
    public float attackProgress;
    public float prevAttackProgress;
    public float sitProgress;
    public float prevSitProgress;
    public int stealCooldown = this.random.nextInt(2500);
    private boolean isLandNavigator;
    private int timeFlying;
    private BlockPos orbitPos = null;
    private double orbitDist = 5.0;
    private boolean orbitClockwise = false;
    private boolean fallFlag = false;
    private int flightLookCooldown = 0;
    private float targetFlightLookYaw;
    private int heldItemTime = 0;
    public int treasureSitTime;
    public UUID feederUUID = null;

    protected EntitySeagull(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
        this.switchNavigator(false);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.SEAGULL_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.SEAGULL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.SEAGULL_HURT.get();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Flying", this.isFlying());
        compound.putBoolean("Sitting", this.isSitting());
        compound.putInt("StealCooldown", this.stealCooldown);
        compound.putInt("TreasureSitTime", this.treasureSitTime);
        if (this.feederUUID != null) {
            compound.putUUID("FeederUUID", this.feederUUID);
        }
        if (this.getTreasurePos() != null) {
            compound.putInt("TresX", this.getTreasurePos().getX());
            compound.putInt("TresY", this.getTreasurePos().getY());
            compound.putInt("TresZ", this.getTreasurePos().getZ());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFlying(compound.getBoolean("Flying"));
        this.setSitting(compound.getBoolean("Sitting"));
        this.stealCooldown = compound.getInt("StealCooldown");
        this.treasureSitTime = compound.getInt("TreasureSitTime");
        if (compound.hasUUID("FeederUUID")) {
            this.feederUUID = compound.getUUID("FeederUUID");
        }
        if (compound.contains("TresX") && compound.contains("TresY") && compound.contains("TresZ")) {
            this.setTreasurePos(new BlockPos(compound.getInt("TresX"), compound.getInt("TresY"), compound.getInt("TresZ")));
        }
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new SeagullAIRevealTreasure(this));
        this.targetSelector.addGoal(2, (Goal)new SeagullAIStealFromPlayers(this));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.fromValues(Stream.of(new Ingredient.TagValue(AMTagRegistry.SEAGULL_BREEDABLES), new Ingredient.TagValue(AMTagRegistry.SEAGULL_OFFERINGS))), false){

            public boolean canUse() {
                return !EntitySeagull.this.aiItemFlag && super.canUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new AIWanderIdle());
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, PathfinderMob.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new AIScatter());
        this.targetSelector.addGoal(1, (Goal)new AITargetItems((PathfinderMob)this, false, false, 15, 16));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.SEAGULL_BREEDABLES);
    }

    public static boolean canSeagullSpawn(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return worldIn.getRawBrightness(pos, 0) > 8 && worldIn.getFluidState(pos.below()).isEmpty();
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.seagullSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigation((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new MoveHelper(this);
            this.navigation = new DirectPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLYING, (Object)false);
        builder.define(SITTING, (Object)false);
        builder.define(ATTACK_TICK, (Object)0);
        builder.define(TREASURE_POS, Optional.empty());
        builder.define(FLIGHT_LOOK_YAW, (Object)Float.valueOf(0.0f));
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    @Override
    public void setFlying(boolean flying) {
        if (flying && this.isBaby()) {
            flying = false;
        }
        this.entityData.set(FLYING, (Object)flying);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.entityData.set(SITTING, (Object)sitting);
    }

    public float getFlightLookYaw() {
        return ((Float)this.entityData.get(FLIGHT_LOOK_YAW)).floatValue();
    }

    public void setFlightLookYaw(float yaw) {
        this.entityData.set(FLIGHT_LOOK_YAW, (Object)Float.valueOf(yaw));
    }

    public BlockPos getTreasurePos() {
        return ((Optional)this.entityData.get(TREASURE_POS)).orElse(null);
    }

    public void setTreasurePos(BlockPos pos) {
        this.entityData.set(TREASURE_POS, Optional.ofNullable(pos));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        boolean prev = super.hurt(source, amount);
        if (prev) {
            this.setSitting(false);
            if (!this.getMainHandItem().isEmpty()) {
                this.spawnAtLocation(this.getMainHandItem());
                this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                this.stealCooldown = 1500 + this.random.nextInt(1500);
            }
            this.feederUUID = null;
            this.treasureSitTime = 0;
        }
        return prev;
    }

    public void tick() {
        super.tick();
        this.prevFlyProgress = this.flyProgress;
        this.prevFlapAmount = this.flapAmount;
        this.prevAttackProgress = this.attackProgress;
        this.prevSitProgress = this.sitProgress;
        float yMot = (float)(-((double)((float)this.getDeltaMovement().y) * 57.2957763671875));
        float absYaw = Math.abs(this.getYRot() - this.yRotO);
        boolean flying = this.isFlying();
        boolean sitting = this.isSitting();
        if (flying) {
            if (this.flyProgress < 5.0f) {
                this.flyProgress += 1.0f;
            }
        } else if (this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (sitting) {
            if (this.sitProgress < 5.0f) {
                this.sitProgress += 1.0f;
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        this.flapAmount = absYaw > 8.0f ? Math.min(1.0f, this.flapAmount + 0.1f) : (yMot < 0.0f ? Math.min(-yMot * 0.2f, 1.0f) : (this.flapAmount > 0.0f ? (this.flapAmount -= Math.min(this.flapAmount, 0.05f)) : 0.0f));
        if ((Integer)this.entityData.get(ATTACK_TICK) > 0) {
            this.entityData.set(ATTACK_TICK, (Object)((Integer)this.entityData.get(ATTACK_TICK) - 1));
            if (this.attackProgress < 5.0f) {
                this.attackProgress += 1.0f;
            }
        } else if (this.attackProgress > 0.0f) {
            this.attackProgress -= 1.0f;
        }
        if (!this.level().isClientSide) {
            if (this.isFlying()) {
                float lookYawDist = Math.abs(this.getFlightLookYaw() - this.targetFlightLookYaw);
                if (this.flightLookCooldown > 0) {
                    --this.flightLookCooldown;
                }
                if (this.flightLookCooldown == 0 && this.random.nextInt(4) == 0 && lookYawDist < 0.5f) {
                    this.targetFlightLookYaw = Mth.clamp((float)(this.random.nextFloat() * 120.0f - 60.0f), (float)-60.0f, (float)60.0f);
                    this.flightLookCooldown = 3 + this.random.nextInt(15);
                }
                if (this.getFlightLookYaw() < this.targetFlightLookYaw && lookYawDist > 0.5f) {
                    this.setFlightLookYaw(this.getFlightLookYaw() + Math.min(lookYawDist, 4.0f));
                }
                if (this.getFlightLookYaw() > this.targetFlightLookYaw && lookYawDist > 0.5f) {
                    this.setFlightLookYaw(this.getFlightLookYaw() - Math.min(lookYawDist, 4.0f));
                }
                if (this.onGround() && !this.isInWaterOrBubble() && this.timeFlying > 30) {
                    this.setFlying(false);
                }
                ++this.timeFlying;
                this.setNoGravity(true);
                if (this.isPassenger() || this.isInLove()) {
                    this.setFlying(false);
                }
            } else {
                this.fallFlag = false;
                this.timeFlying = 0;
                this.setNoGravity(false);
            }
            if (this.isFlying() && this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (!this.isFlying() && !this.isLandNavigator) {
                this.switchNavigator(true);
            }
        }
        if (!this.getMainHandItem().isEmpty()) {
            ++this.heldItemTime;
            if (this.heldItemTime > 200 && this.canTargetItem(this.getMainHandItem())) {
                this.heldItemTime = 0;
                this.heal(4.0f);
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
                if (this.getMainHandItem().hasCraftingRemainingItem()) {
                    this.spawnAtLocation(this.getMainHandItem().getCraftingRemainingItem());
                }
                this.eatItemEffect(this.getMainHandItem());
                this.getMainHandItem().shrink(1);
            }
        } else {
            this.heldItemTime = 0;
        }
        if (this.stealCooldown > 0) {
            --this.stealCooldown;
        }
        if (this.treasureSitTime > 0) {
            --this.treasureSitTime;
        }
        if (this.isSitting() && this.isInWaterOrBubble()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)0.02f, 0.0));
        }
    }

    public void eatItem() {
        this.heldItemTime = 200;
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.has(DataComponents.FOOD) && !this.isSitting();
    }

    private void eatItemEffect(ItemStack heldItemMainhand) {
        for (int i = 0; i < 2 + this.random.nextInt(2); ++i) {
            double d2 = this.random.nextGaussian() * 0.02;
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            float radius = this.getBbWidth() * 0.65f;
            float angle = (float)Math.PI / 180 * this.yBodyRot;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            ItemParticleOption data = new ItemParticleOption(ParticleTypes.ITEM, heldItemMainhand);
            if (heldItemMainhand.getItem() instanceof BlockItem) {
                data = new BlockParticleOption(ParticleTypes.BLOCK, ((BlockItem)heldItemMainhand.getItem()).getBlock().defaultBlockState());
            }
            this.level().addParticle((ParticleOptions)data, this.getX() + extraX, this.getY() + (double)(this.getBbHeight() * 0.6f), this.getZ() + extraZ, d0, d1, d2);
        }
    }

    public void setDataFromTreasureMap(Player player) {
        boolean flag = false;
        for (ItemStack map : player.getHandSlots()) {
            if (map.getItem() != Items.FILLED_MAP && map.getItem() != Items.MAP) continue;
        }
        if (flag) {
            this.feederUUID = player.getUUID();
            this.treasureSitTime = 300;
            this.stealCooldown = 1500 + this.random.nextInt(1500);
        }
    }

    public void travel(Vec3 vec3d) {
        if (this.isSitting()) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            vec3d = Vec3.ZERO;
        }
        super.travel(vec3d);
    }

    public boolean isWingull() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return s != null && s.equalsIgnoreCase("wingull");
    }

    @Override
    public void onGetItem(ItemEntity e) {
        Player player;
        ItemStack duplicate = e.getItem().copy();
        duplicate.setCount(1);
        if (!this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.level().isClientSide) {
            this.spawnAtLocation(this.getItemInHand(InteractionHand.MAIN_HAND), 0.0f);
        }
        this.stealCooldown += 600 + this.random.nextInt(1200);
        Entity thrower = e.getOwner();
        if (thrower != null && e.getItem().is(AMTagRegistry.SEAGULL_OFFERINGS) && (player = this.level().getPlayerByUUID(thrower.getUUID())) != null) {
            this.setDataFromTreasureMap(player);
            this.feederUUID = thrower.getUUID();
        }
        this.setFlying(true);
        this.setItemInHand(InteractionHand.MAIN_HAND, duplicate);
    }

    public Vec3 getBlockInViewAway(Vec3 fleePos, float radiusAdd) {
        float radius = 5.0f + radiusAdd + (float)this.getRandom().nextInt(5);
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.x() + extraX), 0, (int)(fleePos.z() + extraZ));
        BlockPos ground = this.getSeagullGround(radialPos);
        int distFromGround = (int)this.getY() - ground.getY();
        int flightHeight = 8 + this.getRandom().nextInt(4);
        BlockPos newPos = ground.above(distFromGround > 3 ? flightHeight : this.getRandom().nextInt(4) + 8);
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos)) && this.distanceToSqr(Vec3.atCenterOf((Vec3i)newPos)) > 1.0) {
            return Vec3.atCenterOf((Vec3i)newPos);
        }
        return null;
    }

    public BlockPos getSeagullGround(BlockPos in) {
        BlockPos position = new BlockPos(in.getX(), (int)this.getY(), in.getZ());
        while (position.getY() < 320 && !this.level().getFluidState(position).isEmpty()) {
            position = position.above();
        }
        while (position.getY() > -64 && !this.level().getBlockState(position).isSolid() && this.level().getFluidState(position).isEmpty()) {
            position = position.below();
        }
        return position;
    }

    public Vec3 getBlockGrounding(Vec3 fleePos) {
        float radius = 10 + this.getRandom().nextInt(15);
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = AMBlockPos.fromCoords(fleePos.x() + extraX, this.getY(), fleePos.z() + extraZ);
        BlockPos ground = this.getSeagullGround(radialPos);
        if (ground.getY() == 0) {
            return this.position();
        }
        ground = this.blockPosition();
        while (ground.getY() > -62 && !this.level().getBlockState(ground).isSolid()) {
            ground = ground.below();
        }
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)ground.above()))) {
            return Vec3.atCenterOf((Vec3i)ground);
        }
        return null;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    private Vec3 getOrbitVec(Vec3 vector3d, float gatheringCircleDist) {
        float angle = (float)Math.PI / 180 * (float)this.orbitDist * (float)(this.orbitClockwise ? -this.tickCount : this.tickCount);
        double extraX = gatheringCircleDist * Mth.sin((float)angle);
        double extraZ = gatheringCircleDist * Mth.cos((float)angle);
        if (this.orbitPos != null) {
            Vec3 pos = new Vec3((double)this.orbitPos.getX() + extraX, (double)(this.orbitPos.getY() + this.random.nextInt(2)), (double)this.orbitPos.getZ() + extraZ);
            if (this.level().isEmptyBlock(AMBlockPos.fromVec3(pos))) {
                return pos;
            }
        }
        return null;
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.blockPosition();
        while (position.getY() > -64 && this.level().isEmptyBlock(position)) {
            position = position.below();
        }
        return !this.level().getFluidState(position).isEmpty() || position.getY() <= -64;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        InteractionResult type = super.mobInteract(player, hand);
        if (!this.getMainHandItem().isEmpty() && type != InteractionResult.SUCCESS) {
            this.spawnAtLocation(this.getMainHandItem().copy());
            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            this.stealCooldown = 1500 + this.random.nextInt(1500);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return (AgeableMob)((EntityType)AMEntityRegistry.SEAGULL.get()).create((Level)serverWorld);
    }

    @Override
    public void peck() {
        this.entityData.set(ATTACK_TICK, (Object)7);
    }

    private class AIWanderIdle
    extends Goal {
        protected final EntitySeagull eagle;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;
        private int orbitResetCooldown = 0;
        private int maxOrbitTime = 360;
        private int orbitTime = 0;

        public AIWanderIdle() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.eagle = EntitySeagull.this;
        }

        public boolean canUse() {
            if (this.orbitResetCooldown < 0) {
                ++this.orbitResetCooldown;
            }
            if (this.eagle.getTarget() != null && this.eagle.getTarget().isAlive() && !this.eagle.isVehicle() || this.eagle.isSitting() || this.eagle.isPassenger()) {
                return false;
            }
            if (this.eagle.getRandom().nextInt(20) != 0 && !this.eagle.isFlying() || this.eagle.aiItemFlag) {
                return false;
            }
            if (this.eagle.isBaby()) {
                this.flightTarget = false;
            } else if (this.eagle.isInWaterOrBubble()) {
                this.flightTarget = true;
            } else if (this.eagle.onGround()) {
                this.flightTarget = EntitySeagull.this.random.nextInt(10) == 0;
            } else {
                if (this.orbitResetCooldown == 0 && EntitySeagull.this.random.nextInt(6) == 0) {
                    this.orbitResetCooldown = 100 + EntitySeagull.this.random.nextInt(300);
                    this.eagle.orbitPos = this.eagle.blockPosition();
                    this.eagle.orbitDist = 4 + EntitySeagull.this.random.nextInt(5);
                    this.eagle.orbitClockwise = EntitySeagull.this.random.nextBoolean();
                    this.orbitTime = 0;
                    this.maxOrbitTime = (int)(180.0f + 360.0f * EntitySeagull.this.random.nextFloat());
                }
                this.flightTarget = EntitySeagull.this.random.nextInt(5) != 0 && this.eagle.timeFlying < 400;
            }
            Vec3 lvt_1_1_ = this.getPosition();
            if (lvt_1_1_ == null) {
                return false;
            }
            this.x = lvt_1_1_.x;
            this.y = lvt_1_1_.y;
            this.z = lvt_1_1_.z;
            return true;
        }

        public void tick() {
            if (this.orbitResetCooldown > 0) {
                --this.orbitResetCooldown;
            }
            if (this.orbitResetCooldown < 0) {
                ++this.orbitResetCooldown;
            }
            if (this.orbitResetCooldown > 0 && this.eagle.orbitPos != null) {
                if (this.orbitTime < this.maxOrbitTime && !this.eagle.isInWaterOrBubble()) {
                    ++this.orbitTime;
                } else {
                    this.orbitTime = 0;
                    this.eagle.orbitPos = null;
                    this.orbitResetCooldown = -400 - EntitySeagull.this.random.nextInt(400);
                }
            }
            if (this.eagle.horizontalCollision && !this.eagle.onGround()) {
                this.stop();
            }
            if (this.flightTarget) {
                this.eagle.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else if (!this.eagle.isFlying() || this.eagle.onGround()) {
                this.eagle.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
            if (!this.flightTarget && EntitySeagull.this.isFlying()) {
                this.eagle.fallFlag = true;
                if (this.eagle.onGround()) {
                    this.eagle.setFlying(false);
                    this.orbitTime = 0;
                    this.eagle.orbitPos = null;
                    this.orbitResetCooldown = -400 - EntitySeagull.this.random.nextInt(400);
                }
            }
            if (EntitySeagull.this.isFlying() && (!EntitySeagull.this.level().isEmptyBlock(this.eagle.getBlockPosBelowThatAffectsMyMovement()) || this.eagle.onGround()) && !this.eagle.isInWaterOrBubble() && this.eagle.timeFlying > 30) {
                this.eagle.setFlying(false);
                this.orbitTime = 0;
                this.eagle.orbitPos = null;
                this.orbitResetCooldown = -400 - EntitySeagull.this.random.nextInt(400);
            }
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = this.eagle.position();
            if (this.orbitResetCooldown > 0 && this.eagle.orbitPos != null) {
                return this.eagle.getOrbitVec(vector3d, 4 + EntitySeagull.this.random.nextInt(4));
            }
            if (this.eagle.isVehicle() || this.eagle.isOverWaterOrVoid()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (this.eagle.timeFlying < 340 || this.eagle.isVehicle() || this.eagle.isOverWaterOrVoid()) {
                    return this.eagle.getBlockInViewAway(vector3d, 0.0f);
                }
                return this.eagle.getBlockGrounding(vector3d);
            }
            return LandRandomPos.getPos((PathfinderMob)this.eagle, (int)10, (int)7);
        }

        public boolean canContinueToUse() {
            if (this.flightTarget) {
                return this.eagle.isFlying() && this.eagle.distanceToSqr(this.x, this.y, this.z) > 5.0;
            }
            return !this.eagle.getNavigation().isDone() && !this.eagle.isVehicle();
        }

        public void start() {
            if (this.flightTarget) {
                this.eagle.setFlying(true);
                this.eagle.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else {
                this.eagle.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
        }

        public void stop() {
            this.eagle.getNavigation().stop();
            super.stop();
        }
    }

    private class AIScatter
    extends Goal {
        protected final Sorter theNearestAttackableTargetSorter;
        protected final com.google.common.base.Predicate<? super Entity> targetEntitySelector;
        protected int executionChance = 8;
        protected boolean mustUpdate;
        private Entity targetEntity;
        private Vec3 flightTarget = null;
        private int cooldown = 0;

        AIScatter() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.theNearestAttackableTargetSorter = new Sorter((Entity)EntitySeagull.this);
            this.targetEntitySelector = new com.google.common.base.Predicate<Entity>(){

                public boolean apply(@Nullable Entity e) {
                    return e.isAlive() && e.getType().is(AMTagRegistry.SCATTERS_CROWS) || e instanceof Player && !((Player)e).isCreative();
                }
            };
        }

        public boolean canUse() {
            List list;
            if (EntitySeagull.this.isPassenger() || EntitySeagull.this.isSitting() || EntitySeagull.this.aiItemFlag || EntitySeagull.this.isVehicle()) {
                return false;
            }
            if (!this.mustUpdate) {
                long worldTime = EntitySeagull.this.level().getGameTime() % 10L;
                if (EntitySeagull.this.getNoActionTime() >= 100 && worldTime != 0L) {
                    return false;
                }
                if (EntitySeagull.this.getRandom().nextInt(this.executionChance) != 0 && worldTime != 0L) {
                    return false;
                }
            }
            if ((list = EntitySeagull.this.level().getEntitiesOfClass(Entity.class, this.getTargetableArea(this.getTargetDistance()), this.targetEntitySelector)).isEmpty()) {
                return false;
            }
            Collections.sort(list, this.theNearestAttackableTargetSorter);
            this.targetEntity = (Entity)list.get(0);
            this.mustUpdate = false;
            return true;
        }

        public boolean canContinueToUse() {
            return this.targetEntity != null;
        }

        public void stop() {
            this.flightTarget = null;
            this.targetEntity = null;
        }

        public void tick() {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.flightTarget != null) {
                EntitySeagull.this.setFlying(true);
                EntitySeagull.this.getMoveControl().setWantedPosition(this.flightTarget.x, this.flightTarget.y, this.flightTarget.z, 1.0);
                if (this.cooldown == 0 && EntitySeagull.this.isTargetBlocked(this.flightTarget)) {
                    this.cooldown = 30;
                    this.flightTarget = null;
                }
            }
            if (this.targetEntity != null) {
                Vec3 vec;
                if ((EntitySeagull.this.onGround() || this.flightTarget == null || this.flightTarget != null && EntitySeagull.this.distanceToSqr(this.flightTarget) < 3.0) && (vec = EntitySeagull.this.getBlockInViewAway(this.targetEntity.position(), 0.0f)) != null && vec.y() > EntitySeagull.this.getY()) {
                    this.flightTarget = vec;
                }
                if (EntitySeagull.this.distanceTo(this.targetEntity) > 20.0f) {
                    this.stop();
                }
            }
        }

        protected double getTargetDistance() {
            return 4.0;
        }

        protected AABB getTargetableArea(double targetDistance) {
            Vec3 renderCenter = new Vec3(EntitySeagull.this.getX(), EntitySeagull.this.getY() + 0.5, EntitySeagull.this.getZ());
            AABB aabb = new AABB(-2.0, -2.0, -2.0, 2.0, 2.0, 2.0);
            return aabb.move(renderCenter);
        }

        public record Sorter(Entity theEntity) implements Comparator<Entity>
        {
            @Override
            public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                double d0 = this.theEntity.distanceToSqr(p_compare_1_);
                double d1 = this.theEntity.distanceToSqr(p_compare_2_);
                return Double.compare(d0, d1);
            }
        }
    }

    private static class AITargetItems
    extends CreatureAITargetItems {
        public AITargetItems(PathfinderMob creature, boolean checkSight, boolean onlyNearby, int tickThreshold, int radius) {
            super(creature, checkSight, onlyNearby, tickThreshold, radius);
            this.executionChance = 1;
        }

        @Override
        public void stop() {
            super.stop();
            ((EntitySeagull)this.mob).aiItemFlag = false;
        }

        @Override
        public boolean canUse() {
            return super.canUse() && !((EntitySeagull)this.mob).isSitting() && (this.mob.getTarget() == null || !this.mob.getTarget().isAlive());
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && !((EntitySeagull)this.mob).isSitting() && (this.mob.getTarget() == null || !this.mob.getTarget().isAlive());
        }

        @Override
        protected void moveTo() {
            EntitySeagull crow = (EntitySeagull)this.mob;
            if (this.targetEntity != null) {
                crow.aiItemFlag = true;
                if (this.mob.distanceTo((Entity)this.targetEntity) < 2.0f) {
                    crow.getMoveControl().setWantedPosition(this.targetEntity.getX(), this.targetEntity.getY(), this.targetEntity.getZ(), 1.5);
                    crow.peck();
                }
                if (this.mob.distanceTo((Entity)this.targetEntity) > 8.0f || crow.isFlying()) {
                    crow.setFlying(true);
                    float f = (float)(crow.getX() - this.targetEntity.getX());
                    float f2 = (float)(crow.getZ() - this.targetEntity.getZ());
                    if (!crow.hasLineOfSight((Entity)this.targetEntity)) {
                        crow.getMoveControl().setWantedPosition(this.targetEntity.getX(), 1.0 + crow.getY(), this.targetEntity.getZ(), 1.5);
                    } else {
                        float f1 = 1.8f;
                        float xzDist = Mth.sqrt((float)(f * f + f2 * f2));
                        if (xzDist < 5.0f) {
                            f1 = 0.0f;
                        }
                        crow.getMoveControl().setWantedPosition(this.targetEntity.getX(), (double)f1 + this.targetEntity.getY(), this.targetEntity.getZ(), 1.5);
                    }
                } else {
                    this.mob.getNavigation().moveTo(this.targetEntity.getX(), this.targetEntity.getY(), this.targetEntity.getZ(), 1.5);
                }
            }
        }

        @Override
        public void tick() {
            super.tick();
            this.moveTo();
        }
    }

    static class MoveHelper
    extends MoveControl {
        private final EntitySeagull parentEntity;

        public MoveHelper(EntitySeagull bird) {
            super((Mob)bird);
            this.parentEntity = bird;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.wantedX - this.parentEntity.getX(), this.wantedY - this.parentEntity.getY(), this.wantedZ - this.parentEntity.getZ());
                double d5 = vector3d.length();
                if (d5 < 0.3) {
                    this.operation = MoveControl.Operation.WAIT;
                    this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().scale(0.5));
                } else {
                    this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(vector3d.scale(this.speedModifier * 0.03 / d5)));
                    Vec3 vector3d1 = this.parentEntity.getDeltaMovement();
                    this.parentEntity.setYRot(-((float)Mth.atan2((double)vector3d1.x, (double)vector3d1.z)) * 57.295776f);
                    this.parentEntity.yBodyRot = this.parentEntity.getYRot();
                }
            }
        }
    }
}

