/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityRattlesnake;
import com.github.alexthe666.alexsmobs.entity.IDancingMob;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.alexsmobs.network.MessageStartDancing;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class EntityRainFrog
extends Animal
implements ITargetsDroppedItems,
IDancingMob {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(EntityRainFrog.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STANCE_TIME = SynchedEntityData.defineId(EntityRainFrog.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ATTACK_TIME = SynchedEntityData.defineId(EntityRainFrog.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DANCE_TIME = SynchedEntityData.defineId(EntityRainFrog.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> BURROWED = SynchedEntityData.defineId(EntityRainFrog.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DISTURBED = SynchedEntityData.defineId(EntityRainFrog.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float burrowProgress;
    public float prevBurrowProgress;
    public float danceProgress;
    public float prevDanceProgress;
    public float attackProgress;
    public float prevAttackProgress;
    public float stanceProgress;
    public float prevStanceProgress;
    private int burrowCooldown = 0;
    private int weatherCooldown = 0;
    private boolean isJukeboxing;
    private BlockPos jukeboxPosition;

    protected EntityRainFrog(EntityType<? extends Animal> rainFrog, Level lvl) {
        super(rainFrog, lvl);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(AMTagRegistry.RAIN_FROG_BREEDABLES), false));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, EntityRattlesnake.class, 9.0f, 1.3, 1.0));
        this.goalSelector.addGoal(5, (Goal)new AIBurrow());
        this.goalSelector.addGoal(6, (Goal)new AnimalAIWanderRanged((PathfinderMob)this, 20, 1.0, 10, 7));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, new CreatureAITargetItems((PathfinderMob)this, false));
    }

    public static boolean canRainFrogSpawn(EntityType animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        boolean spawnBlock = worldIn.getBlockState(pos.below()).is(AMTagRegistry.RAIN_FROG_SPAWNS);
        return spawnBlock && worldIn.getLevelData() != null && (worldIn.getLevelData().isThundering() || worldIn.getLevelData().isRaining());
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.rainFrogSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public boolean isBurrowed() {
        return (Boolean)this.entityData.get(BURROWED);
    }

    public void setBurrowed(boolean burrowed) {
        this.entityData.set(BURROWED, (Object)burrowed);
    }

    public boolean isDisturbed() {
        return (Boolean)this.entityData.get(DISTURBED);
    }

    public void setDisturbed(boolean burrowed) {
        this.entityData.set(DISTURBED, (Object)burrowed);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public int getStanceTime() {
        return (Integer)this.entityData.get(STANCE_TIME);
    }

    public void setStanceTime(int stanceTime) {
        this.entityData.set(STANCE_TIME, (Object)stanceTime);
    }

    public int getAttackTime() {
        return (Integer)this.entityData.get(ATTACK_TIME);
    }

    public void setAttackTime(int attackTime) {
        this.entityData.set(ATTACK_TIME, (Object)attackTime);
    }

    public int getDanceTime() {
        return (Integer)this.entityData.get(DANCE_TIME);
    }

    public void setDanceTime(int danceTime) {
        this.entityData.set(DANCE_TIME, (Object)danceTime);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.RAIN_FROG_BREEDABLES);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        EntityRainFrog frog = (EntityRainFrog)((EntityType)AMEntityRegistry.RAIN_FROG.get()).create((Level)p_241840_1_);
        frog.setVariant(this.getVariant());
        frog.setDisturbed(true);
        return frog;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
        builder.define(STANCE_TIME, (Object)0);
        builder.define(ATTACK_TIME, (Object)0);
        builder.define(DANCE_TIME, (Object)0);
        builder.define(BURROWED, (Object)false);
        builder.define(DISTURBED, (Object)false);
    }

    public void tick() {
        boolean dancing;
        super.tick();
        this.prevBurrowProgress = this.burrowProgress;
        this.prevDanceProgress = this.danceProgress;
        this.prevAttackProgress = this.attackProgress;
        this.prevStanceProgress = this.stanceProgress;
        if (this.isBurrowed()) {
            if (this.burrowProgress < 5.0f) {
                this.burrowProgress += 0.5f;
            }
        } else if (this.burrowProgress > 0.0f) {
            this.burrowProgress -= 0.5f;
        }
        if (this.burrowCooldown > 0) {
            --this.burrowCooldown;
        }
        if (this.getStanceTime() > 0) {
            this.setStanceTime(this.getStanceTime() - 1);
            if (this.stanceProgress < 5.0f) {
                this.stanceProgress += 1.0f;
            }
        } else if (this.stanceProgress > 0.0f) {
            this.stanceProgress -= 1.0f;
        }
        if (this.getAttackTime() > 0) {
            this.setAttackTime(this.getAttackTime() - 1);
            if (this.attackProgress < 5.0f) {
                this.attackProgress += 2.5f;
            }
        } else if (this.attackProgress > 0.0f) {
            this.attackProgress -= 0.5f;
        }
        boolean bl = dancing = this.getDanceTime() > 0 || this.isJukeboxing;
        if (dancing) {
            if (this.danceProgress < 5.0f) {
                this.danceProgress += 1.0f;
            }
        } else if (this.danceProgress > 0.0f) {
            this.danceProgress -= 1.0f;
        }
        if (this.getDanceTime() > 0) {
            this.setBurrowed(false);
            this.setDanceTime(this.getDanceTime() - 1);
            if (this.getDanceTime() == 1 && this.weatherCooldown <= 0 && this.level().getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE)) {
                this.changeWeather();
            }
        }
        if (this.weatherCooldown > 0) {
            --this.weatherCooldown;
        }
        if (this.jukeboxPosition == null || !this.jukeboxPosition.closerToCenterThan((Position)this.position(), 15.0) || !this.level().getBlockState(this.jukeboxPosition).is(Blocks.JUKEBOX)) {
            this.isJukeboxing = false;
            this.setDanceTime(0);
            this.jukeboxPosition = null;
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean prev = super.hurt(source, amount);
        if (prev && source.getDirectEntity() instanceof LivingEntity) {
            if (this.getStanceTime() <= 0) {
                this.setStanceTime(30 + this.random.nextInt(20));
            }
            this.setBurrowed(false);
        }
        return prev;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.requiresCustomPersistence();
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.isDisturbed();
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypes.IN_WALL) || super.isInvulnerableTo(source);
    }

    public boolean isSleeping() {
        return this.isBurrowed();
    }

    public void calculateEntityAnimation(LivingEntity mob, boolean flying) {
        float f1 = (float)Mth.length((double)(this.getX() - this.xo), (double)0.0, (double)(this.getZ() - this.zo));
        float f2 = Math.min(f1 * 128.0f, 1.0f);
        this.walkAnimation.update(f2, 0.4f);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setVariant(this.random.nextInt(3));
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setDisturbed(compound.getBoolean("Disturbed"));
        this.setVariant(compound.getInt("Variant"));
        this.weatherCooldown = compound.getInt("WeatherCooldown");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Disturbed", this.isDisturbed());
        compound.putInt("Variant", this.getVariant());
        compound.putInt("WeatherCooldown", this.weatherCooldown);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        InteractionResult type = super.mobInteract(player, hand);
        if (item instanceof ShovelItem && (this.isBurrowed() || !this.isDisturbed()) && !this.level().isClientSide) {
            this.ambientSoundTime = 1000;
            if (!player.isCreative() && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                itemstack.hurtAndBreak(1, (LivingEntity)sp, EquipmentSlot.MAINHAND);
            }
            this.setStanceTime(20 + this.random.nextInt(30));
            this.setBurrowed(false);
            this.setDisturbed(true);
            this.burrowCooldown += 150 + this.random.nextInt(120);
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            this.playSound(SoundEvents.SAND_BREAK, this.getSoundVolume(), this.getVoicePitch());
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public void travel(Vec3 travelVector) {
        if (this.isBurrowed() || this.getDanceTime() > 0) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            travelVector = Vec3.ZERO;
            super.travel(travelVector);
            return;
        }
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    @Override
    public void onFindTarget(ItemEntity e) {
        this.setBurrowed(false);
        this.burrowCooldown += 50;
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.is(AMTagRegistry.INSECT_ITEMS);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.setAttackTime(10);
        this.heal(2.0f);
    }

    private void changeWeather() {
        Level level;
        int time = 24000 + 1200 * this.random.nextInt(10);
        int type = 0;
        if (!this.level().isRaining()) {
            type = this.random.nextInt(1) + 1;
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (type == 0) {
                serverLevel.setWeatherParameters(time, 0, false, false);
            } else {
                serverLevel.setWeatherParameters(0, time, true, type == 2);
            }
        }
        this.weatherCooldown = time + 24000;
    }

    public void setRecordPlayingNearby(BlockPos pos, boolean isPartying) {
        AlexsMobs.sendMSGToServer(new MessageStartDancing(this.getId(), isPartying, pos));
        if (isPartying) {
            this.setJukeboxPos(pos);
        } else {
            this.setJukeboxPos(null);
        }
    }

    @Override
    public void setDancing(boolean dancing) {
        this.setDanceTime(dancing && this.weatherCooldown == 0 ? 240 + this.random.nextInt(200) : 0);
    }

    @Override
    public void setJukeboxPos(BlockPos pos) {
        this.jukeboxPosition = pos;
    }

    protected SoundEvent getAmbientSound() {
        return this.getStanceTime() > 0 ? (SoundEvent)AMSoundRegistry.RAIN_FROG_HURT.get() : (SoundEvent)AMSoundRegistry.RAIN_FROG_IDLE.get();
    }

    public int getAmbientSoundInterval() {
        return this.getStanceTime() > 0 ? 10 : 80;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.RAIN_FROG_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.RAIN_FROG_HURT.get();
    }

    private class AIBurrow
    extends Goal {
        private BlockPos sand = null;
        private int burrowedTime = 0;

        public AIBurrow() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (!EntityRainFrog.this.isBurrowed() && EntityRainFrog.this.burrowCooldown == 0 && EntityRainFrog.this.random.nextInt(200) == 0) {
                this.burrowedTime = 0;
                this.sand = this.findSand();
                return this.sand != null;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.burrowedTime < 300;
        }

        public BlockPos findSand() {
            BlockPos blockpos = null;
            for (BlockPos blockpos1 : BlockPos.betweenClosed((int)Mth.floor((double)(EntityRainFrog.this.getX() - 4.0)), (int)Mth.floor((double)(EntityRainFrog.this.getY() - 1.0)), (int)Mth.floor((double)(EntityRainFrog.this.getZ() - 4.0)), (int)Mth.floor((double)(EntityRainFrog.this.getX() + 4.0)), (int)EntityRainFrog.this.getBlockY(), (int)Mth.floor((double)(EntityRainFrog.this.getZ() + 4.0)))) {
                if (!EntityRainFrog.this.level().getBlockState(blockpos1).is(BlockTags.SAND)) continue;
                blockpos = blockpos1;
                break;
            }
            return blockpos;
        }

        public void tick() {
            if (EntityRainFrog.this.isBurrowed()) {
                ++this.burrowedTime;
                if (!EntityRainFrog.this.getBlockStateOn().is(BlockTags.SAND)) {
                    EntityRainFrog.this.setBurrowed(false);
                }
            } else if (this.sand != null) {
                EntityRainFrog.this.getNavigation().moveTo((double)((float)this.sand.getX() + 0.5f), (double)((float)this.sand.getY() + 1.0f), (double)((float)this.sand.getZ() + 0.5f), 1.0);
                if (EntityRainFrog.this.getBlockStateOn().is(BlockTags.SAND)) {
                    EntityRainFrog.this.setBurrowed(true);
                    EntityRainFrog.this.getNavigation().stop();
                    this.sand = null;
                } else {
                    EntityRainFrog.this.setBurrowed(false);
                }
            }
        }

        public void stop() {
            EntityRainFrog.this.setBurrowed(false);
            EntityRainFrog.this.burrowCooldown = 120 + EntityRainFrog.this.random.nextInt(1200);
            this.sand = null;
        }
    }
}

