/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityMurmurHead;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeaveWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityMurmur
extends Monster
implements ISemiAquatic {
    private static final EntityDataAccessor<Optional<UUID>> HEAD_UUID = SynchedEntityData.defineId(EntityMurmur.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> HEAD_ID = SynchedEntityData.defineId(EntityMurmur.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean renderFakeHead = true;

    protected EntityMurmur(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.xpReward = 10;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.3f).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AnimalAILeaveWater((PathfinderMob)this));
        this.goalSelector.addGoal(2, (Goal)new AnimalAIWanderRanged((PathfinderMob)this, 55, 1.0, 14, 7));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.MURMUR_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.MURMUR_HURT.get();
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
    }

    public static <T extends Mob> boolean checkMurmurSpawnRules(EntityType<EntityMurmur> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return reason == MobSpawnType.SPAWNER || !iServerWorld.canSeeSky(pos) && (pos.getY() <= AMConfig.murmurSpawnHeight || iServerWorld.getBiome(pos).is(AMTagRegistry.SPAWNS_MURMURS_IGNORE_HEIGHT)) && EntityMurmur.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)iServerWorld, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.murmurSpawnRolls, this.getRandom(), spawnReasonIn) && super.checkSpawnRules(worldIn, spawnReasonIn);
    }

    public boolean isAlliedTo(Entity entity) {
        return this.getHeadUUID() != null && entity.getUUID().equals(this.getHeadUUID()) || super.isAlliedTo(entity);
    }

    protected float getStandingEyeHeight(Pose pose, EntityDimensions dimensions) {
        return dimensions.height() * 1.2f;
    }

    protected float getWaterSlowDown() {
        return 0.9f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HEAD_UUID, Optional.empty());
        builder.define(HEAD_ID, (Object)-1);
    }

    @Nullable
    public UUID getHeadUUID() {
        return ((Optional)this.entityData.get(HEAD_UUID)).orElse(null);
    }

    public void setHeadUUID(@Nullable UUID uniqueId) {
        this.entityData.set(HEAD_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getHead() {
        if (!this.level().isClientSide) {
            UUID id = this.getHeadUUID();
            return id == null ? null : ((ServerLevel)this.level()).getEntity(id);
        }
        int id = (Integer)this.entityData.get(HEAD_ID);
        return id == -1 ? null : this.level().getEntity(id);
    }

    public boolean shouldRenderFakeHead() {
        return this.renderFakeHead;
    }

    public void tick() {
        Entity head;
        super.tick();
        if (this.renderFakeHead) {
            this.renderFakeHead = false;
        }
        this.yBodyRot = this.getYRot();
        this.yHeadRot = Mth.clamp((float)this.yHeadRot, (float)(this.yBodyRot - 70.0f), (float)(this.yBodyRot + 70.0f));
        if (!this.level().isClientSide && (head = this.getHead()) == null) {
            LivingEntity created = this.createHead();
            this.setHeadUUID(created.getUUID());
            this.entityData.set(HEAD_ID, (Object)created.getId());
        }
    }

    public Vec3 getNeckBottom(float partialTick) {
        double d0 = Mth.lerp((double)partialTick, (double)this.xo, (double)this.getX());
        double d1 = Mth.lerp((double)partialTick, (double)this.yo, (double)this.getY());
        double d2 = Mth.lerp((double)partialTick, (double)this.zo, (double)this.getZ());
        double height = (double)(this.getBbHeight() - 0.4f) + this.calculateWalkBounce(partialTick);
        Vec3 rotatedOnDeath = new Vec3(0.0, height, 0.0);
        if (this.deathTime > 0) {
            float f = ((float)this.deathTime + partialTick - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt((float)f)) > 1.0f) {
                f = 1.0f;
            }
            rotatedOnDeath = rotatedOnDeath.add((double)(f * 0.1f), (double)(f * 0.4f), 0.0).zRot((float)((double)f * Math.PI / 2.0)).yRot(-this.yBodyRot * ((float)Math.PI / 180));
        }
        return new Vec3(d0, d1, d2).add(rotatedOnDeath);
    }

    public double calculateWalkBounce(float partialTick) {
        float limbSwingAmount = this.walkAnimation.speed(partialTick);
        float limbSwing = this.walkAnimation.position() - this.walkAnimation.speed() * (1.0f - partialTick);
        return Math.abs(Math.sin(limbSwing * 0.9f) * (double)limbSwingAmount * 0.25);
    }

    @Override
    public boolean shouldEnterWater() {
        return false;
    }

    @Override
    public boolean shouldLeaveWater() {
        return true;
    }

    @Override
    public boolean shouldStopMoving() {
        return false;
    }

    @Override
    public int getWaterSearchRange() {
        return 5;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("HeadUUID")) {
            this.setHeadUUID(compound.getUUID("HeadUUID"));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getHeadUUID() != null) {
            compound.putUUID("HeadUUID", this.getHeadUUID());
        }
    }

    private LivingEntity createHead() {
        EntityMurmurHead head = new EntityMurmurHead(this);
        this.level().addFreshEntity((Entity)head);
        return head;
    }

    public boolean isAngry() {
        Entity entity = this.getHead();
        if (entity instanceof EntityMurmurHead) {
            return ((EntityMurmurHead)entity).isAngry();
        }
        return false;
    }
}

