/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.IDancingMob;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.misc.AMPointOfInterestRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.alexsmobs.network.MessageStartDancing;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityLeafcutterAnthill;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityManedWolf
extends Animal
implements ITargetsDroppedItems,
IDancingMob {
    private static final EntityDataAccessor<Float> EAR_PITCH = SynchedEntityData.defineId(EntityManedWolf.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> EAR_YAW = SynchedEntityData.defineId(EntityManedWolf.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> DANCING = SynchedEntityData.defineId(EntityManedWolf.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> SHAKING_TIME = SynchedEntityData.defineId(EntityManedWolf.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final Ingredient allFoods = Ingredient.fromValues(Stream.of(new Ingredient.TagValue(AMTagRegistry.MANED_WOLF_BREEDABLES), new Ingredient.TagValue(AMTagRegistry.MANED_WOLF_STENCH_FOODS)));
    public float prevEarPitch;
    public float prevEarYaw;
    public float prevDanceProgress;
    public float danceProgress;
    public float prevShakeProgress;
    public float shakeProgress;
    private int earCooldown = 0;
    private float targetPitch;
    private float targetYaw;
    private boolean isJukeboxing;
    private BlockPos jukeboxPosition;
    private BlockPos nearestAnthill;

    protected EntityManedWolf(EntityType<? extends Animal> animal, Level level) {
        super(animal, level);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.manedWolfSpawnRolls, this.getRandom(), spawnReasonIn) && super.checkSpawnRules(worldIn, spawnReasonIn);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)allFoods, false));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 60));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, new CreatureAITargetItems((PathfinderMob)this, false, 30));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(EAR_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(EAR_YAW, (Object)Float.valueOf(0.0f));
        builder.define(SHAKING_TIME, (Object)0);
        builder.define(DANCING, (Object)false);
    }

    public float getEarYaw() {
        return ((Float)this.entityData.get(EAR_YAW)).floatValue();
    }

    public void setEarYaw(float yaw) {
        this.entityData.set(EAR_YAW, (Object)Float.valueOf(yaw));
    }

    public float getEarPitch() {
        return ((Float)this.entityData.get(EAR_PITCH)).floatValue();
    }

    public void setEarPitch(float pitch) {
        this.entityData.set(EAR_PITCH, (Object)Float.valueOf(pitch));
    }

    public boolean isDancing() {
        return (Boolean)this.entityData.get(DANCING);
    }

    @Override
    public void setDancing(boolean dancing) {
        this.entityData.set(DANCING, (Object)dancing);
        this.isJukeboxing = dancing;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.MANED_WOLF_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.MANED_WOLF_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.MANED_WOLF_HURT.get();
    }

    private void attractAnimals() {
        if (this.getShakingTime() % 5 == 0) {
            List list = this.level().getEntitiesOfClass(Animal.class, this.getBoundingBox().inflate(16.0, 8.0, 16.0));
            for (Animal e : list) {
                TamableAnimal tamedMob;
                if (e instanceof EntityManedWolf || e instanceof TamableAnimal && (tamedMob = (TamableAnimal)e).isInSittingPose()) continue;
                e.setTarget(null);
                e.setLastHurtByMob(null);
                Vec3 vec = LandRandomPos.getPosTowards((PathfinderMob)e, (int)20, (int)7, (Vec3)this.position());
                if (vec == null) continue;
                e.getNavigation().moveTo(vec.x, vec.y, vec.z, 1.5);
            }
        }
    }

    private void pollinateAnthill() {
        if (this.nearestAnthill != null && this.level().getBlockEntity(this.nearestAnthill) instanceof TileEntityLeafcutterAnthill) {
            if (this.getShakingTime() % 5 == 0) {
                this.getNavigation().moveTo((double)((float)this.nearestAnthill.getX() + 0.5f), (double)((float)this.nearestAnthill.getY() + 1.0f), (double)((float)this.nearestAnthill.getZ() + 0.5f), 1.0);
            }
            if (this.nearestAnthill.closerToCenterThan((Position)this.position(), 6.0) && this.getShakingTime() % 20 == 0) {
                ((TileEntityLeafcutterAnthill)this.level().getBlockEntity(this.nearestAnthill)).growFungus();
            }
        }
    }

    private void findAnthill() {
        if (this.nearestAnthill == null || !(this.level().getBlockEntity(this.nearestAnthill) instanceof TileEntityLeafcutterAnthill)) {
            PoiManager pointofinterestmanager = ((ServerLevel)this.level()).getPoiManager();
            Stream stream = pointofinterestmanager.findAll(poiTypeHolder -> poiTypeHolder.is(AMPointOfInterestRegistry.LEAFCUTTER_ANT_HILL.getKey()), (Predicate)Predicates.alwaysTrue(), this.blockPosition(), 10, PoiManager.Occupancy.ANY);
            List listOfHives = stream.collect(Collectors.toList());
            BlockPos nearest = null;
            for (BlockPos pos : listOfHives) {
                if (nearest != null && !(pos.distSqr((Vec3i)this.blockPosition()) < nearest.distSqr((Vec3i)this.blockPosition()))) continue;
                nearest = pos;
            }
            this.nearestAnthill = nearest;
        }
    }

    @Override
    public void setJukeboxPos(BlockPos pos) {
        this.jukeboxPosition = pos;
    }

    public boolean isShaking() {
        return this.getShakingTime() > 0;
    }

    public int getShakingTime() {
        return (Integer)this.entityData.get(SHAKING_TIME);
    }

    public void setShakingTime(int shaking) {
        this.entityData.set(SHAKING_TIME, (Object)shaking);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        InteractionResult type = super.mobInteract(player, hand);
        if (itemstack.is(AMTagRegistry.MANED_WOLF_STENCH_FOODS) && !this.isShaking() && this.getMainHandItem().isEmpty()) {
            this.usePlayerItem(player, hand, itemstack);
            this.eatItemEffect(itemstack);
            this.setShakingTime(100 + this.random.nextInt(30));
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    private void eatItemEffect(ItemStack heldItemMainhand) {
        for (int i = 0; i < 2 + this.random.nextInt(2); ++i) {
            double d2 = this.random.nextGaussian() * 0.02;
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            float radius = this.getBbWidth() * 0.65f;
            float angle = (float)Math.PI / 180 * this.yBodyRot;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            ItemParticleOption data = new ItemParticleOption(ParticleTypes.ITEM, heldItemMainhand);
            if (heldItemMainhand.getItem() instanceof BlockItem) {
                data = new BlockParticleOption(ParticleTypes.BLOCK, ((BlockItem)heldItemMainhand.getItem()).getBlock().defaultBlockState());
            }
            this.level().addParticle((ParticleOptions)data, this.getX() + extraX, this.getY() + (double)(this.getBbHeight() * 0.6f), this.getZ() + extraZ, d0, d1, d2);
        }
    }

    public void tick() {
        super.tick();
        this.prevEarPitch = this.getEarPitch();
        this.prevEarYaw = this.getEarYaw();
        this.prevDanceProgress = this.danceProgress;
        this.prevShakeProgress = this.shakeProgress;
        if (!this.level().isClientSide) {
            this.updateEars();
        }
        boolean dance = this.isDancing();
        if (this.jukeboxPosition == null || !this.jukeboxPosition.closerToCenterThan((Position)this.position(), 15.0) || !this.level().getBlockState(this.jukeboxPosition).is(Blocks.JUKEBOX)) {
            this.isJukeboxing = false;
            this.setDancing(false);
            this.jukeboxPosition = null;
        }
        if (dance && this.danceProgress < 5.0f) {
            this.danceProgress += 1.0f;
        }
        if (!dance && this.danceProgress > 0.0f) {
            this.danceProgress -= 1.0f;
        }
        if (this.isShaking() && this.shakeProgress < 5.0f) {
            this.shakeProgress += 1.0f;
        }
        if (!this.isShaking() && this.shakeProgress > 0.0f) {
            this.shakeProgress -= 1.0f;
        }
        if (this.isShaking()) {
            this.setShakingTime(this.getShakingTime() - 1);
            if (this.level().isClientSide) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = (double)0.05f + this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)AMParticleRegistry.SMELLY.get(), this.getRandomX(0.7f), this.getY(0.6f), this.getRandomZ(0.7f), d0, d1, d2);
            } else {
                this.attractAnimals();
                this.findAnthill();
                if (this.nearestAnthill != null) {
                    this.pollinateAnthill();
                }
            }
        }
    }

    private void updateEars() {
        float pitchDist = Math.abs(this.targetPitch - this.getEarPitch());
        float yawDist = Math.abs(this.targetYaw - this.getEarYaw());
        if (this.earCooldown <= 0 && this.random.nextInt(30) == 0 && pitchDist <= 0.1f && yawDist <= 0.1f) {
            this.targetPitch = Mth.clamp((float)(this.random.nextFloat() * 60.0f - 30.0f), (float)-30.0f, (float)30.0f);
            this.targetYaw = Mth.clamp((float)(this.random.nextFloat() * 60.0f - 30.0f), (float)-30.0f, (float)30.0f);
            this.earCooldown = 8 + this.random.nextInt(15);
        }
        if (pitchDist > 0.1f) {
            if (this.getEarPitch() < this.targetPitch) {
                this.setEarPitch(this.getEarPitch() + Math.min(pitchDist, 4.0f));
            }
            if (this.getEarPitch() > this.targetPitch) {
                this.setEarPitch(this.getEarPitch() - Math.min(pitchDist, 4.0f));
            }
        }
        if (yawDist > 0.1f) {
            if (this.getEarYaw() < this.targetYaw) {
                this.setEarYaw(this.getEarYaw() + Math.min(yawDist, 4.0f));
            }
            if (this.getEarYaw() > this.targetYaw) {
                this.setEarYaw(this.getEarYaw() - Math.min(yawDist, 4.0f));
            }
        }
        if (this.earCooldown > 0) {
            --this.earCooldown;
        }
    }

    public boolean isFood(ItemStack stack) {
        return !stack.is(AMTagRegistry.MANED_WOLF_STENCH_FOODS) && allFoods.test(stack);
    }

    public void travel(Vec3 vec3d) {
        if (this.isDancing() || this.danceProgress > 0.0f) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            vec3d = Vec3.ZERO;
        }
        super.travel(vec3d);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return allFoods.test(stack) && !this.isShaking();
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.eatItemEffect(e.getItem());
        if (e.getItem().is(AMTagRegistry.MANED_WOLF_STENCH_FOODS)) {
            this.setShakingTime(100 + this.random.nextInt(30));
        }
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return (AgeableMob)((EntityType)AMEntityRegistry.MANED_WOLF.get()).create((Level)serverWorld);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRecordPlayingNearby(BlockPos pos, boolean isPartying) {
        AlexsMobs.sendMSGToServer(new MessageStartDancing(this.getId(), isPartying, pos));
        this.setDancing(isPartying);
        if (isPartying) {
            this.setJukeboxPos(pos);
        } else {
            this.setJukeboxPos(null);
        }
    }

    public boolean isEnder() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return s != null && (s.toLowerCase().contains("plummet") || s.toLowerCase().contains("ender"));
    }
}

