/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.EntityLaviathan;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;

public class EntityLaviathanPart
extends PartEntity<EntityLaviathan> {
    private final EntityDimensions size;
    public float scale = 1.0f;

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public EntityLaviathanPart(EntityLaviathan parent, float sizeX, float sizeY) {
        super((Entity)parent);
        this.size = EntityDimensions.scalable((float)sizeX, (float)sizeY);
        this.refreshDimensions();
    }

    public EntityLaviathanPart(EntityLaviathan entityCachalotWhale, float sizeX, float sizeY, EntityDimensions size) {
        super((Entity)entityCachalotWhale);
        this.size = size;
    }

    public boolean fireImmune() {
        return true;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)this.getEyeHeight() * (double)0.15f, (double)(this.getBbWidth() * 0.1f));
    }

    protected void collideWithNearbyEntities() {
    }

    public InteractionResult getEntityInteractionResult(Player player, InteractionHand hand) {
        return this.getParent() == null ? InteractionResult.PASS : ((EntityLaviathan)this.getParent()).mobInteract(player, hand);
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    protected void collideWithEntity(Entity entityIn) {
        if (!(entityIn instanceof EntityLaviathan)) {
            entityIn.push((Entity)this);
        }
    }

    public boolean isPickable() {
        return true;
    }

    @Nullable
    public ItemStack getPickResult() {
        Entity parent = this.getParent();
        return parent != null ? parent.getPickResult() : ItemStack.EMPTY;
    }

    public boolean hurt(DamageSource source, float amount) {
        return !this.isInvulnerableTo(source) && ((EntityLaviathan)this.getParent()).attackEntityPartFrom(this, source, amount);
    }

    public boolean is(Entity entityIn) {
        return this == entityIn || this.getParent() == entityIn;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        throw new UnsupportedOperationException();
    }

    protected void defineSynchedData() {
    }

    public void tick() {
        super.tick();
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }
}

